/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public abstract class BeanConfigurable<T>
implements UnnamedConfigurable {
    private final T myInstance;
    private final List<BeanField> myFields = new ArrayList<BeanField>();

    protected BeanConfigurable(T beanInstance) {
        this.myInstance = beanInstance;
    }

    protected void checkBox(@NonNls String fieldName, String title) {
        this.myFields.add(new CheckboxField(fieldName, title));
    }

    @Override
    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridLayout(this.myFields.size(), 1));
        for (BeanField field : this.myFields) {
            panel.add((Component)field.getComponent());
        }
        return panel;
    }

    @Override
    public boolean isModified() {
        for (BeanField field : this.myFields) {
            if (!field.isModified(this.myInstance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply() throws ConfigurationException {
        for (BeanField field : this.myFields) {
            field.apply(this.myInstance);
        }
    }

    @Override
    public void reset() {
        for (BeanField field : this.myFields) {
            field.reset(this.myInstance);
        }
    }

    @Override
    public void disposeUIResources() {
    }

    private static class CheckboxField
    extends BeanField<JCheckBox> {
        private final String myTitle;

        private CheckboxField(String fieldName, String title) {
            super(fieldName);
            this.myTitle = title;
        }

        @Override
        JCheckBox createComponent() {
            return new JCheckBox(this.myTitle);
        }

        @Override
        Object getComponentValue() {
            return ((JCheckBox)this.getComponent()).isSelected();
        }

        @Override
        void setComponentValue(Object instance) {
            ((JCheckBox)this.getComponent()).setSelected((Boolean)instance);
        }

        @Override
        protected String getterName() {
            return "is" + StringUtil.capitalize((String)this.myFieldName);
        }

        @Override
        protected Class getValueClass() {
            return Boolean.TYPE;
        }
    }

    private static abstract class BeanField<T extends JComponent> {
        String myFieldName;
        T myComponent;

        private BeanField(String fieldName) {
            this.myFieldName = fieldName;
        }

        T getComponent() {
            if (this.myComponent == null) {
                this.myComponent = this.createComponent();
            }
            return this.myComponent;
        }

        abstract T createComponent();

        boolean isModified(Object instance) {
            Object beanValue;
            Object componentValue = this.getComponentValue();
            return !Comparing.equal((Object)componentValue, (Object)(beanValue = this.getBeanValue(instance)));
        }

        void apply(Object instance) {
            this.setBeanValue(instance, this.getComponentValue());
        }

        void reset(Object instance) {
            this.setComponentValue(this.getBeanValue(instance));
        }

        abstract Object getComponentValue();

        abstract void setComponentValue(Object var1);

        Object getBeanValue(Object instance) {
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                return field.get(instance);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = instance.getClass().getMethod(this.getterName(), new Class[0]);
                    return method.invoke(instance, new Object[0]);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @NonNls
        protected String getterName() {
            return "get" + StringUtil.capitalize((String)this.myFieldName);
        }

        void setBeanValue(Object instance, Object value) {
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                field.set(instance, value);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = instance.getClass().getMethod("set" + StringUtil.capitalize((String)this.myFieldName), this.getValueClass());
                    method.invoke(instance, value);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract Class getValueClass();
    }
}

