/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.config;

import com.intellij.cdi.actions.CreateBeansXmlAction;
import com.intellij.cdi.config.CdiLibraryType;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.framework.FrameworkGroup;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.LibraryBasedFrameworkSupportProvider;
import com.intellij.framework.library.LibraryBasedFrameworkType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.javaee.framework.JavaeeFrameworkGroup;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiFrameworkType
extends LibraryBasedFrameworkType {
    protected CdiFrameworkType() {
        super("CDI", CdiLibraryType.class);
    }

    @NotNull
    public String getPresentableName() {
        String string = CdiBundle.message("cdi.jsr.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/config/CdiFrameworkType", "getPresentableName"));
        }
        return string;
    }

    @Nullable
    public FrameworkGroup<?> getParentGroup() {
        return JavaeeFrameworkGroup.INSTANCE;
    }

    @NotNull
    public FrameworkSupportInModuleProvider createProvider() {
        LibraryBasedFrameworkSupportProvider libraryBasedFrameworkSupportProvider = new LibraryBasedFrameworkSupportProvider((FrameworkTypeEx)this, this.getLibraryTypeClass()){

            @NotNull
            public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/cdi/config/CdiFrameworkType$1", "createConfigurable"));
                }
                MyGenerateConfigurable myGenerateConfigurable = new MyGenerateConfigurable();
                if (myGenerateConfigurable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/config/CdiFrameworkType$1", "createConfigurable"));
                }
                return myGenerateConfigurable;
            }

            public List<FrameworkSupportInModuleProvider.FrameworkDependency> getDependenciesFrameworkIds() {
                return Collections.singletonList(FrameworkSupportInModuleProvider.FrameworkDependency.optional((String)"web"));
            }
        };
        if (libraryBasedFrameworkSupportProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/config/CdiFrameworkType", "createProvider"));
        }
        return libraryBasedFrameworkSupportProvider;
    }

    @Nullable
    private static String getWebInfPath(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/cdi/config/CdiFrameworkType", "getWebInfPath"));
        }
        for (WebRoot root : webFacet.getWebRoots()) {
            VirtualFile file = root.getFile();
            if (file == null || file.findChild("WEB-INF") == null) continue;
            return root.getDirectoryUrl() + "/WEB-INF/";
        }
        return ((WebRoot)webFacet.getWebRoots().get(0)).getDirectoryUrl() + "/WEB-INF/";
    }

    @Nullable
    private static String getMetaInfPath(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/cdi/config/CdiFrameworkType", "getMetaInfPath"));
        }
        VirtualFile[] roots = rootModel.getSourceRoots();
        String defaultPath = null;
        for (VirtualFile file : roots) {
            String path = file.getUrl() + "/META-INF/";
            if (file.findChild("META-INF") != null) {
                return path;
            }
            defaultPath = path;
        }
        return defaultPath;
    }

    private static void createBeansXmlInWriteCommandAction(final @NotNull Module module, final @NotNull String path) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/config/CdiFrameworkType", "createBeansXmlInWriteCommandAction"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/cdi/config/CdiFrameworkType", "createBeansXmlInWriteCommandAction"));
        }
        new WriteCommandAction.Simple(module.getProject(), new PsiFile[0]){

            protected void run() {
                try {
                    FileTemplate template;
                    File configFile = new File(FileUtil.toSystemDependentName((String)path));
                    if (!configFile.exists() && (template = FileTemplateManager.getInstance((Project)module.getProject()).getJ2eeTemplate(CreateBeansXmlAction.chooseFileTemplate(module))) != null) {
                        FileUtil.createIfDoesntExist((File)configFile);
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configFile);
                        if (file != null) {
                            String text = template.getText();
                            VfsUtil.saveText((VirtualFile)file, (String)text);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.execute();
    }

    private class MyGenerateConfigurable
    extends FrameworkSupportInModuleConfigurable {
        private JCheckBox myCreateBeansXml = new JCheckBox("Create beans.xml");

        private MyGenerateConfigurable() {
        }

        public JComponent createComponent() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
            panel.add((Component)this.myCreateBeansXml, gc);
            this.myCreateBeansXml.setSelected(true);
            return panel;
        }

        public void addSupport(final @NotNull Module module, final @NotNull ModifiableRootModel rootModel, final @NotNull ModifiableModelsProvider modifiableModelsProvider) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/config/CdiFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/cdi/config/CdiFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            if (modifiableModelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "com/intellij/cdi/config/CdiFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            final Project project = module.getProject();
            if (this.myCreateBeansXml.isSelected()) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                    @Override
                    public void run() {
                        DumbService.getInstance((Project)project).runWhenSmart(new Runnable(){

                            @Override
                            public void run() {
                                WebFacet webFacet = (WebFacet)modifiableModelsProvider.getFacetModifiableModel(module).findFacet(WebFacet.ID, "Web");
                                String path = webFacet != null ? CdiFrameworkType.getWebInfPath(webFacet) : CdiFrameworkType.getMetaInfPath(rootModel);
                                if (path != null) {
                                    String beansXmlPath = VfsUtilCore.urlToPath((String)(path + "beans.xml"));
                                    CdiFrameworkType.createBeansXmlInWriteCommandAction(module, beansXmlPath);
                                }
                            }
                        });
                    }
                });
            }
        }

        public CustomLibraryDescription createLibraryDescription() {
            return DownloadableLibraryService.getInstance().createDescriptionForType(CdiFrameworkType.this.getLibraryTypeClass());
        }
    }
}

