/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiDecoratorInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/highlighting/CdiDecoratorInspection", "checkClass"));
        }
        PsiAnnotation decoratorAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"javax.decorator.Decorator"});
        if (decoratorAnno != null) {
            CdiDecoratorInspection.checkDecoratorIsNotFinal(psiClass, holder);
            CdiDecoratorInspection.checkDecoratesInjectionPoints(psiClass, holder, decoratorAnno);
            CdiDecoratorInspection.checkInconsistentAnnotations(psiClass, holder, decoratorAnno, "javax.interceptor.Interceptor");
        } else {
            CdiDecoratorInspection.checkDelegateIncosistency(psiClass, holder);
        }
    }

    private static void checkDecoratorIsNotFinal(PsiClass psiClass, ProblemsHolder holder) {
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList != null && modifierList.hasModifierProperty("final")) {
            holder.registerProblem((PsiElement)psiClass.getNameIdentifier(), CdiInspectionBundle.message("CdiDecoratorInspection.class.cannot.be.final", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkDelegateIncosistency(PsiClass psiClass, ProblemsHolder holder) {
        for (Pair<PsiAnnotation, PsiModifierListOwner> pair : CdiDecoratorInspection.getDecoratesInjectionPoints(psiClass)) {
            PsiElement elementToHighlight = CdiDecoratorInspection.getNameIdentifier((PsiModifierListOwner)pair.getSecond());
            if (elementToHighlight == null) continue;
            holder.registerProblem(elementToHighlight, CdiInspectionBundle.message("CdiDecoratorInspection.class.must.be.decorator", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkInconsistentAnnotations(PsiClass psiClass, ProblemsHolder holder, PsiAnnotation decoratorAnno, String annotation) {
        PsiAnnotation anno = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{annotation});
        if (anno != null) {
            holder.registerProblem((PsiElement)decoratorAnno, CdiInspectionBundle.message("CdiDecoratorInspection.annotation.not.allowed.for.decorator", anno.getQualifiedName()), new LocalQuickFix[0]);
        }
    }

    private static void checkDecoratesInjectionPoints(PsiClass psiClass, ProblemsHolder holder, PsiAnnotation decoratorAnno) {
        Set<Pair<PsiAnnotation, PsiModifierListOwner>> decorates = CdiDecoratorInspection.getDecoratesInjectionPoints(psiClass);
        if (decorates.size() == 0) {
            holder.registerProblem((PsiElement)decoratorAnno, CdiInspectionBundle.message("CdiDecoratorInspection.cannot.find.decorates", new Object[0]), new LocalQuickFix[0]);
        }
        if (decorates.size() > 1) {
            holder.registerProblem((PsiElement)decoratorAnno, CdiInspectionBundle.message("CdiDecoratorInspection.too.many.decorates.in.decorator", new Object[0]), new LocalQuickFix[0]);
        }
        for (Pair<PsiAnnotation, PsiModifierListOwner> decorate : decorates) {
            CdiDecoratorInspection.checkIsInterfaceAndImplementsAllDecoratorInterfaces(holder, decorate, psiClass);
            CdiDecoratorInspection.checkIsDelegateInjected(holder, decorate);
        }
    }

    private static void checkIsDelegateInjected(ProblemsHolder holder, Pair<PsiAnnotation, PsiModifierListOwner> decorate) {
        PsiField field;
        PsiModifierListOwner owner = (PsiModifierListOwner)decorate.getSecond();
        if (owner instanceof PsiParameter) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiMethod.class);
            if (method != null) {
                if (method.isConstructor() || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"javax.inject.Inject", (boolean)false)) {
                    return;
                }
                holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiDecoratorInspection.injection.point.must.be.constructor.or.inializer", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (owner instanceof PsiField && !AnnotationUtil.isAnnotated((PsiModifierListOwner)(field = (PsiField)owner), (String)"javax.inject.Inject", (boolean)true)) {
            holder.registerProblem((PsiElement)field.getNameIdentifier(), CdiInspectionBundle.message("CdiDecoratorInspection.delegate.injection.point.expected", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkIsInterfaceAndImplementsAllDecoratorInterfaces(ProblemsHolder holder, Pair<PsiAnnotation, PsiModifierListOwner> decorate, PsiClass psiClass) {
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)decorate.second;
        PsiType type = CdiDecoratorInspection.getType(modifierListOwner);
        PsiElement elementToHighlight = CdiDecoratorInspection.getNameIdentifier(modifierListOwner);
        if (type == null) {
            return;
        }
        final PsiClass decoratesClass = ((PsiClassType)type).resolve();
        HashSet unsupportedInterfaces = new HashSet();
        InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)false, (Processor)new Processor<PsiClass>((Set)unsupportedInterfaces){
            final /* synthetic */ Set val$unsupportedInterfaces;
            {
                this.val$unsupportedInterfaces = set;
            }

            public boolean process(PsiClass psiClass) {
                if (psiClass.isInterface() && !InheritanceUtil.isInheritorOrSelf((PsiClass)decoratesClass, (PsiClass)psiClass, (boolean)true)) {
                    this.val$unsupportedInterfaces.add(psiClass.getQualifiedName());
                }
                return true;
            }
        });
        if (unsupportedInterfaces.size() > 0) {
            String[] strings = ArrayUtil.toStringArray((Collection)unsupportedInterfaces);
            holder.registerProblem(elementToHighlight, CdiInspectionBundle.message("CdiDecoratorInspection.decorates.type.must.implements.all.decorator.interfaces", StringUtil.join((String[])strings, (String)",")), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static PsiElement getNameIdentifier(PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner instanceof PsiField) {
            return ((PsiField)modifierListOwner).getNameIdentifier();
        }
        if (modifierListOwner instanceof PsiParameter) {
            return ((PsiParameter)modifierListOwner).getNameIdentifier();
        }
        return null;
    }

    @Nullable
    private static PsiType getType(PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner instanceof PsiField) {
            return ((PsiField)modifierListOwner).getType();
        }
        if (modifierListOwner instanceof PsiParameter) {
            return ((PsiParameter)modifierListOwner).getType();
        }
        return null;
    }

    private static boolean isInterface(PsiType type) {
        PsiClass psiClass;
        if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null) {
            return psiClass.isInterface();
        }
        return false;
    }

    @NotNull
    private static Set<Pair<PsiAnnotation, PsiModifierListOwner>> getDecoratesInjectionPoints(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/highlighting/CdiDecoratorInspection", "getDecoratesInjectionPoints"));
        }
        HashSet decorates = new HashSet();
        for (PsiField psiField : psiClass.getFields()) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, (String[])new String[]{"javax.decorator.Delegate"});
            if (annotation == null) continue;
            decorates.add(new Pair((Object)annotation, (Object)psiField));
        }
        for (PsiField psiField : psiClass.getMethods()) {
            for (PsiParameter psiParameter : psiField.getParameterList().getParameters()) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiParameter, (String[])new String[]{"javax.decorator.Delegate"});
                if (annotation == null) continue;
                decorates.add(new Pair((Object)annotation, (Object)psiParameter));
            }
        }
        HashSet hashSet = decorates;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiDecoratorInspection", "getDecoratesInjectionPoints"));
        }
        return hashSet;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.decorator.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiDecoratorInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiDecoratorInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiDecoratorInspection", "getShortName"));
        }
        return "CdiDecoratorInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiDecoratorInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

