/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.FtlArgumentDependentBuiltIn;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlCollectionType;
import com.intellij.freemarker.psi.FtlDateType;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlNodeType;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlCompositeType;
import com.intellij.freemarker.psi.variables.FtlCustomVariable;
import com.intellij.freemarker.psi.variables.FtlHashType;
import com.intellij.freemarker.psi.variables.FtlLightVariable;
import com.intellij.freemarker.psi.variables.FtlMethodType;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.NullableConstantFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlBuiltIns {
    private static final Set<FtlBuiltInDescriptor> ourBuiltIns;
    private static final Set<FtlBuiltInDescriptor> ourDeprecatedBuiltIns;
    private static final String[] DATE_FORMAT_ACCURACIES;

    private static void addDateFormatBuiltIns(final Function<FtlBuiltIn, FtlType> stringType) {
        for (String zone : (String[])ContainerUtil.ar((Object[])new String[]{"utc", "local"})) {
            String iso = "iso_" + zone;
            String camelIso = "iso" + StringUtil.capitalize((String)zone);
            ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn(iso, camelIso, stringType));
            ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn(iso + "_nz", camelIso + "NZ", stringType));
            for (String accuracy : DATE_FORMAT_ACCURACIES) {
                ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn(iso + "_" + accuracy, camelIso + StringUtil.capitalize((String)accuracy), stringType));
                ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn(iso + "_" + accuracy + "_nz", camelIso + StringUtil.capitalize((String)accuracy) + "NZ", stringType));
            }
        }
        Function<FtlBuiltIn, FtlType> formatFunction = new Function<FtlBuiltIn, FtlType>(){

            public FtlType fun(FtlBuiltIn in) {
                return FtlCallableType.createLightFunctionType(in, (FtlType)stringType.fun((Object)in), "format", (FtlType)stringType.fun((Object)in));
            }
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("iso", formatFunction));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("iso_nz", "isoNZ", formatFunction));
        for (String accuracy : DATE_FORMAT_ACCURACIES) {
            ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("iso_" + accuracy, "iso" + StringUtil.capitalize((String)accuracy), formatFunction));
            ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("iso_" + accuracy + "_nz", "iso" + StringUtil.capitalize((String)accuracy) + "NZ", formatFunction));
        }
    }

    @NotNull
    private static PsiClassType getStringType(PsiElement builtIn) {
        PsiClassType psiClassType = PsiType.getJavaLangString((PsiManager)builtIn.getManager(), (GlobalSearchScope)builtIn.getResolveScope());
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlBuiltIns", "getStringType"));
        }
        return psiClassType;
    }

    @NotNull
    public static List<FtlBuiltInDescriptor> getBuiltIns(final @Nullable FtlExpression qualifier, final @Nullable String name) {
        final FtlType qualifierType = qualifier == null ? null : qualifier.getType();
        Condition<FtlBuiltInDescriptor> condition = new Condition<FtlBuiltInDescriptor>(){

            public boolean value(FtlBuiltInDescriptor descriptor) {
                return !(name != null && !name.equals(descriptor.getCamelCaseName()) && !name.equals(descriptor.getSnakeCaseName()) || qualifierType != null && !descriptor.acceptsQualifier(qualifierType, qualifier));
            }
        };
        List list = ContainerUtil.findAll(ourBuiltIns, (Condition)condition);
        list.addAll(ContainerUtil.findAll(ourDeprecatedBuiltIns, (Condition)condition));
        List list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlBuiltIns", "getBuiltIns"));
        }
        return list2;
    }

    static {
        String[] object2Boolean;
        ourBuiltIns = new THashSet();
        ourDeprecatedBuiltIns = new THashSet();
        DATE_FORMAT_ACCURACIES = (String[])ContainerUtil.ar((Object[])new String[]{"h", "m", "ms"});
        Function<FtlBuiltIn, FtlType> stringType = new Function<FtlBuiltIn, FtlType>(){

            public FtlType fun(FtlBuiltIn builtIn) {
                return new FtlPsiType((PsiType)FtlBuiltIns.getStringType(builtIn));
            }
        };
        final FtlPsiType intType = FtlPsiType.wrap((PsiType)PsiType.INT);
        final FtlPsiType booleanType = FtlPsiType.wrap((PsiType)PsiType.BOOLEAN);
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("substring", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType, intType){
            final /* synthetic */ Function val$stringType;
            final /* synthetic */ FtlPsiType val$intType;
            {
                this.val$stringType = function;
                this.val$intType = ftlPsiType;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlType string = (FtlType)this.val$stringType.fun((Object)builtIn);
                return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, string, "from", this.val$intType), FtlCallableType.createLightFunctionType(builtIn, string, "from", this.val$intType, "toExclusive", this.val$intType));
            }
        }));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("boolean", (PsiType)PsiType.BOOLEAN));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("capFirst", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("uncapFirst", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("capitalize", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("chopLinebreak", stringType));
        NullableFunction<FtlBuiltIn, FtlType> formattedDateTime = new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlDateType date = FtlDateType.INSTANCE;
                return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, date, "format", (FtlType)this.val$stringType.fun((Object)builtIn)), date);
            }
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("date", (Function<FtlBuiltIn, FtlType>)formattedDateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("time", (Function<FtlBuiltIn, FtlType>)formattedDateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("datetime", (Function<FtlBuiltIn, FtlType>)formattedDateTime));
        NullableFunction<FtlBuiltIn, FtlType> containsType = new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                return FtlCallableType.createLightFunctionType(builtIn, booleanType, "substring", (FtlType)this.val$stringType.fun((Object)builtIn));
            }
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("endsWith", (Function<FtlBuiltIn, FtlType>)containsType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("ensureEndsWith", (Function<FtlBuiltIn, FtlType>)containsType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("ensureStartsWith", (Function<FtlBuiltIn, FtlType>)containsType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("html", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("xhtml", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("groups", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                return new FtlCollectionType((FtlType)this.val$stringType.fun((Object)builtIn));
            }
        }));
        NullableFunction<FtlBuiltIn, FtlType> indexOfType = new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, intType, "substring", (FtlType)this.val$stringType.fun((Object)builtIn)), FtlCallableType.createLightFunctionType(builtIn, intType, "substring", (FtlType)this.val$stringType.fun((Object)builtIn), "from", intType));
            }
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("indexOf", (Function<FtlBuiltIn, FtlType>)indexOfType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("lastIndexOf", (Function<FtlBuiltIn, FtlType>)indexOfType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("jString", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("jsString", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("jsonString", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("length", (PsiType)PsiType.INT));
        NullableFunction<FtlBuiltIn, FtlType> padType = new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType, intType){
            final /* synthetic */ Function val$stringType;
            final /* synthetic */ FtlPsiType val$intType;
            {
                this.val$stringType = function;
                this.val$intType = ftlPsiType;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlType string = (FtlType)this.val$stringType.fun((Object)builtIn);
                return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, string, "length", this.val$intType), FtlCallableType.createLightFunctionType(builtIn, string, "length", this.val$intType, "fillWith", string));
            }
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("leftPad", (Function<FtlBuiltIn, FtlType>)padType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("rightPad", (Function<FtlBuiltIn, FtlType>)padType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("contains", (Function<FtlBuiltIn, FtlType>)containsType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("matches", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlType string = (FtlType)this.val$stringType.fun((Object)builtIn);
                FtlCompositeType returnType = new FtlCompositeType(FtlPsiType.wrap((PsiType)PsiType.BOOLEAN), new FtlCollectionType(string));
                return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, returnType, "regex", string), FtlCallableType.createLightFunctionType(builtIn, returnType, "regex", string, "flags", string));
            }
        }));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("number", (PsiType)PsiType.INT));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("replace", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlType string = (FtlType)this.val$stringType.fun((Object)builtIn);
                return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, string, "substring", string, "replacement", string), FtlCallableType.createLightFunctionType(builtIn, string, "substring", string, "replacement", string, "flags", string));
            }
        }));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("rtf", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("url", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlType string = (FtlType)this.val$stringType.fun((Object)builtIn);
                return new FtlCompositeType(string, FtlCallableType.createLightFunctionType(builtIn, string, "locale", string));
            }
        }));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("split", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlType string = (FtlType)this.val$stringType.fun((Object)builtIn);
                FtlCollectionType returnType = new FtlCollectionType(string);
                return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, returnType, "separator", string), FtlCallableType.createLightFunctionType(builtIn, returnType, "separator", string, "flags", string));
            }
        }));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("startsWith", (Function<FtlBuiltIn, FtlType>)containsType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("string", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("trim", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("upperCase", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("lowerCase", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("wordList", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                return new FtlCollectionType((FtlType)this.val$stringType.fun((Object)builtIn));
            }
        }));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("xml", stringType));
        NullableFunction<FtlBuiltIn, FtlType> substringFunction = new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlType string = (FtlType)this.val$stringType.fun((Object)builtIn);
                return FtlCallableType.createLightFunctionType(builtIn, string, "substring", string);
            }
        };
        for (String s : (String[])ContainerUtil.ar((Object[])new String[]{"removeBeginning", "removeEnding", "keepBefore", "keepBeforeLast", "keepAfter", "keepAfterLast"})) {
            ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn(s, (Function<FtlBuiltIn, FtlType>)substringFunction));
        }
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("c", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("string", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlCustomVariable customVariable = new FtlCustomVariable("string", builtIn);
                FtlType string = (FtlType)this.val$stringType.fun((Object)builtIn);
                customVariable.addSubVariable(new FtlLightVariable("number", (PsiElement)builtIn, string));
                customVariable.addSubVariable(new FtlLightVariable("currency", (PsiElement)builtIn, string));
                customVariable.addSubVariable(new FtlLightVariable("percent", (PsiElement)builtIn, string));
                return new FtlCompositeType(string, new FtlHashType(customVariable), FtlCallableType.createLightFunctionType(builtIn, string, "format", string));
            }
        }));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("round", (PsiType)PsiType.INT));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("floor", (PsiType)PsiType.INT));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("ceiling", (PsiType)PsiType.INT));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("abs", (PsiType)PsiType.BYTE));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("upperAbc", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("lowerAbc", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("isInfinite", (PsiType)PsiType.BOOLEAN));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("isNan", (PsiType)PsiType.BOOLEAN));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("string", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                String[] array;
                FtlCustomVariable customVariable = new FtlCustomVariable("string", builtIn);
                FtlType string = (FtlType)this.val$stringType.fun((Object)builtIn);
                boolean camelCase = FtlPsiUtil.isUsingCamelCase(builtIn.getContainingFile());
                for (String s : array = new String[]{"short", "medium", "long", "full"}) {
                    customVariable.addSubVariable(new FtlLightVariable(s, (PsiElement)builtIn, string));
                    for (String s1 : array) {
                        customVariable.addSubVariable(new FtlLightVariable(camelCase ? s + StringUtil.capitalize((String)s1) : s + "_" + s1, (PsiElement)builtIn, string));
                    }
                }
                for (String standard : (String[])ContainerUtil.ar((Object[])new String[]{"iso", "xs"})) {
                    customVariable.addSubVariable(new FtlLightVariable(standard, (PsiElement)builtIn, string));
                    for (String accuracy : DATE_FORMAT_ACCURACIES) {
                        String accurateName = camelCase ? standard + StringUtil.capitalize((String)accuracy) : standard + "_" + accuracy;
                        customVariable.addSubVariable(new FtlLightVariable(accurateName, (PsiElement)builtIn, string));
                        for (String zone : (String[])ContainerUtil.ar((Object[])new String[]{camelCase ? "NZ" : "_nz", camelCase ? "U" : "_u"})) {
                            customVariable.addSubVariable(new FtlLightVariable(accurateName + zone, (PsiElement)builtIn, string));
                        }
                    }
                }
                return new FtlCompositeType(string, new FtlHashType(customVariable), FtlCallableType.createLightFunctionType(builtIn, string, "format", string));
            }
        }));
        ConstantFunction dateTime = new ConstantFunction((Object)FtlDateType.INSTANCE);
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("date", (Function<FtlBuiltIn, FtlType>)dateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("time", (Function<FtlBuiltIn, FtlType>)dateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("datetime", (Function<FtlBuiltIn, FtlType>)dateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("dateIfUnknown", (Function<FtlBuiltIn, FtlType>)dateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("datetimeIfUnknown", (Function<FtlBuiltIn, FtlType>)dateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("timeIfUnknown", (Function<FtlBuiltIn, FtlType>)dateTime));
        FtlBuiltIns.addDateFormatBuiltIns(stringType);
        ourBuiltIns.add(new FtlBuiltInDescriptor.BooleanBuiltIn("string", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlType string = (FtlType)this.val$stringType.fun((Object)builtIn);
                return new FtlCompositeType(string, FtlCallableType.createLightFunctionType(builtIn, string, "true", string, "false", string));
            }
        }));
        ourBuiltIns.add(new FtlBuiltInDescriptor.BooleanBuiltIn("c", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.BooleanBuiltIn("then", (Function<FtlBuiltIn, FtlType>)FtlArgumentDependentBuiltIn.THEN));
        NullableFunction<FtlBuiltIn, FtlType> sequenceComponent = new NullableFunction<FtlBuiltIn, FtlType>(){

            public FtlType fun(FtlBuiltIn builtIn) {
                return FtlListDirective.getComponentType(builtIn.getQualifierType());
            }
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("first", sequenceComponent));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("last", sequenceComponent));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("seqContains", new NullableFunction<FtlBuiltIn, FtlType>((NullableFunction)sequenceComponent){
            final /* synthetic */ NullableFunction val$sequenceComponent;
            {
                this.val$sequenceComponent = nullableFunction;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                return FtlCallableType.createLightFunctionType(builtIn, booleanType, "element", (FtlType)this.val$sequenceComponent.fun((Object)builtIn));
            }
        }));
        NullableFunction<FtlBuiltIn, FtlType> sequenceIndexOf = new NullableFunction<FtlBuiltIn, FtlType>((NullableFunction)sequenceComponent){
            final /* synthetic */ NullableFunction val$sequenceComponent;
            {
                this.val$sequenceComponent = nullableFunction;
            }

            public FtlType fun(FtlBuiltIn builtIn) {
                return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, intType, "element", (FtlType)this.val$sequenceComponent.fun((Object)builtIn)), FtlCallableType.createLightFunctionType(builtIn, intType, "element", (FtlType)this.val$sequenceComponent.fun((Object)builtIn), "from", intType));
            }
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("seqIndexOf", sequenceIndexOf));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("seqLastIndexOf", sequenceIndexOf));
        NullableFunction<FtlBuiltIn, FtlType> sameCollection = new NullableFunction<FtlBuiltIn, FtlType>(){

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlType type = builtIn.getQualifierType();
                return type == null ? new FtlCollectionType(null) : type;
            }
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("reverse", sameCollection));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("join", new NullableFunction<FtlBuiltIn, FtlType>((Function)stringType){
            final /* synthetic */ Function val$stringType;
            {
                this.val$stringType = function;
            }

            @Nullable
            public FtlType fun(FtlBuiltIn context) {
                FtlType string = (FtlType)this.val$stringType.fun((Object)context);
                return new FtlCompositeType(FtlCallableType.createLightFunctionType(context, string, "separator", string), FtlCallableType.createLightFunctionType(context, string, "separator", string, "empty", string), FtlCallableType.createLightFunctionType(context, string, "separator", string, "empty", string, "listEnding", string));
            }
        }));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("sort", sameCollection));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("sortBy", new NullableFunction<FtlBuiltIn, FtlType>(){

            public FtlType fun(FtlBuiltIn builtIn) {
                FtlType qualifierType = builtIn.getQualifierType();
                FtlPsiType ftlPsiType = FtlPsiUtil.asInstanceOf(FtlListDirective.getComponentType(qualifierType), FtlPsiType.class);
                PsiType componentType = ftlPsiType == null ? null : ftlPsiType.getPsiType();
                PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)componentType, (String)"java.util.Map", (int)0, (boolean)true);
                return FtlCallableType.createLightFunctionType(builtIn, qualifierType, "key", FtlPsiType.wrap(keyType));
            }
        }));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("chunk", new NullableFunction<FtlBuiltIn, FtlType>(){

            public FtlType fun(FtlBuiltIn builtIn) {
                return FtlCallableType.createLightFunctionType(builtIn, new FtlCollectionType(builtIn.getQualifierType()), "size", intType);
            }
        }));
        ourBuiltIns.add(new FtlBuiltInDescriptor.HashBuiltIn("keys", 0));
        ourBuiltIns.add(new FtlBuiltInDescriptor.HashBuiltIn("values", 1));
        ourBuiltIns.add(new FtlBuiltInDescriptor("size", (PsiType)PsiType.INT){

            @Override
            public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
                if (qualifierType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/freemarker/FtlBuiltIns$24", "acceptsQualifier"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlBuiltIns$24", "acceptsQualifier"));
                }
                return FtlListDirective.isCollectionType(qualifierType) || FtlBuiltInDescriptor.HashBuiltIn.isHash(qualifierType);
            }
        });
        ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn("counter", intType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn("index", intType));
        for (String s : (String[])ContainerUtil.ar((Object[])new String[]{"hasNext", "isEvenItem", "isOddItem", "isFirst", "isLast"})) {
            ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn(s, booleanType));
        }
        ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn("itemParity", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn("itemParityCap", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn("itemCycle", (Function<FtlBuiltIn, FtlType>)FtlArgumentDependentBuiltIn.ITEM_CYCLE));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("children", new FtlCollectionType(FtlNodeType.INSTANCE)));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("parent", FtlNodeType.INSTANCE));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("root", FtlNodeType.INSTANCE));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("ancestors", new FtlCollectionType(FtlNodeType.INSTANCE)));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("nodeName", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("nodeType", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("nodeNamespace", stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("switch", (Function<FtlBuiltIn, FtlType>)FtlArgumentDependentBuiltIn.SWITCH));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("byte", (PsiType)PsiType.BYTE));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("double", (PsiType)PsiType.DOUBLE));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("float", (PsiType)PsiType.FLOAT));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("int", (PsiType)PsiType.INT));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("long", (PsiType)PsiType.LONG));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("short", (PsiType)PsiType.SHORT));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("numberToDate", (Function<FtlBuiltIn, FtlType>)formattedDateTime));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("numberToTime", (Function<FtlBuiltIn, FtlType>)formattedDateTime));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("numberToDatetime", (Function<FtlBuiltIn, FtlType>)formattedDateTime));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("eval", (Function<FtlBuiltIn, FtlType>)new NullableConstantFunction(null)));
        for (String s : object2Boolean = new String[]{"hasContent", "hasApi", "isString", "isNumber", "isBoolean", "isDate", "isDateLike", "isDateOnly", "isTime", "isDatetime", "isUnknownDateLike", "isMethod", "isTransform", "isMacro", "isHash", "isHashEx", "isSequence", "isCollection", "isCollectionEx", "isEnumerable", "isIndexable", "isDirective", "isNode"}) {
            ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn(s, (PsiType)PsiType.BOOLEAN));
        }
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("api", new Function<FtlBuiltIn, FtlType>(){

            public FtlType fun(FtlBuiltIn builtIn) {
                return builtIn.getQualifierType();
            }
        }));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("interpret", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>(){

            public FtlType fun(FtlBuiltIn builtIn) {
                return new FtlCallableType(true, new FtlParameter[0]);
            }
        }));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor("namespace", (Function)stringType){

            @Override
            public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
                if (qualifierType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/freemarker/FtlBuiltIns$27", "acceptsQualifier"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlBuiltIns$27", "acceptsQualifier"));
                }
                FtlCallableType callableType = qualifierType.asInstanceOf(FtlCallableType.class);
                return callableType != null && callableType.isMacro();
            }
        });
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("new", (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>(){

            public FtlType fun(FtlBuiltIn builtIn) {
                JavaPsiFacade facade;
                PsiClass psiClass;
                Object value = builtIn.getQualifier().getConstantValue();
                if (value instanceof String && (psiClass = (facade = JavaPsiFacade.getInstance((Project)builtIn.getProject())).findClass((String)value, builtIn.getResolveScope())) != null) {
                    SmartList results = new SmartList();
                    final FtlPsiType returnType = FtlPsiType.wrap((PsiType)facade.getElementFactory().createType(psiClass));
                    for (PsiMethod method : psiClass.getConstructors()) {
                        if (!method.hasModifierProperty("public")) continue;
                        results.add(new FtlMethodType(method, PsiSubstitutor.EMPTY){

                            @Override
                            public FtlType getResultType() {
                                return returnType;
                            }
                        });
                    }
                    if (results.size() > 1) {
                        return new FtlCompositeType(results.toArray(new FtlCallableType[results.size()]));
                    }
                    if (results.size() == 1) {
                        return (FtlType)results.get(0);
                    }
                }
                return new FtlCallableType(false, new FtlParameter[0]);
            }
        }));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("default", (Function)new NullableFunction<FtlBuiltIn, FtlType>(){

            public FtlType fun(FtlBuiltIn builtIn) {
                return FtlCallableType.createLightFunctionType(builtIn, builtIn.getQualifierType(), "defaultValue", builtIn.getQualifierType());
            }
        }){

            @Override
            public boolean isDeprecated() {
                return true;
            }

            @Override
            public String getQuickFixReplacement(FtlBuiltIn builtIn) {
                FtlMethodCallExpression expression;
                FtlExpression[] arguments;
                if (builtIn.getParent() instanceof FtlMethodCallExpression && (arguments = (expression = (FtlMethodCallExpression)builtIn.getParent()).getArgumentList().getPositionalArguments()).length == 1) {
                    return "!" + arguments[0].getText();
                }
                return null;
            }
        });
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("exists", (PsiType)PsiType.BOOLEAN){

            @Override
            public boolean isDeprecated() {
                return true;
            }

            @Override
            public String getQuickFixReplacement(FtlBuiltIn builtIn) {
                return "??";
            }
        });
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("ifExists", (Function)new NullableFunction<FtlBuiltIn, FtlType>(){

            public FtlType fun(FtlBuiltIn builtIn) {
                return builtIn.getQualifierType();
            }
        }){

            @Override
            public boolean isDeprecated() {
                return true;
            }

            @Override
            public String getQuickFixReplacement(FtlBuiltIn builtIn) {
                return "!";
            }
        });
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("webSafe", (Function)stringType){

            @Override
            public boolean isDeprecated() {
                return true;
            }

            @Override
            public String getQuickFixReplacement(FtlBuiltIn builtIn) {
                return "?html";
            }
        });
    }
}

