/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.FtlIndexInfo;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumDataDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.NullableDataExternalizer;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FtlFileIndex
extends FileBasedIndexExtension<FtlIndexKey, FtlIndexInfo> {
    public static final ID<FtlIndexKey, FtlIndexInfo> NAME = ID.create((String)"FtlFileIndex");
    @NonNls
    public static final String IMPLICIT_INCLUDE_MARKER = "[#ftl]\n[#-- @implicitly included --]\n";
    @NonNls
    public static final String ANGLE_IMPLICIT_INCLUDE_MARKER = "<#ftl>\n<#-- @implicitly included -->\n";

    @NotNull
    public ID<FtlIndexKey, FtlIndexInfo> getName() {
        ID<FtlIndexKey, FtlIndexInfo> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlFileIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<FtlIndexKey, FtlIndexInfo, FileContent> getIndexer() {
        DataIndexer<FtlIndexKey, FtlIndexInfo, FileContent> dataIndexer = new DataIndexer<FtlIndexKey, FtlIndexInfo, FileContent>(){

            @NotNull
            public Map<FtlIndexKey, FtlIndexInfo> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/freemarker/FtlFileIndex$1", "map"));
                }
                SmartList includes = new SmartList();
                THashSet macros = new THashSet();
                THashSet functions = new THashSet();
                THashSet roots = new THashSet();
                PsiFile psiFile = inputData.getPsiFile();
                if (!(psiFile instanceof FtlFile)) {
                    Map<FtlIndexKey, FtlIndexInfo> map = Collections.emptyMap();
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlFileIndex$1", "map"));
                    }
                    return map;
                }
                psiFile.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor((Set)roots, (List)includes, (Set)functions, (Set)macros){
                    final /* synthetic */ Set val$roots;
                    final /* synthetic */ List val$includes;
                    final /* synthetic */ Set val$functions;
                    final /* synthetic */ Set val$macros;
                    {
                        this.val$roots = set;
                        this.val$includes = list;
                        this.val$functions = set2;
                        this.val$macros = set3;
                    }

                    public void visitComment(PsiComment comment) {
                        String text = comment.getText();
                        Matcher matcher = FtlFileReferenceDirective.FTL_ROOT_PATTERN.matcher(text);
                        if (matcher.matches()) {
                            this.val$roots.add(matcher.group(1));
                        }
                    }

                    public void visitWhiteSpace(PsiWhiteSpace space) {
                    }

                    public void visitOuterLanguageElement(OuterLanguageElement element) {
                    }

                    public void visitErrorElement(PsiErrorElement element) {
                    }

                    public void visitElement(PsiElement element) {
                        FtlSignatureDirective signatureDirective;
                        String name;
                        String refText;
                        FtlFileReferenceDirective directive;
                        FtlStringLiteral literal;
                        if (element instanceof LeafElement) {
                            return;
                        }
                        if (element instanceof FtlFileReferenceDirective && (literal = (directive = (FtlFileReferenceDirective)element).getReferenceLiteral()) != null && ((refText = literal.getValueText()).startsWith("/") || refText.startsWith("\\"))) {
                            this.val$includes.add(refText.replace('\\', '/'));
                        }
                        if (element instanceof FtlSignatureDirective && StringUtil.isNotEmpty((String)(name = (signatureDirective = (FtlSignatureDirective)element).getName()))) {
                            (signatureDirective.isFunction() ? this.val$functions : this.val$macros).add(name);
                        }
                        if (element instanceof FtlXmlTag) {
                            super.visitElement(element);
                        }
                    }
                });
                HashMap map = new HashMap();
                map.put((Object)(((FtlFile)psiFile).isImplicitlyIncluded() ? FtlIndexKey.IMPLICITLY_INCLUDED : FtlIndexKey.USUAL_FILE), null);
                map.put((Object)FtlIndexKey.DATA, (Object)new FtlIndexInfo((List<String>)includes, (Set<String>)macros, (Set<String>)functions, (Set<String>)roots));
                HashMap hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlFileIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlFileIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<FtlIndexKey> getKeyDescriptor() {
        EnumDataDescriptor enumDataDescriptor = new EnumDataDescriptor(FtlIndexKey.class);
        if (enumDataDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlFileIndex", "getKeyDescriptor"));
        }
        return enumDataDescriptor;
    }

    @NotNull
    public DataExternalizer<FtlIndexInfo> getValueExternalizer() {
        NullableDataExternalizer nullableDataExternalizer = new NullableDataExternalizer((DataExternalizer)new DataExternalizer<FtlIndexInfo>(){

            public void save(@NotNull DataOutput out, FtlIndexInfo value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/freemarker/FtlFileIndex$2", "save"));
                }
                FtlFileIndex.writeList(out, value.includes);
                FtlFileIndex.writeList(out, value.functions);
                FtlFileIndex.writeList(out, value.macros);
                FtlFileIndex.writeList(out, value.roots);
            }

            public FtlIndexInfo read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/freemarker/FtlFileIndex$2", "read"));
                }
                ArrayList includes = FtlFileIndex.readList(in);
                THashSet functions = new THashSet((Collection)FtlFileIndex.readList(in));
                THashSet macros = new THashSet((Collection)FtlFileIndex.readList(in));
                THashSet roots = new THashSet((Collection)FtlFileIndex.readList(in));
                return new FtlIndexInfo(includes, (Set<String>)macros, (Set<String>)functions, (Set<String>)roots);
            }
        });
        if (nullableDataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlFileIndex", "getValueExternalizer"));
        }
        return nullableDataExternalizer;
    }

    private static ArrayList<String> readList(DataInput in) throws IOException {
        int size = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<String> strings = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            strings.add(IOUtil.readUTF((DataInput)in));
        }
        return strings;
    }

    private static void writeList(DataOutput out, Collection<String> list) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)list.size());
        for (String s : list) {
            IOUtil.writeUTF((DataOutput)out, (String)s);
        }
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{FtlFileType.INSTANCE});
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlFileIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 5;
    }

    public static enum FtlIndexKey {
        IMPLICITLY_INCLUDED,
        USUAL_FILE,
        DATA;

    }
}

