/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlPathGenerator {
    private final List<PsiFileSystemItem> myRoots = new SmartList();
    private final boolean myAbsolute;

    public FtlPathGenerator(PsiFile file, Module module) {
        FtlFileReferenceDirective.collectFtlRoots(file, this.myRoots);
        if (this.myRoots.isEmpty()) {
            FtlFileReferenceDirective.collectFtlRoots(module, this.myRoots);
        }
        boolean bl = this.myAbsolute = !this.myRoots.isEmpty();
        if (!this.myAbsolute) {
            ContainerUtil.addIfNotNull((Object)file, this.myRoots);
        }
    }

    @Nullable
    public String generatePath(@NotNull VirtualFile to) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/freemarker/FtlPathGenerator", "generatePath"));
        }
        String best = null;
        for (PsiFileSystemItem item : this.myRoots) {
            VirtualFile src = item.getVirtualFile();
            String relativePath = FtlFileReferenceDirective.getRelativePath(src, to);
            if (relativePath == null || best != null && best.length() <= relativePath.length()) continue;
            best = relativePath;
        }
        if (best == null) {
            return null;
        }
        if (this.myAbsolute) {
            return "/" + best;
        }
        return best;
    }
}

