/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FtlReferenceContributor
extends PsiReferenceContributor {
    public static final PsiElementPattern.Capture<PsiComment> FTL_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(FtlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@ftlvariable"));
    public static final PsiElementPattern.Capture<PsiComment> FTL_ROOT_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(FtlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@ftlroot"));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/freemarker/FtlReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(FTL_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/FtlReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlReferenceContributor$1", "getReferencesByElement"));
                }
                String text = element.getText();
                int start = FtlReferenceContributor.getTypeStartOffset(text);
                if (start < 0) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                int end = FtlReferenceContributor.getTypeEndOffset(text);
                if (end < 0) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new JavaClassReferenceProvider().getReferencesByString(text.substring(start, end), element, start);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        registrar.registerReferenceProvider(FTL_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/FtlReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlReferenceContributor$2", "getReferencesByElement"));
                }
                FileReference[] fileReferenceArray = FtlReferenceContributor.getFileReferences(element);
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$2", "getReferencesByElement"));
                }
                return fileReferenceArray;
            }
        });
        registrar.registerReferenceProvider(FTL_ROOT_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/FtlReferenceContributor$3", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlReferenceContributor$3", "getReferencesByElement"));
                }
                String text = element.getText();
                int start = text.indexOf(34) + 1;
                if (start <= 0) {
                    if (FileReference.EMPTY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$3", "getReferencesByElement"));
                    }
                    return FileReference.EMPTY;
                }
                int end = text.indexOf(34, start);
                if (end < 0) {
                    if (FileReference.EMPTY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$3", "getReferencesByElement"));
                    }
                    return FileReference.EMPTY;
                }
                FileReference[] fileReferenceArray = new FileReferenceSet(text.substring(start, end), element, start, null, true){

                    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                        return new Condition<PsiFileSystemItem>(){

                            public boolean value(PsiFileSystemItem element) {
                                return element instanceof PsiDirectory || element instanceof PsiFile && element.getName().endsWith(".jar");
                            }
                        };
                    }

                    public FileReference createFileReference(TextRange range, int index, String text) {
                        return new JarAwareFileReference(this, range, index, text);
                    }
                }.getAllReferences();
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$3", "getReferencesByElement"));
                }
                return fileReferenceArray;
            }
        });
        registrar.registerReferenceProvider(FTL_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/FtlReferenceContributor$4", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlReferenceContributor$4", "getReferencesByElement"));
                }
                String nameEq = "name=\"";
                String text = element.getText();
                int start = text.indexOf("name=\"");
                if (start < 0) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$4", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                int end = text.indexOf("\"", start += "name=\"".length());
                if (end < 0) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$4", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String name = text.substring(start, end);
                FtlQualifiedReference reference = FtlPsiUtil.parseQualifiedReference(name, element.getProject());
                if (reference == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$4", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                reference.getElement().getContainingFile().setContext((PsiElement)element.getContainingFile());
                SmartList result = new SmartList();
                while (reference != null) {
                    PsiElement target = reference.resolve();
                    if (target instanceof FtlImplicitVariable) {
                        final FtlImplicitVariable variable = (FtlImplicitVariable)target;
                        TextRange range = reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset() + start - 2);
                        PsiReferenceBase<PsiComment> newRef = new PsiReferenceBase<PsiComment>((PsiComment)element, range){

                            public PsiElement resolve() {
                                return variable;
                            }

                            @NotNull
                            public Object[] getVariants() {
                                if (EMPTY_ARRAY == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$4$1", "getVariants"));
                                }
                                return EMPTY_ARRAY;
                            }
                        };
                        result.add(newRef);
                    }
                    reference = FtlPsiUtil.getReference(reference.getReferenceQualifier());
                }
                PsiReference[] psiReferenceArray = result.toArray(new PsiReference[result.size()]);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlReferenceContributor$4", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    public static FileReference[] getFileReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/FtlReferenceContributor", "getFileReferences"));
        }
        String text = element.getText();
        int start = FtlReferenceContributor.getAttributeStartOffset("file", text);
        if (start < 0) {
            return FileReference.EMPTY;
        }
        int end = FtlReferenceContributor.getAttributeEndOffset("file", text);
        if (end < 0) {
            return FileReference.EMPTY;
        }
        FileReferenceSet set = new FileReferenceSet(text.substring(start, end), element, start, null, true);
        set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        return set.getAllReferences();
    }

    public static int getTypeEndOffset(String text) {
        return FtlReferenceContributor.getAttributeEndOffset("type", text);
    }

    private static int getAttributeEndOffset(@NonNls String attrName, String text) {
        int start = FtlReferenceContributor.getAttributeStartOffset(attrName, text);
        return text.indexOf("\"", start);
    }

    public static int getTypeStartOffset(String text) {
        return FtlReferenceContributor.getAttributeStartOffset("type", text);
    }

    private static int getAttributeStartOffset(@NonNls String attrName, String text) {
        String str = attrName + "=\"";
        int start = text.indexOf(str);
        if (start >= 0) {
            start += str.length();
        }
        return start;
    }

    private class JarAwareFileReference
    extends FileReference {
        public JarAwareFileReference(FileReferenceSet set, TextRange range, int index, String text) {
            super(set, range, index, text);
        }

        public void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, final Collection<ResolveResult> result, boolean caseSensitive) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/freemarker/FtlReferenceContributor$JarAwareFileReference", "innerResolveInContext"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlReferenceContributor$JarAwareFileReference", "innerResolveInContext"));
            }
            if (text.endsWith(".jar!")) {
                final String name = StringUtil.trimEnd((String)text, (String)"!");
                JarAwareFileReference.processVariants((PsiFileSystemItem)context, (PsiFileSystemItemProcessor)new PsiFileSystemItemProcessor(){

                    public boolean acceptItem(String fileName, boolean isDirectory) {
                        return !isDirectory && name.equals(fileName);
                    }

                    public boolean execute(@NotNull PsiFileSystemItem element) {
                        PsiDirectory psiInside;
                        VirtualFile inside;
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/FtlReferenceContributor$JarAwareFileReference$1", "execute"));
                        }
                        VirtualFile vFile = element.getVirtualFile();
                        if (vFile != null && (inside = JarFileSystem.getInstance().getJarRootForLocalFile(vFile)) != null && (psiInside = element.getManager().findDirectory(inside)) != null) {
                            result.add(new PsiElementResolveResult((PsiElement)psiInside));
                        }
                        return true;
                    }
                });
                return;
            }
            super.innerResolveInContext(text, context, result, caseSensitive);
        }
    }
}

