/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.FtlBuiltIns;
import com.intellij.freemarker.FtlReferenceContributor;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariableType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class FtlAnnotator
implements Annotator {
    private static final Pattern FORMAT_STRING_PATTERN = Pattern.compile("(m[0-9]+)?(M[0-9]+)?");

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlAnnotator", "annotate"));
        }
        if (element.getParent() instanceof FtlBuiltIn && element.getNode().getElementType() == FtlElementTypes.IDENTIFIER) {
            FtlAnnotator.checkBuiltIn(element, holder, (FtlBuiltIn)element.getParent());
        } else if (element instanceof PsiComment && FtlReferenceContributor.FTL_COMMENT.accepts((Object)element)) {
            FtlAnnotator.checkDeclarationComment(element, holder);
        } else if (FtlReferenceContributor.FTL_ROOT_COMMENT.accepts((Object)element)) {
            FtlAnnotator.checkFtlRootComment(element, holder);
        } else if (element instanceof FtlInterpolation) {
            FtlAnnotator.checkInterpolation(holder, (FtlInterpolation)element);
        }
    }

    private static void checkBuiltIn(@NotNull PsiElement element, @NotNull AnnotationHolder holder, FtlBuiltIn builtIn) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlAnnotator", "checkBuiltIn"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlAnnotator", "checkBuiltIn"));
        }
        String name = builtIn.getBuiltInName();
        if (name == null) {
            return;
        }
        boolean unknown = FtlBuiltIns.getBuiltIns(null, name).isEmpty();
        TextAttributes attributes = SimpleTextAttributes.DARK_TEXT.toTextAttributes();
        if (unknown) {
            attributes.setFontType(2);
        }
        holder.createInfoAnnotation(element, unknown ? FreeMarkerBundle.message("unknown.builtin", name) : null).setEnforcedTextAttributes(attributes);
        FtlBuiltInDescriptor descriptor = builtIn.getBuiltInDescriptor();
        if (descriptor != null && name.equals(descriptor.getSnakeCaseName()) && !name.equals(descriptor.getCamelCaseName()) && FtlPsiUtil.isUsingCamelCase(builtIn.getContainingFile())) {
            holder.createErrorAnnotation(element, FreeMarkerBundle.message("error.mixing.camelcase.lowercase", new Object[0]));
            return;
        }
        FtlType qualifierType = builtIn.getQualifierType();
        if (qualifierType != null) {
            if (builtIn.getType() == null && !builtIn.isEval() && qualifierType != FtlLoopVariableType.INSTANCE) {
                if (!unknown) {
                    holder.createErrorAnnotation(element, FreeMarkerBundle.message("builtin.not.applicable", name, qualifierType.getPresentableText()));
                }
                return;
            }
            PsiElement parent = builtIn.getParent();
            if (parent instanceof FtlMethodCallExpression) {
                FtlMethodCallExpression expression = (FtlMethodCallExpression)parent;
                if (builtIn.getCallableCandidates().length == 0) {
                    holder.createErrorAnnotation((PsiElement)expression.getArgumentList(), FreeMarkerBundle.message("builtin.should.not.have.params", name));
                    return;
                }
                PsiType[] types = expression.getArgumentTypes();
                if (Arrays.asList(types).contains(null)) {
                    return;
                }
                for (FtlCallableType callableType : builtIn.getCallableCandidates()) {
                    if (!FtlAnnotator.isApplicable(types, callableType.getParameters())) continue;
                    return;
                }
                holder.createErrorAnnotation((PsiElement)expression.getArgumentList(), FreeMarkerBundle.message("wrong.builtin.parameter.types", new Object[0]));
            } else if (builtIn.isCallableOnly()) {
                holder.createErrorAnnotation(element, FreeMarkerBundle.message("builtin.should.have.params", name));
            }
        }
    }

    private static void checkDeclarationComment(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlAnnotator", "checkDeclarationComment"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlAnnotator", "checkDeclarationComment"));
        }
        String text = element.getText();
        Matcher matcher = FtlFile.VAR_DECL_PATTERN.matcher(text);
        if (matcher.matches()) {
            if (FtlAnnotator.isInvalidType(FtlImplicitVariable.getDeclaredType(matcher.group(2), element))) {
                int start = FtlReferenceContributor.getTypeStartOffset(text);
                if (start < 0) {
                    return;
                }
                int end = FtlReferenceContributor.getTypeEndOffset(text);
                if (end < 0) {
                    return;
                }
                TextRange range = new TextRange(start, end);
                holder.createErrorAnnotation(range.shiftRight(element.getTextRange().getStartOffset()), FreeMarkerBundle.message("invalid.java.type", new Object[0]));
                return;
            }
            FileReference[] references = FtlReferenceContributor.getFileReferences(element);
            if (references.length > 0) {
                FileReference reference;
                PsiFileSystemItem item;
                FileReference[] end = references;
                int range = end.length;
                for (int i = 0; i < range && (item = (reference = end[i]).resolve()) != null; ++i) {
                    if (!(item instanceof FtlFile)) continue;
                    return;
                }
                FileReferenceSet set = references[0].getFileReferenceSet();
                TextRange range2 = TextRange.from((int)(set.getStartInElement() + element.getTextRange().getStartOffset()), (int)set.getPathString().length());
                holder.createErrorAnnotation(range2, FreeMarkerBundle.message("invalid.ftl.file", new Object[0]));
            }
        }
    }

    private static void checkFtlRootComment(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlAnnotator", "checkFtlRootComment"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlAnnotator", "checkFtlRootComment"));
        }
        String text = element.getText();
        Matcher matcher = FtlFileReferenceDirective.FTL_ROOT_PATTERN.matcher(text);
        if (matcher.matches()) {
            String relativePath = matcher.group(1);
            if (relativePath.startsWith("/")) {
                FtlAnnotator.createFtlRootError(element, holder, matcher, FreeMarkerBundle.message("absolute.refs.not.allowed", new Object[0]));
                return;
            }
            VirtualFile root = FtlFileReferenceDirective.getFtlRoot(relativePath, element.getContainingFile().getVirtualFile());
            if (root == null) {
                FtlAnnotator.createFtlRootError(element, holder, matcher, FreeMarkerBundle.message("invalid.relative.path", new Object[0]));
            } else if (!root.isDirectory()) {
                FtlAnnotator.createFtlRootError(element, holder, matcher, FreeMarkerBundle.message("directory.expected", new Object[0]));
            }
        }
    }

    private static void checkInterpolation(@NotNull AnnotationHolder holder, FtlInterpolation interpolation) {
        PsiElement specifier;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlAnnotator", "checkInterpolation"));
        }
        if (interpolation.isNumeric() && (specifier = interpolation.getFormatSpecifier()) != null && !FORMAT_STRING_PATTERN.matcher(specifier.getText().trim()).matches()) {
            holder.createErrorAnnotation(specifier, FreeMarkerBundle.message("error.format.string.syntax", new Object[0]));
        }
    }

    private static void createFtlRootError(PsiElement element, AnnotationHolder holder, Matcher matcher, String message) {
        int start = matcher.start(1);
        int end = matcher.end(1);
        TextRange range = TextRange.from((int)(element.getTextRange().getStartOffset() + start), (int)(end - start));
        holder.createErrorAnnotation(range, message);
    }

    private static boolean isApplicable(PsiType[] types, FtlVariable[] formalParams) {
        if (types.length != formalParams.length) {
            return false;
        }
        for (int i = 0; i < formalParams.length; ++i) {
            PsiType actual;
            FtlPsiType type = FtlPsiUtil.asInstanceOf(formalParams[i].getType(), FtlPsiType.class);
            if (type == null) {
                return true;
            }
            PsiType expected = type.getPsiType();
            if (expected.isAssignableFrom(actual = types[i]) || expected.equalsToText("java.lang.String") && InheritanceUtil.isInheritor((PsiType)actual, (String)"java.lang.Enum")) continue;
            return false;
        }
        return true;
    }

    private static boolean isInvalidType(FtlType type) {
        if (type == null) {
            return true;
        }
        if (type instanceof FtlPsiType) {
            return FtlAnnotator.isInvalidType(((FtlPsiType)type).getPsiType());
        }
        return false;
    }

    private static boolean isInvalidType(PsiType type) {
        if (type instanceof PsiPrimitiveType) {
            return false;
        }
        if (type instanceof PsiArrayType) {
            return FtlAnnotator.isInvalidType(((PsiArrayType)type).getComponentType());
        }
        return PsiUtil.resolveClassInType((PsiType)type) == null;
    }
}

