/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlEnumReference;
import com.intellij.freemarker.psi.FtlExistsExpression;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlResolveResult;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.resolve.JavaMethodResolveHelper;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlReferencesInspection
extends FtlSuppressableInspection {
    private static final ElementPattern<PsiElement> IN_MACRO_END = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement((IElementType)FtlElementTypes.END_MACRO_START));
    public static final String SHORT_NAME = "FtlReferencesInspection";
    public boolean fieldsExposed = false;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlReferencesInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                FtlEnumReference enumReference;
                if (element instanceof FtlReferenceExpression) {
                    if (!IN_MACRO_END.accepts((Object)element)) {
                        FtlReferencesInspection.checkReference(((FtlReferenceExpression)element).getReference(), holder);
                    }
                } else if (element instanceof FtlIndexExpression) {
                    if (!IN_MACRO_END.accepts((Object)element)) {
                        FtlReferencesInspection.checkReference(((FtlIndexExpression)element).getQualifiedReference(), holder);
                    }
                } else if (element instanceof FtlStringLiteral && (enumReference = (FtlEnumReference)((Object)ContainerUtil.findInstance((Object[])element.getReferences(), FtlEnumReference.class))) != null) {
                    FtlReferencesInspection.checkEnumReference(enumReference, holder);
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlReferencesInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static void checkEnumReference(FtlEnumReference reference, ProblemsHolder holder) {
        PsiClass enumClass = reference.getEnumClass();
        if (enumClass == null) {
            return;
        }
        if (reference.resolve() == null) {
            holder.registerProblem((PsiReference)reference, "Unknown enum constant '#ref' in class " + enumClass.getName(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    private static void checkReference(@Nullable FtlQualifiedReference reference, ProblemsHolder holder) {
        boolean hasResolveError;
        FtlType qualifierType;
        if (reference == null) {
            return;
        }
        if (reference.getAssignDeclaration() != null) {
            return;
        }
        FtlReferenceQualifier qualifier = reference.getReferenceQualifier();
        if (qualifier != null && ((qualifierType = qualifier.getType()) == null || FtlPsiUtil.isAssignableToClass(qualifierType.asInstanceOf(FtlPsiType.class), "java.util.Map"))) {
            return;
        }
        if (reference.isNodeChildrenAccessor()) {
            return;
        }
        if (PlatformPatterns.psiElement(FtlExistsExpression.class).accepts((Object)reference.getElement().getParent())) {
            return;
        }
        Object[] results = reference.multiResolve(false);
        JavaMethodResolveHelper.ErrorType resolveError = results.length > 0 && results[0] instanceof FtlResolveResult ? ((FtlResolveResult)results[0]).getResolveError() : JavaMethodResolveHelper.ErrorType.NONE;
        boolean bl = hasResolveError = resolveError != JavaMethodResolveHelper.ErrorType.NONE;
        if (!hasResolveError) {
            if (reference.resolve() != null) {
                return;
            }
            if (results.length == 2 && ContainerUtil.find((Object[])results, (Condition)new Condition<ResolveResult>(){

                public boolean value(ResolveResult result) {
                    return result.getElement() instanceof FtlImplicitVariable;
                }
            }) != null) {
                return;
            }
        }
        holder.registerProblem((PsiReference)reference, reference.getUnresolvedMessage(resolveError), hasResolveError ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlReferencesInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlReferencesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FreeMarkerBundle.message("ftl.references.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlReferencesInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlReferencesInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        final JCheckBox cbExpose = new JCheckBox("Public fields are exposed");
        cbExpose.setSelected(this.fieldsExposed);
        panel.add((Component)cbExpose, "North");
        cbExpose.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FtlReferencesInspection.this.fieldsExposed = cbExpose.isSelected();
            }
        });
        return panel;
    }
}

