/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlCollectionType;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariable;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlListDirective
extends FtlDirective {
    private final FtlLoopVariable myLoopVariable = new FtlLoopVariable(this, "", null){

        @Override
        public FtlType getType() {
            return FtlListDirective.this.getComponentType();
        }
    };
    private final FtlLoopVariable myLoopHasNextVariable = new FtlLoopVariable(this, "_has_next", (PsiType)PsiType.BOOLEAN);
    private final FtlLoopVariable myLoopIndexVariable = new FtlLoopVariable(this, "_index", (PsiType)PsiType.INT);

    public FtlListDirective(ASTNode node) {
        super(node);
    }

    @Nullable
    private FtlType getComponentType() {
        PsiElement parent;
        FtlExpression expression = this.getListExpression();
        if (expression == null && "items".equals(this.getDirectiveName()) && (parent = this.getParent()) instanceof FtlListDirective && "list".equals(((FtlListDirective)parent).getDirectiveName())) {
            expression = ((FtlListDirective)parent).getListExpression();
        }
        if (expression == null) {
            return null;
        }
        return FtlListDirective.getComponentType(expression.getType());
    }

    @Nullable
    public static FtlType getComponentType(FtlType type) {
        FtlCollectionType collectionType = FtlPsiUtil.asInstanceOf(type, FtlCollectionType.class);
        if (collectionType != null) {
            return FtlListDirective.unboxIfNeeded(collectionType.getComponentType());
        }
        FtlPsiType ftlPsiType = FtlPsiUtil.asInstanceOf(type, FtlPsiType.class);
        if (ftlPsiType == null) {
            return null;
        }
        PsiType psiType = ftlPsiType.getPsiType();
        if (psiType instanceof PsiArrayType) {
            return FtlListDirective.unboxIfNeeded(FtlPsiType.wrap(((PsiArrayType)psiType).getComponentType()));
        }
        return FtlListDirective.unboxIfNeeded(FtlPsiType.wrap(PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)true)));
    }

    public static boolean isCollectionType(FtlType type) {
        FtlCollectionType collectionType = FtlPsiUtil.asInstanceOf(type, FtlCollectionType.class);
        if (collectionType != null) {
            return true;
        }
        FtlPsiType ftlPsiType = FtlPsiUtil.asInstanceOf(type, FtlPsiType.class);
        if (ftlPsiType == null) {
            return false;
        }
        PsiType psiType = ftlPsiType.getPsiType();
        return psiType instanceof PsiArrayType || InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.lang.Iterable");
    }

    private static FtlType unboxIfNeeded(FtlType type) {
        FtlPsiType psiType;
        PsiPrimitiveType primitiveType;
        if (type instanceof FtlPsiType && (primitiveType = PsiPrimitiveType.getUnboxedType((PsiType)(psiType = (FtlPsiType)type).getPsiType())) != null) {
            return new FtlPsiType((PsiType)primitiveType);
        }
        return type;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/directives/FtlListDirective", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/directives/FtlListDirective", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/psi/directives/FtlListDirective", "processDeclarations"));
        }
        if (lastParent == this.getListExpression()) {
            return true;
        }
        for (FtlLoopVariable variable : this.getDeclaredVariables()) {
            if (processor.execute((PsiElement)variable, state)) continue;
            return false;
        }
        return this.processDirectiveDeclarations(processor, state, lastParent, false);
    }

    @Nullable
    public FtlExpression getListExpression() {
        return (FtlExpression)this.findChildByClass(FtlExpression.class);
    }

    public PsiReference getReference() {
        final PsiElement nameElement = this.getNameElement();
        if (nameElement != null) {
            TextRange range = TextRange.from((int)0, (int)nameElement.getTextLength()).shiftRight(nameElement.getStartOffsetInParent());
            return new PsiReferenceBase<PsiElement>((PsiElement)this, range){

                public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                    return nameElement;
                }

                public PsiElement resolve() {
                    return FtlListDirective.this.myLoopVariable;
                }

                @NotNull
                public Object[] getVariants() {
                    if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlListDirective$2", "getVariants"));
                    }
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
            };
        }
        return super.getReference();
    }

    public FtlLoopVariable getLoopVariable() {
        return this.myLoopVariable;
    }

    public FtlLoopVariable[] getDeclaredVariables() {
        if (this.getNameElement() != null) {
            return new FtlLoopVariable[]{this.myLoopVariable, this.myLoopHasNextVariable, this.myLoopIndexVariable};
        }
        return new FtlLoopVariable[0];
    }

    @Nullable
    public PsiElement getNameElement() {
        return this.findChildByType((IElementType)FtlElementTypes.IDENTIFIER);
    }
}

