/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlCompositeElementTypes;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.directives.FtlSignatureCallableType;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlMacroLoopVariable;
import com.intellij.freemarker.psi.variables.FtlTemplateType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlMacro
extends FtlXmlTag {
    public FtlMacro(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/freemarker/psi/directives/FtlMacro", "<init>"));
        }
        super(node);
    }

    @NotNull
    public String getName() {
        String string = "@" + this.getDirectiveName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlMacro", "getName"));
        }
        return string;
    }

    @Override
    @Nullable
    public PsiElement getStartTagNameElement() {
        PsiElement firstChild = this.getFirstChild();
        return firstChild == null ? null : firstChild.getNextSibling();
    }

    @NonNls
    private String getDirectiveName() {
        PsiElement element = this.getStartTagNameElement();
        return element == null ? "" : element.getText();
    }

    @Override
    public String getDirectiveTagName() {
        return "@" + this.getDirectiveName();
    }

    @Nullable
    public FtlCallableType getMacroType() {
        PsiElement element = this.getStartTagNameElement();
        return element instanceof FtlExpression ? FtlPsiUtil.asInstanceOf(((FtlExpression)element).getType(), FtlCallableType.class) : null;
    }

    @Nullable
    public FtlSignatureDirective resolveMacro() {
        return (FtlSignatureDirective)RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)true, (Computable)new Computable<FtlSignatureDirective>(){

            public FtlSignatureDirective compute() {
                FtlCallableType type = FtlMacro.this.getMacroType();
                return type instanceof FtlSignatureCallableType ? ((FtlSignatureCallableType)type).getDirective() : null;
            }
        });
    }

    @Override
    public boolean needsClosing() {
        if (this.findChildByType((IElementType)FtlElementTypes.EMPTY_MACRO_END) != null) {
            return false;
        }
        if (this.findChildByType((IElementType)FtlElementTypes.END_MACRO_START) != null) {
            return false;
        }
        return super.needsClosing();
    }

    @NotNull
    public FtlArgumentList getArgumentList() {
        FtlArgumentList ftlArgumentList = (FtlArgumentList)((Object)this.findNotNullChildByClass(FtlArgumentList.class));
        if (ftlArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlMacro", "getArgumentList"));
        }
        return ftlArgumentList;
    }

    @Override
    public String toString() {
        return FtlCompositeElementTypes.USER_DIRECTIVE.toString();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/directives/FtlMacro", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/directives/FtlMacro", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/psi/directives/FtlMacro", "processDeclarations"));
        }
        FtlMacroLoopVariable[] loopVars = this.getLoopVariables();
        int lvCount = loopVars.length;
        if (lvCount > 0 && lastParent != null && lastParent.getStartOffsetInParent() >= loopVars[lvCount - 1].getStartOffsetInParent()) {
            for (FtlMacroLoopVariable variable : loopVars) {
                if (processor.execute((PsiElement)variable, state)) continue;
                return false;
            }
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    public FtlMacroLoopVariable[] getLoopVariables() {
        return (FtlMacroLoopVariable[])this.findChildrenByClass(FtlMacroLoopVariable.class);
    }

    public FtlExpression[] getAllMacroReferences() {
        return (FtlExpression[])this.findChildrenByClass(FtlExpression.class);
    }

    @Nullable
    public FtlExpression getMacroReference() {
        PsiElement element = this.getStartTagNameElement();
        return element instanceof FtlExpression ? (FtlExpression)element : null;
    }

    @Override
    public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, boolean honorAssigns) {
        ResolveState newState;
        FtlSignatureDirective directive;
        if (lastParent == null && honorAssigns && state.get(FtlQualifiedReference.RESOLVING_MACRO) != Boolean.TRUE && (directive = this.resolveMacro()) != null && (directive.getContainingFile() == this.getContainingFile() || state.get(FtlTemplateType.PROCESSING_NAMESPACE) != null) && !directive.processDeclarationsInside(processor, newState = FtlAssignmentType.allowAssignments(state, FtlAssignmentType.ASSIGN), null, true)) {
            return false;
        }
        return super.processDirectiveDeclarations(processor, state, lastParent, honorAssigns);
    }
}

