/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlCollectionType;
import com.intellij.freemarker.psi.FtlCompositeElement;
import com.intellij.freemarker.psi.FtlCompositeElementTypes;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlCompositeType;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlParameterDeclaration
extends FtlCompositeElement
implements FtlParameter {
    public FtlParameterDeclaration(ASTNode node) {
        super(node);
    }

    @NonNls
    public String getName() {
        return this.getNameElement().getText();
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)super.getUseScope()), (FileType[])new FileType[]{FtlFileType.INSTANCE});
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlParameterDeclaration", "getUseScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public PsiElement getNameElement() {
        PsiElement psiElement = (PsiElement)ObjectUtils.assertNotNull((Object)this.findChildByType(FtlCompositeElementTypes.ATTRIBUTE_NAME));
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlParameterDeclaration", "getNameElement"));
        }
        return psiElement;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/directives/FtlParameterDeclaration", "setName"));
        }
        FtlXmlRootTag tag = FtlPsiUtil.parseFtlFile("<#function test " + name + "> </#function>", this.getProject());
        FtlSignatureDirective function = (FtlSignatureDirective)tag.getSubDirectives()[0];
        FtlParameterDeclaration parameter = function.getParameters()[0];
        this.getNode().replaceChild(this.getNameElement().getNode(), parameter.getNameElement().getNode());
        return this;
    }

    @Override
    public boolean isVararg() {
        return this.findChildByType((IElementType)FtlElementTypes.DOT_DOT_DOT) != null;
    }

    @Override
    public FtlType getType() {
        FtlType commentType = this.getCommentType();
        if (commentType != null) {
            return commentType;
        }
        if (this.isVararg()) {
            FtlCollectionType collectionType = new FtlCollectionType(null);
            FtlSignatureDirective directive = (FtlSignatureDirective)PsiTreeUtil.getParentOfType((PsiElement)this, FtlSignatureDirective.class);
            if (directive != null && directive.isFunction()) {
                return collectionType;
            }
            FtlPsiType mapType = FtlPsiType.wrap((PsiType)JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeByFQClassName("java.util.Map", this.getResolveScope()));
            return new FtlCompositeType(collectionType, mapType);
        }
        FtlExpression expression = this.getDefaultValue();
        return expression == null ? null : expression.getType();
    }

    public FtlType getCommentType() {
        final FtlSignatureDirective directive = this.getScopeDirective();
        if (directive != null) {
            return (FtlType)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<FtlType>(){

                public CachedValueProvider.Result<FtlType> compute() {
                    Map<String, FtlImplicitVariable> map = FtlFile.collectImplicitVariables((PsiElement)directive).get(null);
                    FtlImplicitVariable variable = map == null ? null : map.get(FtlParameterDeclaration.this.getName());
                    return CachedValueProvider.Result.create((Object)(variable == null ? null : variable.getType()), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }
            });
        }
        return null;
    }

    public FtlSignatureDirective getScopeDirective() {
        return (FtlSignatureDirective)PsiTreeUtil.getParentOfType((PsiElement)this, FtlSignatureDirective.class);
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.PARAMETER_ICON;
    }

    @Nullable
    public FtlExpression getDefaultValue() {
        return (FtlExpression)this.findChildByClass(FtlExpression.class);
    }

    @Override
    public boolean isMandatory() {
        return !this.isVararg() && this.getDefaultValue() == null;
    }
}

