/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.variables;

import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlNodeType;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlCompositeType;
import com.intellij.freemarker.psi.variables.FtlDataModelVariable;
import com.intellij.freemarker.psi.variables.FtlHashType;
import com.intellij.freemarker.psi.variables.FtlHashVariable;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlImplicitVariable
extends RenameableFakePsiElement
implements FtlHashVariable,
FtlDataModelVariable {
    private final PsiComment myComment;
    private final String myName;
    private final FtlFile myScopeFile;
    private final List<String> myTypes;
    private final Map<String, FtlImplicitVariable> mySubVariables;
    @NonNls
    public static final String STATIC_MARKER = ".static";

    public FtlImplicitVariable(PsiComment comment, @NotNull String name, FtlFile scopeFile) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/variables/FtlImplicitVariable", "<init>"));
        }
        super((PsiElement)comment.getContainingFile());
        this.myTypes = new SmartList();
        this.mySubVariables = new THashMap();
        this.myComment = comment;
        this.myName = name;
        this.myScopeFile = scopeFile;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlImplicitVariable", "getName"));
        }
        return string;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiComment psiComment = this.myComment;
        if (psiComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlImplicitVariable", "getNavigationElement"));
        }
        return psiComment;
    }

    public PsiElement getParent() {
        return this.myComment;
    }

    public String getTypeName() {
        return FreeMarkerBundle.message("type.name.variable", new Object[0]);
    }

    public Collection<FtlImplicitVariable> getSubVariables() {
        return this.mySubVariables.values();
    }

    public FtlImplicitVariable addSubVariable(final String name) {
        return (FtlImplicitVariable)ContainerUtil.getOrCreate(this.mySubVariables, (Object)name, (Factory)new Factory<FtlImplicitVariable>(){

            public FtlImplicitVariable create() {
                return new FtlImplicitVariable(FtlImplicitVariable.this.myComment, name, FtlImplicitVariable.this.myScopeFile);
            }
        });
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)super.getUseScope()), (FileType[])new FileType[]{FtlFileType.INSTANCE});
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlImplicitVariable", "getUseScope"));
        }
        return globalSearchScope;
    }

    public void addType(String type) {
        this.myTypes.add(type);
    }

    @Override
    @NotNull
    public FtlType getType() {
        CachedValuesManager.getManager((Project)this.getProject());
        FtlType ftlType = (FtlType)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<FtlType>(){

            @Nullable
            public CachedValueProvider.Result<FtlType> compute() {
                return CachedValueProvider.Result.create((Object)FtlImplicitVariable.this.calcType(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
        if (ftlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlImplicitVariable", "getType"));
        }
        return ftlType;
    }

    private FtlType calcType() {
        FtlHashType hashType = new FtlHashType(this);
        SmartList result = new SmartList();
        for (String type : this.myTypes) {
            ContainerUtil.addIfNotNull((Object)FtlImplicitVariable.getDeclaredType(type, (PsiElement)this.myComment), (Collection)result);
        }
        if (result.size() > 0) {
            result.add(hashType);
            return new FtlCompositeType(result.toArray(new FtlType[result.size()]));
        }
        return hashType;
    }

    @Nullable
    public static FtlType getDeclaredType(@Nullable String type, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/psi/variables/FtlImplicitVariable", "getDeclaredType"));
        }
        if (type == null) {
            return null;
        }
        boolean _static = false;
        if (type.endsWith(STATIC_MARKER)) {
            _static = true;
            type = type.substring(0, type.length() - STATIC_MARKER.length());
        }
        try {
            PsiTypeCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)context.getProject()).createTypeCodeFragment(type, null, false);
            fragment.forceResolveScope(context.getResolveScope());
            PsiType psiType = fragment.getType();
            if (!_static && InheritanceUtil.isInheritor((PsiType)psiType, (String)"freemarker.template.TemplateMethodModel")) {
                return FtlCallableType.TEMPLATE_METHOD_TYPE;
            }
            if (!_static && InheritanceUtil.isInheritor((PsiType)psiType, (String)"freemarker.template.TemplateNodeModel")) {
                return FtlNodeType.INSTANCE;
            }
            return new FtlPsiType(psiType, _static);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException e) {
            return null;
        }
        catch (PsiTypeCodeFragment.NoTypeException e) {
            return null;
        }
    }

    @Nullable
    public static PsiType getPsiType(String typeText, Project project) {
        if (typeText == null) {
            return null;
        }
        try {
            return JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeFromText(typeText, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public Icon getIcon() {
        return PlatformIcons.VARIABLE_ICON;
    }

    public boolean isGlobal() {
        return this.myScopeFile == null && !this.myComment.getText().contains("file=\"");
    }

    public boolean isForFile(@NotNull FtlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/freemarker/psi/variables/FtlImplicitVariable", "isForFile"));
        }
        return file.isEquivalentTo((PsiElement)this.myScopeFile);
    }
}

