/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils.processors;

import com.intellij.openapi.project.Project;
import com.intellij.play.utils.beans.PlayImplicitVariable;
import com.intellij.play.utils.processors.PlayDeclarationsProcessor;
import com.intellij.play.utils.processors.PlayImplicitVariablesFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.HashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class ImplicitVariablesProcessor
implements PlayDeclarationsProcessor {
    static Map<String, String> myImplicitVariables = new HashMap<String, String>();

    @Override
    public boolean processElement(PsiScopeProcessor processor, ResolveState state, PsiElement scope) {
        for (PlayImplicitVariable variableBase : ImplicitVariablesProcessor.getPredefinedVariables(scope)) {
            if (ResolveUtil.processElement((PsiScopeProcessor)processor, (PsiNamedElement)variableBase, (ResolveState)state)) continue;
            return false;
        }
        return true;
    }

    public static Set<PlayImplicitVariable> getPredefinedVariables(PsiElement scope) {
        HashSet implicitSet = new HashSet();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)scope.getProject());
        for (Map.Entry<String, String> entry : myImplicitVariables.entrySet()) {
            PsiClass psiClass = psiFacade.findClass(entry.getValue(), scope.getResolveScope());
            if (psiClass == null) continue;
            String name = entry.getKey();
            implicitSet.add(PlayImplicitVariablesFactory.createLightClassImplicitVariable(psiClass, name, false));
        }
        return implicitSet;
    }

    static {
        myImplicitVariables.put("errors", "java.util.List");
        myImplicitVariables.put("error", "play.data.validation.Error");
        myImplicitVariables.put("flash", "play.mvc.Scope.Flash");
        myImplicitVariables.put("lang", "play.i18n.Lang");
        myImplicitVariables.put("messages", "play.i18n.Messages");
        myImplicitVariables.put("out", "java.io.PrintWriter");
        myImplicitVariables.put("params", "play.mvc.Scope.Params");
        myImplicitVariables.put("play", "play.Play");
        myImplicitVariables.put("request", "play.mvc.Http.Request");
        myImplicitVariables.put("session", "play.mvc.Scope.Session");
        myImplicitVariables.put("_response_encoding", "java.lang.String");
        myImplicitVariables.put("result", "java.lang.Exception");
        myImplicitVariables.put("exception", "java.lang.Exception");
    }
}

