/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.engines.jbossws;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.WsJavaExternalProcessHandler;
import com.intellij.ws.engines.LibraryDescriptor;
import com.intellij.ws.engines.LibraryInfo;
import com.intellij.ws.engines.wsengine.DeployWebServiceOptions;
import com.intellij.ws.engines.wsengine.GenerateJavaFromWsdlOptions;
import com.intellij.ws.engines.wsengine.GenerateWsdlFromJavaOptions;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.FileUtils;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JBossWSEngine
implements WSEngine {
    private static final Logger LOG = Logger.getInstance((String)"webservicesplugin.jbosswsengine");
    private static final String JBOSS_WS_NAME = "JBossWS";
    @NonNls
    private static final String JBOSS_WSTOOLS_MAIN = "org.jboss.ws.tools.WSTools";

    @Override
    public boolean hasSeparateClientServerJavaCodeGenerationOption() {
        return false;
    }

    @Override
    public boolean allowsTestCaseGeneration() {
        return false;
    }

    @Override
    @Nullable
    public String[] getSupportedMappingTypesForJavaFromWsdl() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String getDeploymentServletName() {
        return null;
    }

    @Override
    public String getDeploymentServletClassName() {
        return null;
    }

    @Override
    public void doAdditionalWSServerSetup(Module currentModule, WebFacet webFacet) {
    }

    @Override
    public String checkNotAcceptableClassForGenerateWsdl(PsiClass clazz) {
        return clazz.isInterface() ? null : "JBossWS generates WSDL only from interface";
    }

    @Override
    public String checkNotAcceptableClassForDeployment(PsiClass clazz) {
        return clazz.isInterface() ? null : "Please, use WebService interface";
    }

    @Override
    public void generateWsdlFromJava(GenerateWsdlFromJavaOptions options, final Consumer<File> onSuccessAction, final Consumer<Exception> onException, Runnable editAgain) {
        try {
            StringBuffer configText = new StringBuffer();
            configText.append("<configuration xmlns=\"http://www.jboss.org/jbossws-tools\">\n");
            configText.append("<java-wsdl>\n");
            final PsiClass psiClass = options.getClassForOperation();
            configText.append("<service name=\"").append(psiClass.getName()).append("\" parameterStyle=\"").append(options.getUseOfItems().toLowerCase()).append("\" style=\"").append(options.getBindingStyle().toLowerCase()).append("\" endpoint=\"").append(psiClass.getQualifiedName()).append("\"/>\n").append("<namespaces target-namespace=\"").append(options.getWebServiceNamespace()).append("\" type-namespace=\"").append(options.getWebServiceNamespace()).append("\"/>\n");
            configText.append("</java-wsdl>\n");
            configText.append("</configuration>");
            File tempDir = FileUtils.createTempDir((String)"jbosswsgen");
            ExternalProcessHandler externalProcessHandler = this.buildWSToolsHandler(configText.toString(), options.getModule(), tempDir);
            File wsdlFile = new File(tempDir, "wsdl" + File.separatorChar + psiClass.getName() + ".wsdl");
            InvokeExternalCodeUtil.invokeExternalProcess2((ExternalProcessHandler)externalProcessHandler, (Project)options.getModule().getProject(), (Runnable)options.getSuccessRunnable(new Consumer<File>(){

                public void consume(File s) {
                    if (s.exists()) {
                        try {
                            File wsdlFile = FileUtils.saveStreamContentAsFile((String)(psiClass.getContainingFile().getContainingDirectory().getVirtualFile().getPath() + File.separatorChar + psiClass.getName() + ".wsdl"), (InputStream)new BufferedInputStream(new FileInputStream(s)));
                            onSuccessAction.consume((Object)wsdlFile);
                        }
                        catch (IOException e) {
                            onException.consume((Object)e);
                        }
                    }
                }
            }, wsdlFile), onException, options.isParametersStillValidPredicate(), (Runnable)editAgain);
        }
        catch (IOException e) {
            onException.consume((Object)e);
        }
    }

    @Override
    public void deployWebService(DeployWebServiceOptions createOptions, Module module, Runnable onSuccessAction, Consumer<Exception> onExceptionAction, Runnable restartAction) {
        StringBuffer textBuffer = new StringBuffer();
        textBuffer.append("<configuration xmlns=\"http://www.jboss.org/jbossws-tools\">\n");
        textBuffer.append("<java-wsdl>\n");
        textBuffer.append("<service name=\"").append(createOptions.getWsName()).append("\" parameterStyle=\"").append(createOptions.getUseOfItems().toLowerCase()).append("\" style=\"").append(createOptions.getBindingStyle().toLowerCase()).append("\" endpoint=\"").append(createOptions.getWsClassName()).append("\"/>\n").append("<namespaces target-namespace=\"").append(createOptions.getWsNamespace()).append("\" type-namespace=\"").append(createOptions.getWsNamespace()).append("\"/>\n").append("<mapping file=\"jaxrpc.mapping.xml\"/>\n").append("<webservices servlet-link=\"").append(createOptions.getWsName()).append("\"/>");
        textBuffer.append("</java-wsdl>\n");
        textBuffer.append("</configuration>");
        File outputPath = new File(LibUtils.findOutputDir(module));
        ExternalProcessHandler externalProcessHandler = this.buildWSToolsHandler(textBuffer.toString(), module, outputPath);
        String[] fileNamesToMove = new String[]{"webservices.xml", "jaxrpc.mapping.xml", "wsdl/" + createOptions.getWsName() + ".wsdl"};
        InvokeExternalCodeUtil.runViaConsole((ExternalProcessHandler)externalProcessHandler, (Project)module.getProject(), (Runnable)onSuccessAction, onExceptionAction, null, null);
    }

    @Override
    public void undeployWebService(String webServiceName, Module module, Runnable onSuccessAction, Consumer<Exception> onExceptionAction, Runnable restartAction) {
        onSuccessAction.run();
    }

    @Override
    public String[] getAvailableWebServices(Module module) {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] getWebServicesOperations(String webServiceName, Module module) {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public ExternalProcessHandler getGenerateJavaFromWsdlHandler(GenerateJavaFromWsdlOptions options) {
        StringBuffer configText = new StringBuffer();
        String nsFromUrl = options.getWsdlUrl();
        nsFromUrl = StringUtil.trimEnd((String)nsFromUrl, (String)"?wsdl");
        configText.append("<configuration xmlns=\"http://www.jboss.org/jbossws-tools\">\n");
        configText.append("<global><package-namespace package=\"").append(options.getPackagePrefix()).append("\" namespace=\"").append(nsFromUrl).append("\" /></global>\n");
        configText.append("<wsdl-java file=\"").append(options.getSavedWsdlFile().getPath()).append("\">\n");
        configText.append("<mapping file=\"").append(options.getPackagePrefix().replace('.', '/')).append('/').append("jax-rpc-mapping.xml\" />\n").append("  </wsdl-java>\n").append("</configuration>");
        return this.buildWSToolsHandler(configText.toString(), options.getSelectedModule(), new File(options.getOutputPath()));
    }

    @Override
    public boolean isConfigured() {
        return this.getBasePath() != null;
    }

    private ExternalProcessHandler buildWSToolsHandler(String configText, Module contextModule, File launchContext) {
        File tempFile;
        try {
            tempFile = FileUtil.createTempFile((String)"jbossws", (String)"config.xml");
            tempFile.deleteOnExit();
            FileUtil.writeToFile((File)tempFile, (String)configText);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        LinkedList<String> commandLineParameters = new LinkedList<String>();
        String classPath = InvokeExternalCodeUtil.buildClasspathForModule((Module)contextModule);
        if (classPath.length() > 0) {
            commandLineParameters.add("-cp");
            commandLineParameters.add(classPath);
        }
        commandLineParameters.add("-config");
        commandLineParameters.add(tempFile.getPath());
        WsJavaExternalProcessHandler javaExternalProcessHandler = new WsJavaExternalProcessHandler("JBossWS WSTools", JBOSS_WSTOOLS_MAIN, LibUtils.getLibUrlsForToolRunning(this, null), ArrayUtil.toStringArray(commandLineParameters), null, false);
        javaExternalProcessHandler.addCommandLineProperty("java.endorsed.dirs", this.getBasePath() + File.separatorChar + "lib" + File.separatorChar + "endorsed");
        javaExternalProcessHandler.setLaunchDir(launchContext);
        return javaExternalProcessHandler;
    }

    @Override
    public String getName() {
        return JBOSS_WS_NAME;
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, boolean isForGeneratedCode) {
        boolean jbossws1_2;
        String client = "client";
        String baseDir = client + File.separatorChar;
        boolean jbossws5 = new File(this.getBasePath(), client + "/jbossws-native-client.jar").exists();
        boolean jbossws2 = new File(this.getBasePath(), client + "/jbossws-framework.jar").exists() && !jbossws5;
        boolean bl = jbossws1_2 = !new File(this.getBasePath(), client + "/jbossws14-client.jar").exists() && !jbossws2;
        if (jbossws5) {
            return new LibraryDescriptor[]{new LibraryInfo(JBOSS_WS_NAME, new String[]{baseDir + "jboss-xml-binding.jar", baseDir + "activation.jar", baseDir + "javassist.jar", baseDir + "jbossws-native-jaxrpc.jar", baseDir + "jbossws-native-jaxws.jar", baseDir + "jbossws-native-jaxws-ext.jar", baseDir + "jbossws-native-saaj.jar", baseDir + "jbossws-native-client.jar", baseDir + "wsdl4j.jar", baseDir + "jbossall-client.jar", baseDir + "log4j.jar", baseDir + "mail.jar"})};
        }
        return new LibraryDescriptor[]{new LibraryInfo(JBOSS_WS_NAME, new String[]{baseDir + "jboss-xml-binding.jar", baseDir + "activation.jar", baseDir + "javassist.jar", baseDir + "jboss-jaxrpc.jar", baseDir + "jboss-jaxws.jar", baseDir + "jboss-saaj.jar", baseDir + "jbossws-client.jar", baseDir + "wsdl4j.jar", baseDir + "jbossall-client.jar", baseDir + "jbossretro-rt.jar", baseDir + "jboss-backport-concurrent.jar", baseDir + "jbossws-client.jar", baseDir + "jbossws14-client.jar", baseDir + "log4j.jar", baseDir + "mail.jar"})};
    }

    @Override
    public String getBasePath() {
        return WebServicesPluginSettings.getInstance().getJBossWSPath();
    }

    @Override
    public boolean supportsJaxWs2() {
        return false;
    }

    @Override
    public boolean deploymentSupported() {
        return false;
    }

    @Override
    public String getServiceInvocationTemplateName() {
        return "ijws";
    }

    @Override
    public String getWebServicesInterfaceTemplateName() {
        return "j2ee1_4.webservice.interface.java";
    }

    @Override
    public String getWebServicesTemplateName() {
        return "j2ee1_4.webservice.java";
    }
}

