/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.facet.client;

import com.intellij.facet.frameworks.LibrariesDownloadAssistant;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import java.net.URL;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebServicesClientLibraries {
    public static final String JAXWS = JWSDPWSEngine.JWSDP_PLATFORM;
    public static final String AXIS = "Apache Axis";
    public static final String[] SUPPORTED_PLATFORM = new String[]{JAXWS, "Apache Axis"};
    @NonNls
    public static final HashMap<String, String> PLATFORM_NAMES = new HashMap();
    public static final HashMap<String, String> DEFAULT_VERSIONS;

    private WebServicesClientLibraries() {
    }

    public static boolean isSupported(String platformName) {
        for (String platform : SUPPORTED_PLATFORM) {
            if (!platform.equals(platformName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static URL createUrl(@NotNull String platform) {
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/intellij/ws/facet/client/WebServicesClientLibraries", "createUrl"));
        }
        String shortName = PLATFORM_NAMES.get(platform);
        URL uRL = WebServicesClientLibraries.class.getResource("/versions/" + shortName + ".xml");
        if (uRL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/facet/client/WebServicesClientLibraries", "createUrl"));
        }
        return uRL;
    }

    @NotNull
    public static LibraryInfo[] getRequiredLibraries(@NotNull String platform, @NotNull String versionId) {
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/intellij/ws/facet/client/WebServicesClientLibraries", "getRequiredLibraries"));
        }
        if (versionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionId", "com/intellij/ws/facet/client/WebServicesClientLibraries", "getRequiredLibraries"));
        }
        LibraryInfo[] libraryInfoArray = LibrariesDownloadAssistant.getLibraryInfos((URL)WebServicesClientLibraries.createUrl(platform), (String)versionId);
        if (libraryInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/facet/client/WebServicesClientLibraries", "getRequiredLibraries"));
        }
        return libraryInfoArray;
    }

    @NotNull
    public static LibraryInfo[] getRequiredLibraries(@NotNull String platform) {
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/intellij/ws/facet/client/WebServicesClientLibraries", "getRequiredLibraries"));
        }
        LibraryInfo[] libraryInfoArray = WebServicesClientLibraries.getRequiredLibraries(platform, DEFAULT_VERSIONS.get(platform));
        if (libraryInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/facet/client/WebServicesClientLibraries", "getRequiredLibraries"));
        }
        return libraryInfoArray;
    }

    public static String[] getRequiredJarNames(@NotNull String platform) {
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/intellij/ws/facet/client/WebServicesClientLibraries", "getRequiredJarNames"));
        }
        return (String[])ContainerUtil.map2Array((Object[])WebServicesClientLibraries.getRequiredLibraries(platform), String.class, (Function)new Function<LibraryInfo, String>(){

            public String fun(LibraryInfo libraryInfo) {
                return libraryInfo.getName();
            }
        });
    }

    static {
        PLATFORM_NAMES.put(JAXWS, "jaxws");
        PLATFORM_NAMES.put(AXIS, "axis");
        DEFAULT_VERSIONS = new HashMap();
        DEFAULT_VERSIONS.put(JAXWS, JAXWS);
        DEFAULT_VERSIONS.put(AXIS, "1.4");
    }
}

