/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class ModuleContentsScope
extends GlobalSearchScope {
    private final Module myModule;
    private final ModuleFileIndex myIndex;

    public ModuleContentsScope(Module module) {
        super(module.getProject());
        this.myModule = module;
        this.myIndex = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ws/index/ModuleContentsScope", "contains"));
        }
        return this.myIndex.isInContent(file);
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/ws/index/ModuleContentsScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/ws/index/ModuleContentsScope", "compare"));
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/ws/index/ModuleContentsScope", "isSearchInModuleContent"));
        }
        return this.myModule == aModule;
    }

    public boolean isSearchInLibraries() {
        return false;
    }
}

