/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class InsertAnnotationFix
implements LocalQuickFix {
    private final String annotationToInsert;

    protected InsertAnnotationFix(String _annotationToInsert) {
        this.annotationToInsert = _annotationToInsert;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/InsertAnnotationFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(final @NotNull Project project, final @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/inspections/InsertAnnotationFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ws/inspections/InsertAnnotationFix", "applyFix"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiElement psiElement = descriptor.getPsiElement();
                try {
                    PsiModifierList modifierList = ((PsiModifierListOwner)psiElement.getParent()).getModifierList();
                    if (modifierList == null) {
                        return;
                    }
                    if (!FileModificationService.getInstance().prepareFileForWrite(psiElement.getContainingFile())) {
                        return;
                    }
                    PsiAnnotation psiAnnotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(InsertAnnotationFix.this.annotationToInsert, psiElement);
                    PsiElement element = modifierList.getFirstChild();
                    if (element != null) {
                        modifierList.addBefore((PsiElement)psiAnnotation, element);
                    } else {
                        modifierList.add((PsiElement)psiAnnotation);
                    }
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)modifierList);
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

