/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemKey;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

@Presentation(typeName = "@Controller")
public class SpringController extends SpringMetaStereotypeComponent {
  public static final SemKey<JamMemberMeta<PsiClass, SpringController>> META_KEY =
    JamService.ALIASING_MEMBER_META_KEY.subKey("SpringControllerMeta");

  public static final SemKey<SpringController> JAM_KEY =
    JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY.subKey("SpringController");

  public static final JamClassMeta<SpringController> META =
    new JamClassMeta<SpringController>(null, SpringController.class, JAM_KEY);

  private static final Function<Module, Collection<String>> ANNOTATIONS = new Function<Module, Collection<String>>() {
    @Override
    public Collection<String> fun(Module module) {
      return getAnnotations(module, SpringAnnotationsConstants.CONTROLLER);
    }
  };

  @SuppressWarnings("unused")
  public SpringController(@NotNull PsiClass psiClass) {
    this(SpringAnnotationsConstants.CONTROLLER, psiClass);
  }

  public SpringController(@NotNull String anno, @NotNull PsiClass psiClass) {
    super(anno, psiClass);
  }

  @NotNull
  public static Function<Pair<String, PsiClass>, SpringController> getControllerProducer() {
    return new Function<Pair<String, PsiClass>, SpringController>() {
      @Override
      public SpringController fun(Pair<String, PsiClass> pair) {
        return new SpringController(pair.first, pair.second);
      }
    };
  }

  @NotNull
  public static Function<Module, Collection<String>> getControllerAnnotations() {
    return ANNOTATIONS;
  }
}
