/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.psi.css;

import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;

public interface CssPseudoPage extends CssPseudoClass {
  CssPseudoPage[] EMPTY_ARRAY = new CssPseudoPage[0];
  ArrayFactory<CssPseudoPage> ARRAY_FACTORY = new ArrayFactory<CssPseudoPage>() {
    @NotNull
    @Override
    public CssPseudoPage[] create(int count) {
      return count == 0 ? EMPTY_ARRAY : new CssPseudoPage[count];
    }
  };
}
