package com.intellij.psi.css.descriptor;

import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

import java.util.Comparator;

public class CssVersionDescriptorComparator implements Comparator<CssElementDescriptor> {
  @Override
  public int compare(@NotNull CssElementDescriptor o1,
                     @NotNull CssElementDescriptor o2) {
    int i = o2.getCssVersion().value() - o1.getCssVersion().value();
    if (i != 0) return i;
    i = ArrayUtil.lexicographicCompare(o2.getAllowedContextTypes(), o1.getAllowedContextTypes());
    if (i != 0) return i;
    return o1.equals(o2) ? 0 : 1;
  }
}
