/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.sql.psi;

import com.intellij.sql.psi.impl.SqlTokenType;

import static com.intellij.sql.util.SqlTokenRegistry.getType;

/**
 * @author Gregory.Shrago
 */
public interface SqlCommonKeywords {
  SqlTokenType SQL_ADD = getType("ADD");
  SqlTokenType SQL_ALL = getType("ALL");
  SqlTokenType SQL_ALTER = getType("ALTER");
  SqlTokenType SQL_AND = getType("AND");
  SqlTokenType SQL_ANY = getType("ANY");
  SqlTokenType SQL_AS = getType("AS");
  SqlTokenType SQL_AT = getType("AT");
  SqlTokenType SQL_BEGIN = getType("BEGIN");
  SqlTokenType SQL_BETWEEN = getType("BETWEEN");
  SqlTokenType SQL_BY = getType("BY");
  SqlTokenType SQL_CASE = getType("CASE");
  SqlTokenType SQL_CHANGE = getType("CHANGE");
  SqlTokenType SQL_COLLATE = getType("COLLATE");
  SqlTokenType SQL_CREATE = getType("CREATE");
  SqlTokenType SQL_DATE = getType("DATE");
  SqlTokenType SQL_DAY = getType("DAY");
  SqlTokenType SQL_DEFAULT = getType("DEFAULT");
  SqlTokenType SQL_DISTINCT = getType("DISTINCT");
  SqlTokenType SQL_DROP = getType("DROP");
  SqlTokenType SQL_ELSE = getType("ELSE");
  SqlTokenType SQL_END = getType("END");
  SqlTokenType SQL_ESCAPE = getType("ESCAPE");
  SqlTokenType SQL_EXCEPT = getType("EXCEPT");
  SqlTokenType SQL_EXISTS = getType("EXISTS");
  SqlTokenType SQL_FALSE = getType("FALSE");
  SqlTokenType SQL_FOR = getType("FOR");
  SqlTokenType SQL_FROM = getType("FROM");
  SqlTokenType SQL_FULL = getType("FULL");
  SqlTokenType SQL_GROUP = getType("GROUP");
  SqlTokenType SQL_GO = getType("GO");
  SqlTokenType SQL_HAVING = getType("HAVING");
  SqlTokenType SQL_HOUR = getType("HOUR");
  SqlTokenType SQL_IDENTITY = getType("IDENTITY");
  SqlTokenType SQL_IN = getType("IN");
  SqlTokenType SQL_INDICATOR = getType("INDICATOR");
  SqlTokenType SQL_INSERT = getType("INSERT");
  SqlTokenType SQL_INTERSECT = getType("INTERSECT");
  SqlTokenType SQL_INTERVAL = getType("INTERVAL");
  SqlTokenType SQL_INTO = getType("INTO");
  SqlTokenType SQL_IS = getType("IS");
  SqlTokenType SQL_JOIN = getType("JOIN");
  SqlTokenType SQL_LIKE = getType("LIKE");
  SqlTokenType SQL_LATERAL = getType("LATERAL");
  SqlTokenType SQL_LOCAL = getType("LOCAL");
  SqlTokenType SQL_MATCH = getType("MATCH");
  SqlTokenType SQL_MINUTE = getType("MINUTE");
  SqlTokenType SQL_MODIFY = getType("MODIFY");
  SqlTokenType SQL_MODULE = getType("MODULE");
  SqlTokenType SQL_MONTH = getType("MONTH");
  SqlTokenType SQL_MINUS = getType("MINUS");
  SqlTokenType SQL_NATURAL = getType("NATURAL");
  SqlTokenType SQL_NOT = getType("NOT");
  SqlTokenType SQL_NULL = getType("NULL");
  SqlTokenType SQL_ON = getType("ON");
  SqlTokenType SQL_OR = getType("OR");
  SqlTokenType SQL_ORDER = getType("ORDER");
  SqlTokenType SQL_OVERLAPS = getType("OVERLAPS");
  SqlTokenType SQL_PARTIAL = getType("PARTIAL");
  SqlTokenType SQL_PRIOR = getType("PRIOR");
  SqlTokenType SQL_SECOND = getType("SECOND");
  SqlTokenType SQL_SET = getType("SET");
  SqlTokenType SQL_SOME = getType("SOME");
  SqlTokenType SQL_SELECT = getType("SELECT");
  SqlTokenType SQL_TABLE = getType("TABLE");
  SqlTokenType SQL_TEMPORARY = getType("TEMPORARY");
  SqlTokenType SQL_THEN = getType("THEN");
  SqlTokenType SQL_TIME = getType("TIME");
  SqlTokenType SQL_TIMESTAMP = getType("TIMESTAMP");
  SqlTokenType SQL_TO = getType("TO");
  SqlTokenType SQL_TRUE = getType("TRUE");
  SqlTokenType SQL_UNION = getType("UNION");
  SqlTokenType SQL_UNIQUE = getType("UNIQUE");
  SqlTokenType SQL_UNKNOWN = getType("UNKNOWN");
  SqlTokenType SQL_UPDATE = getType("UPDATE");
  SqlTokenType SQL_USER = getType("USER");
  SqlTokenType SQL_VALUE = getType("VALUE");
  SqlTokenType SQL_VALUES = getType("VALUES");
  SqlTokenType SQL_VIEW = getType("VIEW");
  SqlTokenType SQL_WHEN = getType("WHEN");
  SqlTokenType SQL_WHERE = getType("WHERE");
  SqlTokenType SQL_WITH = getType("WITH");
  SqlTokenType SQL_YEAR = getType("YEAR");
  SqlTokenType SQL_ZONE = getType("ZONE");
  SqlTokenType SQL_ROW = getType("ROW");

  //SqlTokenType SQL_IN = getType("IN");
  SqlTokenType SQL_OUT = getType("OUT");
  SqlTokenType SQL_OUTER = getType("OUTER");
  SqlTokenType SQL_INOUT = getType("INOUT");
  
  SqlTokenType SQL_LEFT = getType("LEFT");
  SqlTokenType SQL_RIGHT = getType("RIGHT");
  
  SqlTokenType SQL_PERFORM = getType("PERFORM");

  SqlTokenType SQL_DELIMITER = getType("DELIMITER");
  SqlTokenType SQL_IF = getType("IF");
  SqlTokenType SQL_RENAME = getType("RENAME");
  SqlTokenType SQL_REPEAT = getType("REPEAT");
  SqlTokenType SQL_LOOP = getType("LOOP");
  SqlTokenType SQL_RECURSIVE = getType("RECURSIVE");
}