/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.model.converters;

import com.intellij.batch.model.BatchJobXmlModel;
import com.intellij.batch.model.BatchXmlDomModelManager;
import com.intellij.batch.model.job.Flow;
import com.intellij.batch.model.job.Identified;
import com.intellij.batch.model.job.IdentifiedContainer;
import com.intellij.batch.model.job.Job;
import com.intellij.batch.utils.BatchCommonUtils;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchIdentifiedConverter
extends ResolvingConverter<Identified> {
    public Identified fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        for (Identified identified : this.getIdentifiedList(context)) {
            if (!s.equals(identified.getId().getStringValue())) continue;
            return identified;
        }
        return null;
    }

    @NotNull
    protected List<Identified> getIdentifiedList(@NotNull ConvertContext context) {
        IdentifiedContainer scopeContainer;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/batch/model/converters/BatchIdentifiedConverter", "getIdentifiedList"));
        }
        Identified identified = (Identified)DomUtil.getParentOfType((DomElement)context.getInvocationElement(), Identified.class, (boolean)false);
        if (identified != null && (scopeContainer = (IdentifiedContainer)DomUtil.getParentOfType((DomElement)identified, IdentifiedContainer.class, (boolean)true)) instanceof Flow) {
            List<Identified> list = BatchCommonUtils.getAllIdentified(scopeContainer);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/model/converters/BatchIdentifiedConverter", "getIdentifiedList"));
            }
            return list;
        }
        BatchJobXmlModel batchJobXmlModel = BatchIdentifiedConverter.getBatchJobXmlModel(context);
        if (batchJobXmlModel == null) {
            List<Identified> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/model/converters/BatchIdentifiedConverter", "getIdentifiedList"));
            }
            return list;
        }
        Job job = batchJobXmlModel.getJob();
        List<Identified> list = BatchCommonUtils.getAllIdentified(job);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/model/converters/BatchIdentifiedConverter", "getIdentifiedList"));
        }
        return list;
    }

    public LookupElement createLookupElement(Identified identified) {
        return LookupElementBuilder.create((String)identified.getId().getStringValue());
    }

    @Nullable
    private static BatchJobXmlModel getBatchJobXmlModel(ConvertContext context) {
        XmlFile xmlFile = context.getFile();
        return BatchXmlDomModelManager.getInstance(xmlFile.getProject()).getBatchJobXmlModel(xmlFile);
    }

    public String toString(@Nullable Identified identified, ConvertContext context) {
        if (identified == null) {
            return null;
        }
        return identified.getId().getStringValue();
    }

    @NotNull
    public Collection<Identified> getVariants(ConvertContext context) {
        List<Identified> list = this.getIdentifiedList(context);
        Identified itsMe = (Identified)DomUtil.getParentOfType((DomElement)context.getInvocationElement(), Identified.class, (boolean)false);
        if (itsMe != null) {
            list.remove(itsMe);
        }
        List<Identified> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/model/converters/BatchIdentifiedConverter", "getVariants"));
        }
        return list2;
    }
}

