/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser.analyzer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.w3c.css.media.AtRuleMedia;
import org.w3c.css.media.MediaFeature;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.AtRuleFontFace;
import org.w3c.css.parser.AtRuleKeyframes;
import org.w3c.css.parser.AtRulePage;
import org.w3c.css.parser.AtRulePhoneticAlphabet;
import org.w3c.css.parser.AtRulePreference;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.analyzer.CssParserConstants;
import org.w3c.css.parser.analyzer.CssParserTokenManager;
import org.w3c.css.parser.analyzer.ParseException;
import org.w3c.css.parser.analyzer.SimpleCharStream;
import org.w3c.css.parser.analyzer.Token;
import org.w3c.css.parser.analyzer.TokenMgrError;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.svg.AtRuleColorProfile;
import org.w3c.css.selectors.AdjacentSiblingSelector;
import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.ChildSelector;
import org.w3c.css.selectors.ClassSelector;
import org.w3c.css.selectors.DescendantSelector;
import org.w3c.css.selectors.GeneralSiblingSelector;
import org.w3c.css.selectors.IdSelector;
import org.w3c.css.selectors.TypeSelector;
import org.w3c.css.selectors.UniversalSelector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.selectors.attributes.AttributeOneOf;
import org.w3c.css.selectors.attributes.AttributeStart;
import org.w3c.css.selectors.attributes.AttributeSubstr;
import org.w3c.css.selectors.attributes.AttributeSuffix;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssProfile;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.util.WarningParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssHashIdent;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssImage;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssRatio;
import org.w3c.css.values.CssResolution;
import org.w3c.css.values.CssSemitone;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssSwitch;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssURL;
import org.w3c.css.values.CssUnicodeRange;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssVolume;

public abstract class CssParser
implements CssParserConstants {
    private static char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected AtRule atRule;
    protected boolean mediaDeclaration = false;
    protected URL url;
    protected ApplContext ac;
    protected boolean incompatible_error;
    protected ArrayList<CssSelectors> currentContext;
    protected String currentProperty;
    protected boolean mode;
    protected boolean markRule;
    private boolean reinited = false;
    private boolean charsetdeclared = false;
    protected boolean validSelector = true;
    public CssParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[156];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public final void setApplContext(ApplContext ac) {
        this.ac = ac;
    }

    public void setAtRule(AtRule atRule) {
        this.atRule = atRule;
    }

    public void setMediaDeclaration(boolean mediadeclaration) {
        this.mediaDeclaration = mediadeclaration;
    }

    public boolean hasMediaDeclaration() {
        return this.mediaDeclaration;
    }

    public AtRule getAtRule() {
        return this.atRule;
    }

    public void ReInitWithAc(InputStream stream, ApplContext ac, String charset) {
        InputStream is = stream;
        if (charset == null) {
            charset = "iso-8859-1";
        }
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, charset);
        }
        catch (UnsupportedEncodingException uex) {
            isr = new InputStreamReader(is);
        }
        this.ReInit(isr);
        this.markRule = false;
        this.reinited = true;
        this.setApplContext(ac);
    }

    public abstract void handleImport(URL var1, String var2, boolean var3, AtRuleMedia var4);

    public abstract void handleNamespaceDeclaration(URL var1, String var2, String var3, boolean var4);

    public abstract void handleAtRule(String var1, String var2);

    public abstract void addCharSet(String var1);

    public abstract void newAtRule(AtRule var1);

    public abstract void endOfAtRule();

    public abstract void setImportant(boolean var1);

    public abstract void setSelectorList(ArrayList<CssSelectors> var1);

    public abstract void addProperty(ArrayList<CssProperty> var1);

    public abstract void endOfRule();

    public abstract void removeThisRule();

    public abstract void removeThisAtRule();

    public abstract CssProperty handleDeclaration(String var1, CssExpression var2, boolean var3) throws InvalidParamException;

    public abstract MediaFeature handleMediaFeature(AtRuleMedia var1, String var2, CssExpression var3) throws InvalidParamException;

    public abstract void handleRule(CssSelectors var1, ArrayList<CssProperty> var2);

    public final String getSourceFile() {
        return this.getURL().toString();
    }

    public final int getLine() {
        return 0;
    }

    public final void setURL(URL url) {
        this.url = url;
    }

    public final URL getURL() {
        return this.url;
    }

    public CssSelectors parseSelector() throws ParseException {
        return this.externalSelector();
    }

    public AtRuleMedia parseMediaDeclaration() throws ParseException {
        AtRuleMedia newRule = AtRuleMedia.getInstance(this.ac.getCssVersion());
        this.mediaquerylist(newRule);
        return newRule;
    }

    private void setValue(CssValue v, CssExpression expr, char operator, Token n, int token) throws ParseException {
        CssFunction f;
        if (token == 97 && v.getType() == 12 && (f = (CssFunction)v).getParameters().hasVendorExtensions()) {
            expr.markVendorExtension();
        }
        if (n != null) {
            String val;
            if (this.ac.getCssVersion() == CssVersion.CSS1 && n.image.equals("inherit")) {
                this.incompatible_error = true;
            }
            String string = val = operator == ' ' ? n.image : operator + n.image;
            if (n.kind == 35) {
                String s = this.convertIdent(val);
                if ('-' == s.charAt(0)) {
                    expr.markVendorExtension();
                }
                v.set(this.convertIdent(val), this.ac);
            } else if (n.kind == 33) {
                v.set(val, this.ac);
            } else {
                v.set(val, this.ac);
            }
        }
        expr.addValue(v);
    }

    private void addError(Exception e, String skippedText) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        CssParseException ex = new CssParseException(e);
        ex.setSkippedString(skippedText);
        ex.setProperty(this.currentProperty);
        ex.setContexts(this.currentContext);
        CssError error = new CssError(this.getSourceFile(), this.getLine(), ex);
        this.ac.getFrame().addError(error);
    }

    private void addError(Exception e, CssExpression exp) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        CssParseException ex = new CssParseException(e);
        ex.setExp(exp);
        ex.setProperty(this.currentProperty);
        ex.setContexts(this.currentContext);
        CssError error = new CssError(this.getSourceFile(), this.getLine(), ex);
        this.ac.getFrame().addError(error);
    }

    private void addParseError(ParseException e, String skipped) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        CssErrorToken err = new CssErrorToken(e, skipped);
        this.ac.getFrame().addError(err);
    }

    public final void parserUnit() throws ParseException {
        Token n = null;
        try {
            block31: {
                block26: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 98: 
                        case 99: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block26;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 98: {
                            n = this.jj_consume_token(98);
                            break;
                        }
                        case 99: {
                            n = this.jj_consume_token(99);
                            break;
                        }
                        default: {
                            this.jj_la1[1] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.addError((Exception)new ParseException(this.ac.getMsg().getString("generator.dontmixhtml")), n.image);
                }
                block27: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 68: {
                            break;
                        }
                        default: {
                            this.jj_la1[2] = this.jj_gen;
                            break block27;
                        }
                    }
                    this.charset();
                }
                block28: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: 
                        case 22: 
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block31;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            this.jj_consume_token(21);
                            continue block28;
                        }
                        case 22: {
                            this.jj_consume_token(22);
                            continue block28;
                        }
                        case 23: {
                            this.jj_consume_token(23);
                            continue block28;
                        }
                    }
                    break;
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block29: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 69: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        break block29;
                    }
                }
                this.importDeclaration();
                this.ignoreStatement();
            }
            block30: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 70: {
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        break block30;
                    }
                }
                this.namespaceDeclaration();
                this.ignoreStatement();
            }
            this.afterImportDeclaration();
            this.jj_consume_token(0);
        }
        catch (TokenMgrError err) {
            this.addError((Exception)new ParseException(this.ac.getMsg().getString("generator.unrecognize")), err.getMessage());
        }
    }

    public final void charset() throws ParseException {
        Token n = null;
        Token charsetToken = null;
        Token space1Token = null;
        Token space2Token = null;
        Token semicolonToken = null;
        int nb_S = 0;
        CssVersion version = this.ac.getCssVersion();
        try {
            charsetToken = this.jj_consume_token(68);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block8;
                    }
                }
                space1Token = this.jj_consume_token(21);
                ++nb_S;
            }
            n = this.jj_consume_token(33);
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block9;
                    }
                }
                space2Token = this.jj_consume_token(21);
            }
            semicolonToken = this.jj_consume_token(44);
            if (this.charsetdeclared && !this.reinited) {
                throw new ParseException(this.ac.getMsg().getString("parser.charset"));
            }
            if (charsetToken.beginLine != 1 || charsetToken.beginColumn != 1) {
                throw new ParseException(this.ac.getMsg().getString("parser.charset"));
            }
            if (version == CssVersion.CSS1) {
                throw new ParseException(this.ac.getMsg().getString("parser.charsetcss1"));
            }
            if (!(version.compareTo(CssVersion.CSS21) < 0 || nb_S == 1 && "@charset".equals(charsetToken.image) && " ".equals(space1Token.image) && (space2Token == null || "".equals(space2Token.image)) && space1Token.specialToken == null && n.specialToken == null && semicolonToken.specialToken == null && n.image.charAt(0) == '\"')) {
                throw new ParseException(this.ac.getMsg().getString("parser.charsetspecial"));
            }
            if (!this.charsetdeclared) {
                this.addCharSet(n.image.substring(1, n.image.length() - 1));
                this.charsetdeclared = true;
            } else {
                this.reinited = false;
            }
        }
        catch (Exception e) {
            String skip = charsetToken + (space1Token == null ? "" : space1Token.image) + n + (space2Token == null ? "" : space2Token.image) + ";";
            this.addError(e, skip);
        }
    }

    public final void afterImportDeclaration() throws ParseException {
        while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 46: 
                case 48: 
                case 52: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 94: 
                case 96: 
                case 100: {
                    this.ruleSet();
                    break;
                }
                case 71: {
                    this.media();
                    break;
                }
                case 72: {
                    this.page();
                    break;
                }
                case 73: {
                    this.fontFace();
                    break;
                }
                case 74: {
                    this.keyframes();
                    break;
                }
                case 75: {
                    this.preference();
                    break;
                }
                case 76: {
                    this.colorprofile();
                    break;
                }
                case 82: {
                    this.phoneticAlphabet();
                    break;
                }
                default: {
                    ParseException e;
                    this.jj_la1[9] = this.jj_gen;
                    String ret = this.skipStatement();
                    if (ret == null || ret.length() == 0) {
                        return;
                    }
                    if (ret.startsWith("@charset")) {
                        e = new ParseException(this.ac.getMsg().getString("parser.charset"));
                        this.addError((Exception)e, ret);
                        break;
                    }
                    if (ret.startsWith("@import")) {
                        e = new ParseException(this.ac.getMsg().getString("parser.import_not_allowed"));
                        this.addError((Exception)e, ret);
                        break;
                    }
                    e = new ParseException(this.ac.getMsg().getString("generator.unrecognize"));
                    this.addError((Exception)e, ret);
                }
            }
            this.ignoreStatement();
        }
    }

    public final void ignoreStatement() throws ParseException {
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: 
                case 23: 
                case 83: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block11;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    this.jj_consume_token(22);
                    break;
                }
                case 23: {
                    this.jj_consume_token(23);
                    break;
                }
                case 83: {
                    this.atRuleDeclaration();
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        continue block11;
                    }
                }
                this.jj_consume_token(21);
            }
            break;
        }
    }

    public final void namespaceDeclaration() throws ParseException {
        String nsname;
        boolean is_url;
        Token n = null;
        Token v = null;
        String prefix = null;
        this.jj_consume_token(70);
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block19;
                }
            }
            this.jj_consume_token(21);
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                n = this.jj_consume_token(35);
                prefix = this.convertIdent(n.image);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                v = this.jj_consume_token(33);
                is_url = false;
                nsname = v.image.substring(1, v.image.length() - 1);
                break;
            }
            case 53: {
                v = this.jj_consume_token(53);
                is_url = true;
                CssURL val = new CssURL();
                val.set(v.image, this.ac, this.url);
                nsname = (String)((CssValue)val).get();
                if (nsname.charAt(0) != '\"' && nsname.charAt(0) != '\'') break;
                nsname = nsname.substring(1, nsname.length() - 1);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block21;
                }
            }
            this.jj_consume_token(21);
        }
        this.jj_consume_token(44);
        block22: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block22;
                }
            }
            this.jj_consume_token(21);
        }
        if (this.ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            this.addError((Exception)new InvalidParamException("at-rule", "@namespace", this.ac), n == null ? "default" : n.toString());
        } else if (v != null) {
            this.handleNamespaceDeclaration(this.getURL(), prefix, nsname, is_url);
        }
    }

    public final void importDeclaration() throws ParseException {
        AtRuleMedia media = AtRuleMedia.getInstance(this.ac.getCssVersion());
        boolean is_url = false;
        try {
            String importFile;
            this.jj_consume_token(69);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    Token n = this.jj_consume_token(33);
                    importFile = n.image.substring(1, n.image.length() - 1);
                    is_url = false;
                    break;
                }
                case 53: {
                    Token n = this.jj_consume_token(53);
                    CssURL val = new CssURL();
                    val.set(n.image, this.ac, this.url);
                    importFile = (String)((CssValue)val).get();
                    if (importFile.charAt(0) == '\"' || importFile.charAt(0) == '\'') {
                        importFile = importFile.substring(1, importFile.length() - 1);
                    }
                    is_url = true;
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                        break block19;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: 
                case 35: 
                case 51: {
                    this.mediaquerylist(media);
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                }
            }
            this.jj_consume_token(44);
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(21);
            }
            this.handleImport(this.getURL(), importFile, is_url, media);
        }
        catch (ParseException e) {
            this.addError((Exception)e, this.skipStatement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AtRuleMedia media() throws ParseException {
        AtRule old = this.getAtRule();
        AtRuleMedia newRule = AtRuleMedia.getInstance(this.ac.getCssVersion());
        this.setAtRule(newRule);
        Object p = null;
        boolean isCss1 = this.ac.getCssVersion() == CssVersion.CSS1;
        try {
            Token n = this.jj_consume_token(71);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(21);
            }
            this.mediaquerylist(newRule);
            String media = this.getAtRule().toString();
            if (this.ac.getMedium() != null && !media.equals(this.ac.getMedium()) && !this.ac.getMedium().equals("all")) {
                this.ac.getFrame().addWarning("noothermedium", this.getAtRule().toString());
            }
            if (isCss1) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            } else {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(26);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(21);
            }
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 46: 
                    case 48: 
                    case 52: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 67: 
                    case 94: 
                    case 96: 
                    case 100: {
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                        break block19;
                    }
                }
                this.ruleSet();
            }
            this.jj_consume_token(38);
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[27] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!isCss1) {
                this.endOfAtRule();
            }
        }
        catch (ParseException e) {
            if (!isCss1) {
                this.addError((Exception)e, this.skipStatement());
            }
            newRule = null;
            return newRule;
        }
        finally {
            this.setAtRule(old);
            return newRule;
        }
    }

    public final void ratio(CssExpression exp, char operator) throws ParseException {
        Token w = this.jj_consume_token(65);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(21);
        }
        this.jj_consume_token(45);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(21);
        }
        Token h = this.jj_consume_token(65);
        StringBuilder sb = new StringBuilder();
        sb.append(w.image).append('/').append(h.image);
        Token n = Token.newToken(w.kind, sb.toString());
        this.setValue(new CssRatio(), exp, operator, n, 65);
    }

    public final void mediaquerylist(AtRuleMedia mediaRule) throws ParseException {
        CssVersion v = this.ac.getCssVersion();
        boolean isCss1 = v == CssVersion.CSS1;
        this.mediaquery(mediaRule);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(29);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(21);
            }
            this.mediaquery(mediaRule);
        }
    }

    public final void mediaquery(AtRuleMedia mediaRule) throws ParseException {
        CssVersion v = this.ac.getCssVersion();
        boolean isCss1 = v == CssVersion.CSS1;
        String mediarestrictor = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: 
            case 35: {
                Token n;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 32: {
                        n = this.jj_consume_token(32);
                        mediarestrictor = this.convertIdent(n.image);
                        block25: while (true) {
                            this.jj_consume_token(21);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 21: {
                                    continue block25;
                                }
                            }
                            break;
                        }
                        this.jj_la1[32] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                    }
                }
                n = this.jj_consume_token(35);
                mediaRule.addMedia(mediarestrictor, this.convertIdent(n.image), this.ac);
                block26: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[34] = this.jj_gen;
                            break block26;
                        }
                    }
                    this.jj_consume_token(21);
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 31: {
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(31);
                    block28: while (true) {
                        this.jj_consume_token(21);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                continue block28;
                            }
                        }
                        break;
                    }
                    this.jj_la1[36] = this.jj_gen;
                    this.mediaexpression(mediaRule, false);
                }
            }
            case 51: {
                this.mediaexpression(mediaRule, true);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 31: {
                            break;
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(31);
                    block30: while (true) {
                        this.jj_consume_token(21);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                continue block30;
                            }
                        }
                        break;
                    }
                    this.jj_la1[38] = this.jj_gen;
                    this.mediaexpression(mediaRule, false);
                }
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void mediaexpression(AtRuleMedia mediaRule, boolean defaultMedia) throws ParseException {
        CssVersion v = this.ac.getCssVersion();
        boolean isCss1 = v == CssVersion.CSS1;
        CssExpression val = null;
        String mediaFeatureName = null;
        this.jj_consume_token(51);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(21);
        }
        Token n = this.jj_consume_token(35);
        if (defaultMedia) {
            mediaRule.addMedia(null, null, this.ac);
        }
        mediaFeatureName = this.convertIdent(n.image);
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block16;
                }
            }
            this.jj_consume_token(21);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[42] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.jj_consume_token(21);
                }
                val = this.mediaexpr();
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        this.jj_consume_token(50);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(21);
        }
        MediaFeature mf = this.handleMediaFeature(mediaRule, mediaFeatureName, val);
        mediaRule.addMediaFeature(mf, this.ac);
    }

    public final void unused_production_generic_syntax() throws ParseException {
        CssExpression values = new CssExpression();
        this.jj_consume_token(51);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        this.term(values);
        this.jj_consume_token(50);
    }

    public final void definition() throws ParseException {
        CssExpression values = new CssExpression();
        this.jj_consume_token(46);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        this.term(values);
        this.jj_consume_token(47);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void page() throws ParseException {
        Token n = null;
        ArrayList<CssProperty> collectv = new ArrayList();
        CssSelectors s = new CssSelectors(this.ac);
        AtRule old = this.getAtRule();
        AtRulePage newRule = new AtRulePage();
        this.setAtRule(newRule);
        s.setAtRule(this.getAtRule());
        boolean isCss1 = this.ac.getCssVersion() == CssVersion.CSS1;
        try {
            this.jj_consume_token(72);
            block25: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                        break block25;
                    }
                }
                this.jj_consume_token(21);
            }
            block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    n = this.jj_consume_token(35);
                    newRule.setIdent(this.convertIdent(n.image));
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[48] = this.jj_gen;
                                break block6;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 52: {
                    this.pseudo_page(newRule);
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                }
            }
            this.jj_consume_token(26);
            block27: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[51] = this.jj_gen;
                        break block27;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> v = this.pageContent();
            collectv = v;
            this.jj_consume_token(38);
            block28: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        break block28;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!isCss1) {
                this.newAtRule(this.getAtRule());
                this.addProperty(collectv);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
                this.ac.getFrame().addWarning("no-declaration");
            } else {
                this.handleRule(s, collectv);
            }
        }
        catch (InvalidParamException ie) {
            if (!isCss1) {
                this.skipStatement();
                this.removeThisAtRule();
                this.ac.getFrame().addError(new CssError(ie));
            }
        }
        catch (ParseException e) {
            if (!isCss1) {
                this.removeThisAtRule();
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    public final ArrayList<CssProperty> pageContent() throws ParseException {
        ArrayList<CssProperty> v = new ArrayList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                v = this.prefAtRule();
                return v;
            }
        }
        this.jj_la1[53] = this.jj_gen;
        v = this.declarations();
        return v;
    }

    public final ArrayList<CssProperty> prefAtRule() throws ParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: {
                    Token n = this.jj_consume_token(77);
                    break;
                }
                case 79: {
                    Token n = this.jj_consume_token(79);
                    break;
                }
                case 80: {
                    Token n = this.jj_consume_token(80);
                    break;
                }
                case 78: {
                    Token n = this.jj_consume_token(78);
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[55] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(21);
            }
            this.jj_consume_token(26);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[56] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> v = this.declarations();
            this.jj_consume_token(38);
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                        break block19;
                    }
                }
                this.jj_consume_token(21);
            }
            return v;
        }
        catch (ParseException e) {
            this.addError((Exception)e, this.skipStatement());
            throw new Error("Missing return statement in function");
        }
    }

    public final void pseudo_page(AtRulePage page) throws ParseException {
        this.jj_consume_token(52);
        Token n = this.jj_consume_token(35);
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(21);
        }
        try {
            page.setName(":" + this.convertIdent(n.image), this.ac);
        }
        catch (InvalidParamException e) {
            throw new InvalidParamException("pseudo", n.image, this.ac);
        }
    }

    public final CssSelectors keyframe_selector(CssSelectors next) throws ParseException {
        CssSelectors selector = new CssSelectors(this.ac, next);
        selector.setAtRule(this.getAtRule());
        Token op = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    Token n = this.jj_consume_token(35);
                    CssIdent ident = new CssIdent();
                    ident.set(this.convertIdent(n.image), this.ac);
                    AtRuleKeyframes.checkSelectorValue(ident, this.ac);
                    selector.addType(new TypeSelector(ident.toString()));
                    break;
                }
                case 27: 
                case 43: 
                case 64: {
                    block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: 
                        case 43: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 27: {
                                    op = this.jj_consume_token(27);
                                    break block5;
                                }
                                case 43: {
                                    op = this.jj_consume_token(43);
                                    break block5;
                                }
                            }
                            this.jj_la1[59] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[60] = this.jj_gen;
                        }
                    }
                    Token n = this.jj_consume_token(64);
                    CssPercentage p = new CssPercentage();
                    if (op == null) {
                        p.set(n.image, this.ac);
                    } else {
                        p.set(op.image + n.image, this.ac);
                    }
                    AtRuleKeyframes.checkSelectorValue(p, this.ac);
                    selector.addType(new TypeSelector(n.image));
                    break;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[62] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(21);
            }
            return selector;
        }
        catch (InvalidParamException ie) {
            this.ac.getFrame().addError(new CssError(ie));
            Token t = this.getToken(1);
            StringBuilder s = new StringBuilder();
            s.append(this.getToken((int)0).image);
            while (t.kind != 29 && t.kind != 26 && t.kind != 0) {
                s.append(t.image);
                this.getNextToken();
                t = this.getToken(1);
            }
            return null;
        }
        catch (ParseException e) {
            Token t = this.getToken(1);
            int _line = t.beginLine;
            int _col = t.beginColumn;
            StringBuilder s = new StringBuilder();
            s.append(" [");
            s.append(this.getToken((int)0).image);
            while (t.kind != 29 && t.kind != 26 && t.kind != 0) {
                s.append(t.image);
                this.getNextToken();
                t = this.getToken(1);
            }
            s.append(']');
            this.addParseError(e, s.toString());
            this.validSelector = true;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void keyframes() throws ParseException {
        AtRule old = this.getAtRule();
        AtRuleKeyframes krule = new AtRuleKeyframes("-internal-");
        this.setAtRule(krule);
        CssVersion version = this.ac.getCssVersion();
        try {
            this.jj_consume_token(74);
            block32: while (true) {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        continue block32;
                    }
                }
                break;
            }
            this.jj_la1[63] = this.jj_gen;
            Token n = this.jj_consume_token(35);
            block33: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                        break block33;
                    }
                }
                this.jj_consume_token(21);
            }
            krule.setName(this.convertIdent(n.image));
            if (version.compareTo(CssVersion.CSS3) < 0) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            } else {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(26);
            block34: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[65] = this.jj_gen;
                        break block34;
                    }
                }
                this.jj_consume_token(21);
            }
            block35: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: 
                    case 35: 
                    case 43: 
                    case 64: {
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                        break block35;
                    }
                }
                CssSelectors s = this.keyframe_selector(null);
                ArrayList<CssSelectors> sl = new ArrayList<CssSelectors>();
                if (s != null) {
                    s.setAtRule(this.getAtRule());
                    sl.add(s);
                }
                block36: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[67] = this.jj_gen;
                            break block36;
                        }
                    }
                    this.jj_consume_token(29);
                    block37: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[68] = this.jj_gen;
                                break block37;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    s = this.keyframe_selector(null);
                    if (s == null) continue;
                    s.setAtRule(this.getAtRule());
                    sl.add(s);
                }
                this.jj_consume_token(26);
                block38: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[69] = this.jj_gen;
                            break block38;
                        }
                    }
                    this.jj_consume_token(21);
                }
                ArrayList<CssProperty> v = this.declarations();
                this.jj_consume_token(38);
                block39: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[70] = this.jj_gen;
                            break block39;
                        }
                    }
                    this.jj_consume_token(21);
                }
                boolean bl = this.validSelector = sl.size() != 0;
                if (!this.validSelector) continue;
                if (v == null) {
                    this.ac.getFrame().addWarning("no-declaration");
                } else {
                    boolean first = true;
                    for (CssSelectors _s : sl) {
                        if (first) {
                            this.handleRule(_s, v);
                            first = false;
                            continue;
                        }
                        ArrayList<CssProperty> vcopy = new ArrayList<CssProperty>(v.size());
                        for (CssProperty p : v) {
                            vcopy.add(p.duplicate());
                        }
                        this.handleRule(_s, vcopy);
                    }
                }
                this.setSelectorList(sl);
                this.endOfRule();
            }
            this.jj_consume_token(38);
            block42: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[71] = this.jj_gen;
                        break block42;
                    }
                }
                this.jj_consume_token(21);
            }
            this.endOfAtRule();
        }
        catch (ParseException e) {
            this.addError((Exception)e, this.skipStatement());
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fontFace() throws ParseException {
        AtRule old = this.getAtRule();
        this.setAtRule(new AtRuleFontFace());
        CssSelectors s = new CssSelectors(this.ac);
        s.setAtRule(this.getAtRule());
        boolean isCss1 = this.ac.getCssVersion() == CssVersion.CSS1;
        try {
            this.jj_consume_token(73);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[72] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(21);
            }
            if (isCss1) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            } else {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(26);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[73] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> v = this.declarations();
            this.jj_consume_token(38);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[74] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!isCss1) {
                this.addProperty(v);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
                this.ac.getFrame().addWarning("no-declaration");
            } else {
                this.handleRule(s, v);
            }
        }
        catch (ParseException e) {
            if (!isCss1) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void colorprofile() throws ParseException {
        AtRule old = this.getAtRule();
        this.setAtRule(new AtRuleColorProfile());
        CssSelectors s = new CssSelectors(this.ac);
        s.setAtRule(this.getAtRule());
        CssProfile profile = this.ac.getCssProfile();
        boolean isSVG = profile == CssProfile.SVG || profile == CssProfile.SVGBASIC || profile == CssProfile.SVGTINY;
        try {
            this.jj_consume_token(76);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[75] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!isSVG) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("onlysvg", "", this.ac), this.getAtRule().toString());
            } else {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(26);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[76] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> v = this.declarations();
            this.jj_consume_token(38);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[77] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            if (isSVG) {
                this.addProperty(v);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
            } else {
                this.handleRule(s, v);
            }
        }
        catch (ParseException e) {
            if (isSVG) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preference() throws ParseException {
        AtRule old = this.getAtRule();
        this.setAtRule(new AtRulePreference());
        CssSelectors s = new CssSelectors(this.ac);
        s.setAtRule(this.getAtRule());
        boolean isCSS1 = this.ac.getCssVersion() == CssVersion.CSS1;
        try {
            this.jj_consume_token(75);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[78] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(21);
            }
            if (isCSS1) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            } else {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(26);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[79] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(21);
            }
            ArrayList<CssProperty> v = this.declarations();
            this.jj_consume_token(38);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[80] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!isCSS1) {
                this.addProperty(v);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
                this.ac.getFrame().addWarning("medialist");
            } else {
                this.handleRule(s, v);
            }
        }
        catch (ParseException e) {
            if (!isCSS1) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void phoneticAlphabet() throws ParseException {
        AtRule old = this.getAtRule();
        AtRulePhoneticAlphabet alphabetrule = new AtRulePhoneticAlphabet();
        this.setAtRule(alphabetrule);
        CssVersion version = this.ac.getCssVersion();
        try {
            this.jj_consume_token(82);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[81] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(21);
            }
            Token n = this.jj_consume_token(33);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[82] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(21);
            }
            this.jj_consume_token(44);
            if (version.compareTo(CssVersion.CSS3) < 0) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            }
            alphabetrule.addAlphabet(this.convertIdent(n.image), this.ac);
            if (version != CssVersion.CSS1 && version != CssVersion.CSS2) {
                this.newAtRule(this.getAtRule());
            }
        }
        catch (ParseException e) {
            if (version != CssVersion.CSS1) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    public final void atRuleDeclaration() throws ParseException {
        Token n = this.jj_consume_token(83);
        this.ac.getFrame().addError(new CssError(new InvalidParamException("at-rule", this.token, this.ac)));
        this.skipStatement();
    }

    public final void operator(CssExpression expr) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                if (expr.getCount() > 0) {
                    expr.setOperator(',');
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[83] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
            }
        }
    }

    public final char combinator() throws ParseException {
        char connector = ' ';
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: 
            case 28: 
            case 30: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        connector = '+';
                        break;
                    }
                    case 28: {
                        this.jj_consume_token(28);
                        connector = '>';
                        break;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        connector = '~';
                        break;
                    }
                    default: {
                        this.jj_la1[85] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[86] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            case 21: {
                block16: while (true) {
                    this.jj_consume_token(21);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            continue block16;
                        }
                    }
                    break;
                }
                this.jj_la1[87] = this.jj_gen;
                connector = ' ';
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return connector;
    }

    public final char unaryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                return '-';
            }
            case 27: {
                this.jj_consume_token(27);
                return '+';
            }
        }
        this.jj_la1[89] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String property() throws ParseException {
        Token n = this.jj_consume_token(35);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        this.currentProperty = this.convertIdent(n.image);
        return this.currentProperty;
    }

    public final void ruleSet() throws ParseException {
        ArrayList<CssSelectors> context_set = new ArrayList<CssSelectors>();
        ArrayList<CssProperty> value_set = null;
        this.currentContext = context_set;
        try {
            CssSelectors contextual = this.selector();
            if (contextual != null) {
                context_set.add(contextual);
            }
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        break;
                    }
                    default: {
                        this.jj_la1[91] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(29);
                block16: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[92] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.jj_consume_token(21);
                }
                contextual = this.selector();
                if (contextual == null) continue;
                context_set.add(contextual);
            }
            this.jj_consume_token(26);
            this.validSelector = context_set.size() > 0;
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[93] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(21);
            }
            value_set = this.declarations();
            this.jj_consume_token(38);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[94] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(21);
            }
            this.markRule = true;
            if (value_set != null) {
                boolean first = true;
                for (CssSelectors sel : context_set) {
                    if (first) {
                        this.handleRule(sel, value_set);
                        first = false;
                        continue;
                    }
                    int vsize = value_set.size();
                    ArrayList<CssProperty> v = new ArrayList<CssProperty>(vsize);
                    for (CssProperty p : value_set) {
                        v.add(p.duplicate());
                    }
                    this.handleRule(sel, v);
                }
                this.setSelectorList(context_set);
                this.endOfRule();
            }
            this.currentContext = null;
        }
        catch (ParseException e) {
            if (this.ac.getCssProfile() != CssProfile.MOBILE && !context_set.isEmpty()) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        catch (TokenMgrError e) {
            this.addError((Exception)new ParseException(e.getMessage()), this.skipStatement());
        }
    }

    public final ArrayList<CssProperty> declarations() throws ParseException {
        CssProperty values;
        if (!this.validSelector) {
            this.validSelector = true;
            this.skip_to_matching_brace();
            return null;
        }
        ArrayList<CssProperty> value_set = new ArrayList<CssProperty>();
        boolean wrong_value = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                values = this.declaration();
                if (values != null) {
                    value_set.add(values);
                    wrong_value = false;
                }
                this.currentProperty = null;
                break;
            }
            default: {
                this.jj_la1[95] = this.jj_gen;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 44: {
                    break;
                }
                default: {
                    this.jj_la1[96] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(44);
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[97] = this.jj_gen;
                        break block13;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    values = this.declaration();
                    if (values != null) {
                        value_set.add(values);
                        wrong_value = false;
                    }
                    this.currentProperty = null;
                    continue block12;
                }
            }
            this.jj_la1[98] = this.jj_gen;
        }
        if (!wrong_value) {
            this.addProperty(value_set);
            return value_set;
        }
        return null;
    }

    public final CssSelectors selector() throws ParseException {
        try {
            CssSelectors current = this.simple_selector(null);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: 
                    case 27: 
                    case 28: 
                    case 30: {
                        break;
                    }
                    default: {
                        this.jj_la1[99] = this.jj_gen;
                        break block11;
                    }
                }
                char comb = this.combinator();
                if (this.ac.getCssProfile() == CssProfile.MOBILE || this.getAtRule().toString().equals("@media atsc-tv") || this.ac.getCssVersion() == CssVersion.CSS1) {
                    if (comb == '+') {
                        throw new InvalidParamException("nocomb", "+", this.ac);
                    }
                    if (comb == '>') {
                        throw new InvalidParamException("nocomb", ">", this.ac);
                    }
                } else if (this.ac.getCssProfile() == CssProfile.TV && comb == '+') {
                    throw new InvalidParamException("nocomb", "+", this.ac);
                }
                if (this.ac.getCssVersion().compareTo(CssVersion.CSS3) < 0 && comb == '~') {
                    throw new InvalidParamException("nocomb", "~", this.ac);
                }
                switch (comb) {
                    case '+': {
                        current.addAdjacentSibling(new AdjacentSiblingSelector());
                        break;
                    }
                    case '>': {
                        current.addChild(new ChildSelector());
                        break;
                    }
                    case '~': {
                        current.addGeneralSibling(new GeneralSiblingSelector());
                        break;
                    }
                    default: {
                        current.addDescendant(new DescendantSelector());
                    }
                }
                current = this.simple_selector(current);
            }
            return current;
        }
        catch (InvalidParamException ie) {
            this.ac.getFrame().addError(new CssError(ie));
            Token t = this.getToken(1);
            StringBuilder s = new StringBuilder();
            s.append(this.getToken((int)0).image);
            while (t.kind != 29 && t.kind != 26 && t.kind != 0) {
                s.append(t.image);
                this.getNextToken();
                t = this.getToken(1);
            }
            return null;
        }
        catch (ParseException e) {
            Token t = this.getToken(1);
            StringBuilder s = new StringBuilder("[");
            s.append(this.getToken((int)0).image);
            while (t.kind != 29 && t.kind != 26 && t.kind != 0) {
                s.append(t.image);
                this.getNextToken();
                t = this.getToken(1);
            }
            s.append(']');
            this.addError((Exception)e, s.toString());
            this.validSelector = true;
            return null;
        }
    }

    public final CssSelectors externalSelector() throws ParseException {
        CssSelectors current = this.simple_selector(null);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                    break block6;
                }
            }
            block7: while (true) {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[101] = this.jj_gen;
            current = this.simple_selector(current);
        }
        return current;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final CssSelectors simple_selector(CssSelectors next) throws ParseException {
        CssSelectors selector = new CssSelectors(this.ac, next);
        selector.setAtRule(this.getAtRule());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 48: 
            case 100: {
                this.element_name(selector);
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 36: 
                        case 37: 
                        case 46: 
                        case 52: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 67: 
                        case 94: 
                        case 96: {
                            break;
                        }
                        default: {
                            this.jj_la1[102] = this.jj_gen;
                            return selector;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 36: 
                        case 37: {
                            this.hash(selector);
                            continue block24;
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 94: {
                            this._class(selector);
                            continue block24;
                        }
                        case 46: {
                            this.attrib(selector);
                            continue block24;
                        }
                        case 52: 
                        case 67: {
                            this.pseudo(selector);
                            continue block24;
                        }
                        case 96: {
                            this.negation(selector);
                            continue block24;
                        }
                    }
                    break;
                }
                this.jj_la1[103] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 36: 
            case 37: 
            case 46: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 94: 
            case 96: {
                block25: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 36: 
                        case 37: {
                            this.hash(selector);
                            break;
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 94: {
                            this._class(selector);
                            break;
                        }
                        case 46: {
                            this.attrib(selector);
                            break;
                        }
                        case 52: 
                        case 67: {
                            this.pseudo(selector);
                            break;
                        }
                        case 96: {
                            this.negation(selector);
                            break;
                        }
                        default: {
                            this.jj_la1[104] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 36: 
                        case 37: 
                        case 46: 
                        case 52: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 67: 
                        case 94: 
                        case 96: {
                            continue block25;
                        }
                    }
                    break;
                }
                this.jj_la1[105] = this.jj_gen;
                return selector;
            }
        }
        this.jj_la1[106] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void _class(CssSelectors s) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 94: {
                Token n = this.jj_consume_token(94);
                try {
                    s.addClass(new ClassSelector(this.convertClassIdent(n.image.substring(1))));
                    break;
                }
                catch (InvalidParamException e) {
                    this.ac.getFrame().addError(new CssError(e));
                    throw new ParseException(e.getMessage());
                }
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                Token n = this.deprecated_class();
                if (n.image.charAt(0) == '.') {
                    n.image = n.image.substring(1);
                    String cl = "." + this.hexEscapeFirst(n.image);
                    CssVersion version = this.ac.getCssVersion();
                    if (version != CssVersion.CSS1) {
                        StringBuilder sb = new StringBuilder();
                        ArrayList<String> param_err = new ArrayList<String>(2);
                        param_err.add(n.image);
                        param_err.add(cl);
                        sb.append(this.ac.getMsg().getString("parser.old_class", param_err));
                        throw new ParseException(sb.toString());
                    }
                    CssLength length = new CssLength();
                    boolean isLength = false;
                    try {
                        length.set(n.image, this.ac);
                        isLength = true;
                    }
                    catch (Exception e) {
                        isLength = false;
                    }
                    if (isLength) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.ac.getMsg().getString("parser.class_dim"));
                        sb.append(n.image);
                        throw new ParseException(sb.toString());
                    }
                    try {
                        s.addClass(new ClassSelector(n.image));
                        this.ac.getFrame().addWarning("old_class");
                        break;
                    }
                    catch (InvalidParamException e) {
                        throw new ParseException(e.getMessage());
                    }
                }
                throw new ParseException("Unrecognized ");
            }
            default: {
                this.jj_la1[107] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token deprecated_class() throws ParseException {
        Token n;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                n = this.jj_consume_token(54);
                break;
            }
            case 55: {
                n = this.jj_consume_token(55);
                break;
            }
            case 56: {
                n = this.jj_consume_token(56);
                break;
            }
            case 57: {
                n = this.jj_consume_token(57);
                break;
            }
            case 60: {
                n = this.jj_consume_token(60);
                break;
            }
            case 61: {
                n = this.jj_consume_token(61);
                break;
            }
            case 62: {
                n = this.jj_consume_token(62);
                break;
            }
            case 63: {
                n = this.jj_consume_token(63);
                break;
            }
            default: {
                this.jj_la1[108] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final void element_name(CssSelectors s) throws ParseException {
        Token n = null;
        Token p = null;
        String prefix = null;
        if (this.jj_2_1(2)) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: 
                case 48: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            n = this.jj_consume_token(35);
                            break block0;
                        }
                        case 48: {
                            n = this.jj_consume_token(48);
                            break block0;
                        }
                    }
                    this.jj_la1[109] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[110] = this.jj_gen;
                }
            }
            p = this.jj_consume_token(100);
        }
        if (p != null) {
            if (this.ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                StringBuilder sb = new StringBuilder("namespace \"");
                if (n != null) {
                    sb.append(n.toString());
                }
                sb.append("\"");
                this.ac.getFrame().addError(new CssError(new InvalidParamException("notversion", "namespace", this.ac.getCssVersionString(), this.ac)));
                this.removeThisRule();
            } else if (n != null) {
                prefix = this.convertIdent(n.image);
                if (!this.ac.isNamespaceDefined(this.getURL(), prefix)) {
                    this.addError((Exception)new ParseException("Undefined namespace"), ": The namespace \"" + prefix + "\" is not defined. " + prefix);
                    this.removeThisRule();
                }
            } else {
                prefix = "";
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                n = this.jj_consume_token(35);
                s.addType(new TypeSelector(prefix, this.convertIdent(n.image)));
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                if (this.ac.getCssVersion() != CssVersion.CSS1) {
                    s.addUniversal(new UniversalSelector(prefix));
                    break;
                }
                this.ac.getFrame().addError(new CssError(new InvalidParamException("notversion", "*", this.ac.getCssVersionString(), this.ac)));
                break;
            }
            default: {
                this.jj_la1[111] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void attrib(CssSelectors s) throws ParseException {
        Token att = null;
        Token val = null;
        int selectorType = -1;
        this.jj_consume_token(46);
        block39: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[112] = this.jj_gen;
                    break block39;
                }
            }
            this.jj_consume_token(21);
        }
        att = this.jj_consume_token(35);
        block40: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[113] = this.jj_gen;
                    break block40;
                }
            }
            this.jj_consume_token(21);
        }
        block8 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 25: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 42: {
                        this.jj_consume_token(42);
                        selectorType = 32;
                        break;
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        selectorType = 126;
                        break;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        selectorType = 124;
                        break;
                    }
                    case 39: {
                        this.jj_consume_token(39);
                        selectorType = 94;
                        break;
                    }
                    case 40: {
                        this.jj_consume_token(40);
                        selectorType = 36;
                        break;
                    }
                    case 41: {
                        this.jj_consume_token(41);
                        selectorType = 42;
                        break;
                    }
                    default: {
                        this.jj_la1[114] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block41: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[115] = this.jj_gen;
                            break block41;
                        }
                    }
                    this.jj_consume_token(21);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        val = this.jj_consume_token(35);
                        val.image = this.convertIdent(val.image);
                        break;
                    }
                    case 33: {
                        val = this.jj_consume_token(33);
                        val.image = this.convertStringIndex(val.image, 1, val.image.length() - 1, false);
                        break;
                    }
                    default: {
                        this.jj_la1[116] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[117] = this.jj_gen;
                            break block8;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[118] = this.jj_gen;
            }
        }
        this.jj_consume_token(47);
        if (this.ac.getCssVersion() == CssVersion.CSS1) {
            StringBuilder reason = new StringBuilder(" [");
            if (att != null) {
                reason.append(this.convertIdent(att.image));
            }
            if (val != null) {
                reason.append('=').append(val.image);
            }
            reason.append(']');
            ParseException p = new ParseException(this.ac.getMsg().getString("parser.attrcss1") + reason.toString());
            CssParseException cp = new CssParseException(p);
            this.ac.getFrame().addError(new CssError(cp));
            this.removeThisRule();
        }
        if (selectorType == -1) {
            try {
                s.addAttribute(new AttributeAny(att.image.toLowerCase()));
            }
            catch (InvalidParamException e) {
                this.removeThisRule();
                this.ac.getFrame().addError(new CssError(e));
            }
        } else {
            AttributeSelector attribute;
            switch (selectorType) {
                case 124: {
                    attribute = new AttributeBegin(att.image.toLowerCase(), val.image);
                    break;
                }
                case 32: {
                    attribute = new AttributeExact(att.image.toLowerCase(), val.image);
                    break;
                }
                case 126: {
                    attribute = new AttributeOneOf(att.image.toLowerCase(), val.image);
                    break;
                }
                case 94: {
                    attribute = new AttributeStart(att.image.toLowerCase(), val.image);
                    break;
                }
                case 42: {
                    attribute = new AttributeSubstr(att.image.toLowerCase(), val.image);
                    break;
                }
                case 36: {
                    attribute = new AttributeSuffix(att.image.toLowerCase(), val.image);
                    break;
                }
                default: {
                    attribute = new AttributeExact(att.image.toLowerCase(), val.image);
                }
            }
            try {
                s.addAttribute(attribute);
            }
            catch (InvalidParamException e) {
                this.removeThisRule();
                this.ac.getFrame().addError(new CssError(e));
            }
        }
    }

    public final void negation(CssSelectors s) throws ParseException {
        CssSelectors ns = new CssSelectors(this.ac, null);
        this.jj_consume_token(96);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[119] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(21);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 48: 
            case 100: {
                this.element_name(ns);
                break;
            }
            case 36: 
            case 37: {
                this.hash(ns);
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 94: {
                this._class(ns);
                break;
            }
            case 46: {
                this.attrib(ns);
                break;
            }
            case 52: 
            case 67: {
                this.pseudo(ns);
                break;
            }
            default: {
                this.jj_la1[120] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(21);
        }
        this.jj_consume_token(50);
        s.setPseudoFun("not", ns.toString());
    }

    public final void pseudo(CssSelectors s) throws ParseException {
        Token language = null;
        CssExpression param = null;
        block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                Token n = this.jj_consume_token(35);
                try {
                    if (this.ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                        throw new InvalidParamException("pseudo-element", "::" + this.convertIdent(n.image).toLowerCase(), this.ac.getCssVersionString(), this.ac);
                    }
                    s.addPseudoElement(this.convertIdent(n.image).toLowerCase());
                    break;
                }
                catch (InvalidParamException e) {
                    this.validSelector = false;
                    throw new ParseException(e.getMessage());
                }
            }
            case 52: {
                this.jj_consume_token(52);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        Token n = this.jj_consume_token(35);
                        try {
                            s.addPseudoClass(this.convertIdent(n.image).toLowerCase());
                        }
                        catch (InvalidParamException e) {
                            this.removeThisRule();
                            this.ac.getFrame().addError(new CssError(e));
                        }
                        break block4;
                    }
                    case 95: 
                    case 97: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 95: {
                                Token n = this.jj_consume_token(95);
                                block34: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 21: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[122] = this.jj_gen;
                                            break block34;
                                        }
                                    }
                                    this.jj_consume_token(21);
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 65: {
                                        language = this.jj_consume_token(65);
                                        break;
                                    }
                                    case 35: {
                                        language = this.jj_consume_token(35);
                                        break;
                                    }
                                    case 33: {
                                        language = this.jj_consume_token(33);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[123] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                block35: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 21: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[124] = this.jj_gen;
                                            break block35;
                                        }
                                    }
                                    this.jj_consume_token(21);
                                }
                                try {
                                    s.setPseudoFun(this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), this.convertIdent(language.image));
                                }
                                catch (InvalidParamException e) {
                                    this.removeThisRule();
                                    this.ac.getFrame().addError(new CssError(e));
                                }
                                break;
                            }
                            case 97: {
                                Token n = this.jj_consume_token(97);
                                block36: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 21: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[125] = this.jj_gen;
                                            break block36;
                                        }
                                    }
                                    this.jj_consume_token(21);
                                }
                                param = this.expression();
                                try {
                                    s.setPseudoFun(this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), param.toString());
                                }
                                catch (InvalidParamException e) {
                                    this.removeThisRule();
                                    this.ac.getFrame().addError(new CssError(e));
                                }
                                break;
                            }
                            default: {
                                this.jj_la1[126] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(50);
                        break block4;
                    }
                }
                this.jj_la1[127] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[128] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void hash(CssSelectors s) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                Token n = this.jj_consume_token(36);
                n.image = n.image.substring(1);
                if (Character.isDigit(n.image.charAt(0))) {
                    CssVersion version = this.ac.getCssVersion();
                    if (version != CssVersion.CSS1) {
                        String cl = "\\" + Integer.toString(n.image.charAt(0), 16);
                        cl = cl + n.image.substring(1);
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.old_id")), "To make \"." + n.image + "\" a valid id, CSS2" + " requires the first digit to be escaped " + "(\"#" + cl + "\")");
                        s.addId(new IdSelector(n.image));
                        this.removeThisRule();
                        break;
                    }
                    CssLength length = new CssLength();
                    boolean isLength = false;
                    try {
                        length.set(n.image, this.ac);
                        isLength = true;
                    }
                    catch (Exception e) {
                        isLength = false;
                    }
                    if (isLength) {
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.id_dim")), n.image);
                        s.addId(new IdSelector(n.image));
                        this.removeThisRule();
                        break;
                    }
                    try {
                        s.addId(new IdSelector(n.image));
                        this.ac.getFrame().addWarning("old_id");
                    }
                    catch (InvalidParamException e) {
                        this.ac.getFrame().addError(new CssError(e));
                        this.removeThisRule();
                    }
                    break;
                }
                try {
                    s.addId(new IdSelector(n.image));
                }
                catch (InvalidParamException e) {
                    this.ac.getFrame().addError(new CssError(e));
                    this.removeThisRule();
                }
                break;
            }
            case 37: {
                Token n = this.jj_consume_token(37);
                throw new ParseException(this.ac.getMsg().getString("parser.invalid_id_selector"));
            }
            default: {
                this.jj_la1[129] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CssProperty mediadeclaration() throws ParseException {
        CssExpression values = null;
        boolean important = false;
        this.setMediaDeclaration(true);
        try {
            String string_property = this.property();
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 52: {
                    this.jj_consume_token(52);
                    block19: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[130] = this.jj_gen;
                                break block19;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    values = this.expr();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 66: {
                            important = this.prio();
                            break block5;
                        }
                    }
                    this.jj_la1[131] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[132] = this.jj_gen;
                }
            }
            try {
                CssProperty p;
                this.setImportant(important);
                if (this.incompatible_error) {
                    throw new InvalidParamException("notforcss1", "inherit", this.ac);
                }
                CssProperty cssProperty = p = this.handleDeclaration(string_property.toLowerCase(), values, important);
                return cssProperty;
            }
            catch (InvalidParamException e2) {
                try {
                    this.incompatible_error = false;
                    if (null != values) {
                        values.starts();
                    }
                    this.addError((Exception)e2, values);
                    CssProperty e2 = null;
                }
                catch (NumberFormatException e3) {
                    this.skipAfterExpression(e3);
                    CssProperty cssProperty = null;
                    return cssProperty;
                }
                catch (ParseException e4) {
                    this.skipAfterExpression(e4);
                    CssProperty cssProperty = null;
                    return cssProperty;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                this.setMediaDeclaration(false);
                return e2;
            }
        }
        finally {
            this.setMediaDeclaration(false);
        }
    }

    public final CssProperty declaration() throws ParseException {
        boolean important = false;
        try {
            block16: {
                String string_property = this.property();
                this.jj_consume_token(52);
                block12: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[133] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.jj_consume_token(21);
                }
                CssExpression values = this.expr();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 66: {
                        important = this.prio();
                        break;
                    }
                    default: {
                        this.jj_la1[134] = this.jj_gen;
                    }
                }
                try {
                    this.setImportant(important);
                    if (this.incompatible_error) {
                        throw new InvalidParamException("notforcss1", "inherit", this.ac);
                    }
                    if (values.getCount() == 0) break block16;
                    CssProperty p = this.handleDeclaration(string_property.toLowerCase(), values, important);
                    if (!values.end() && this.ac.getMedium() == null) {
                        this.addError((Exception)new InvalidParamException("unrecognize", "", this.ac), values);
                        break block16;
                    }
                    return p;
                }
                catch (InvalidParamException e) {
                    this.incompatible_error = false;
                    if (e instanceof WarningParamException) {
                        WarningParamException warningException = (WarningParamException)e;
                        this.ac.getFrame().addWarning(warningException.getMessage(), warningException.getMessageArgs());
                    }
                    values.starts();
                    this.addError((Exception)e, values);
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            this.skipAfterExpression(e);
            return null;
        }
        catch (ParseException e) {
            this.skipAfterExpression(e);
            return null;
        }
        catch (NullPointerException e) {
            this.skipAfterExpression(e);
            return null;
        }
    }

    public final boolean prio() throws ParseException {
        this.jj_consume_token(66);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[135] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        return true;
    }

    public final CssExpression expression() throws ParseException {
        CssExpression exp = new CssExpression();
        char operator = ' ';
        Token n = null;
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: {
                    this.jj_consume_token(27);
                    operator = '+';
                    break;
                }
                case 43: {
                    this.jj_consume_token(43);
                    operator = '-';
                    break;
                }
                case 65: {
                    n = this.jj_consume_token(65);
                    this.setValue(new CssNumber(), exp, operator, n, 65);
                    break;
                }
                case 64: {
                    n = this.jj_consume_token(64);
                    this.setValue(new CssPercentage(), exp, operator, n, 64);
                    break;
                }
                case 63: {
                    n = this.jj_consume_token(63);
                    this.setValue(new CssIdent(), exp, operator, n, 35);
                    break;
                }
                case 33: {
                    n = this.jj_consume_token(33);
                    this.setValue(new CssString(), exp, operator, n, 33);
                    break;
                }
                case 35: {
                    n = this.jj_consume_token(35);
                    this.setValue(new CssIdent(), exp, operator, n, 35);
                    break;
                }
                default: {
                    this.jj_la1[136] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[137] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: 
                case 33: 
                case 35: 
                case 43: 
                case 63: 
                case 64: 
                case 65: {
                    continue block15;
                }
            }
            break;
        }
        this.jj_la1[138] = this.jj_gen;
        return exp;
    }

    public final CssExpression expr() throws ParseException {
        CssExpression values = new CssExpression();
        this.term(values);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: 
                case 29: 
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 43: 
                case 45: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 93: 
                case 97: {
                    break;
                }
                default: {
                    this.jj_la1[139] = this.jj_gen;
                    break block3;
                }
            }
            this.operator(values);
            this.term(values);
        }
        return values;
    }

    public final CssExpression mediaexpr() throws ParseException {
        CssExpression values = new CssExpression();
        this.mediaterm(values);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: 
                case 29: 
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 43: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 93: 
                case 97: {
                    break;
                }
                default: {
                    this.jj_la1[140] = this.jj_gen;
                    break block3;
                }
            }
            this.operator(values);
            this.mediaterm(values);
        }
        return values;
    }

    public final void term(CssExpression exp) throws ParseException {
        char operator = ' ';
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: 
            case 43: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 97: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: 
                    case 43: {
                        operator = this.unaryOperator();
                        break;
                    }
                    default: {
                        this.jj_la1[141] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 65: {
                        Token n = this.jj_consume_token(65);
                        this.setValue(new CssNumber(), exp, operator, n, 65);
                        break;
                    }
                    case 64: {
                        Token n = this.jj_consume_token(64);
                        this.setValue(new CssPercentage(), exp, operator, n, 64);
                        break;
                    }
                    case 54: {
                        Token n = this.jj_consume_token(54);
                        this.setValue(new CssLength(), exp, operator, n, 54);
                        break;
                    }
                    case 55: {
                        Token n = this.jj_consume_token(55);
                        this.setValue(new CssLength(), exp, operator, n, 55);
                        break;
                    }
                    case 56: {
                        Token n = this.jj_consume_token(56);
                        this.setValue(new CssLength(), exp, operator, n, 56);
                        break;
                    }
                    case 57: {
                        Token n = this.jj_consume_token(57);
                        this.setValue(new CssAngle(), exp, operator, n, 57);
                        break;
                    }
                    case 60: {
                        Token n = this.jj_consume_token(60);
                        this.setValue(new CssTime(), exp, operator, n, 60);
                        break;
                    }
                    case 61: {
                        Token n = this.jj_consume_token(61);
                        this.setValue(new CssFrequency(), exp, operator, n, 61);
                        break;
                    }
                    case 62: {
                        Token n = this.jj_consume_token(62);
                        this.setValue(new CssResolution(), exp, operator, n, 62);
                        break;
                    }
                    case 59: {
                        Token n = this.jj_consume_token(59);
                        this.setValue(new CssSemitone(), exp, operator, n, 59);
                        break;
                    }
                    case 58: {
                        Token n = this.jj_consume_token(58);
                        this.setValue(new CssVolume(), exp, operator, n, 58);
                        break;
                    }
                    case 63: {
                        Token n = this.jj_consume_token(63);
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.unknown-dimension")), n.image);
                        break;
                    }
                    case 97: {
                        CssValue func = this.function();
                        this.setValue(func, exp, operator, null, 97);
                        break;
                    }
                    default: {
                        this.jj_la1[142] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[143] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 45: 
            case 53: 
            case 93: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: {
                        Token n = this.jj_consume_token(33);
                        this.setValue(new CssString(), exp, operator, n, 33);
                        break;
                    }
                    case 45: {
                        Token n = this.jj_consume_token(45);
                        this.setValue(new CssSwitch(), exp, operator, n, 45);
                        break;
                    }
                    case 35: {
                        Token n = this.jj_consume_token(35);
                        Token t = this.getToken(1);
                        Token semicolon = new Token();
                        semicolon.kind = 44;
                        semicolon.image = ";";
                        if (t.kind == 52) {
                            this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.semi-colon")), (CssExpression)null);
                            this.rejectToken(semicolon);
                            break;
                        }
                        this.setValue(new CssIdent(), exp, operator, n, 35);
                        break;
                    }
                    case 36: 
                    case 37: {
                        this.hashident(exp);
                        break;
                    }
                    case 53: {
                        Token n = this.jj_consume_token(53);
                        CssURL _u = new CssURL();
                        _u.set(n.image, this.ac, this.url);
                        exp.addValue(_u);
                        break;
                    }
                    case 93: {
                        Token n = this.jj_consume_token(93);
                        this.setValue(new CssUnicodeRange(), exp, operator, n, 93);
                        break;
                    }
                    default: {
                        this.jj_la1[144] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[145] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[146] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void mediaterm(CssExpression exp) throws ParseException {
        char operator = ' ';
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: 
            case 43: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 97: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: 
                    case 43: {
                        operator = this.unaryOperator();
                        break;
                    }
                    default: {
                        this.jj_la1[147] = this.jj_gen;
                    }
                }
                block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 65: {
                        Token n;
                        if (this.jj_2_2(Integer.MAX_VALUE)) {
                            this.ratio(exp, operator);
                            break;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 65: {
                                n = this.jj_consume_token(65);
                                this.setValue(new CssNumber(), exp, operator, n, 65);
                                break block7;
                            }
                        }
                        this.jj_la1[148] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 64: {
                        Token n = this.jj_consume_token(64);
                        this.setValue(new CssPercentage(), exp, operator, n, 64);
                        break;
                    }
                    case 54: {
                        Token n = this.jj_consume_token(54);
                        this.setValue(new CssLength(), exp, operator, n, 54);
                        break;
                    }
                    case 55: {
                        Token n = this.jj_consume_token(55);
                        this.setValue(new CssLength(), exp, operator, n, 55);
                        break;
                    }
                    case 56: {
                        Token n = this.jj_consume_token(56);
                        this.setValue(new CssLength(), exp, operator, n, 56);
                        break;
                    }
                    case 57: {
                        Token n = this.jj_consume_token(57);
                        this.setValue(new CssAngle(), exp, operator, n, 57);
                        break;
                    }
                    case 60: {
                        Token n = this.jj_consume_token(60);
                        this.setValue(new CssTime(), exp, operator, n, 60);
                        break;
                    }
                    case 61: {
                        Token n = this.jj_consume_token(61);
                        this.setValue(new CssFrequency(), exp, operator, n, 61);
                        break;
                    }
                    case 62: {
                        Token n = this.jj_consume_token(62);
                        this.setValue(new CssResolution(), exp, operator, n, 62);
                        break;
                    }
                    case 63: {
                        Token n = this.jj_consume_token(63);
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.unknown-dimension")), n.image);
                        break;
                    }
                    case 97: {
                        CssValue func = this.function();
                        this.setValue(func, exp, operator, null, 97);
                        break;
                    }
                    default: {
                        this.jj_la1[149] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[150] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 53: 
            case 93: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: {
                        Token n = this.jj_consume_token(33);
                        this.setValue(new CssString(), exp, operator, n, 33);
                        break;
                    }
                    case 35: {
                        Token n = this.jj_consume_token(35);
                        Token t = this.getToken(1);
                        Token semicolon = new Token();
                        semicolon.kind = 44;
                        semicolon.image = ";";
                        if (t.kind == 52) {
                            this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.semi-colon")), (CssExpression)null);
                            this.rejectToken(semicolon);
                            break;
                        }
                        this.setValue(new CssIdent(), exp, operator, n, 35);
                        break;
                    }
                    case 36: 
                    case 37: {
                        this.hashident(exp);
                        break;
                    }
                    case 53: {
                        Token n = this.jj_consume_token(53);
                        CssURL _u = new CssURL();
                        _u.set(n.image, this.ac, this.url);
                        exp.addValue(_u);
                        break;
                    }
                    case 93: {
                        Token n = this.jj_consume_token(93);
                        this.setValue(new CssUnicodeRange(), exp, operator, n, 93);
                        break;
                    }
                    default: {
                        this.jj_la1[151] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[152] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[153] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final CssValue function() throws ParseException {
        CssColor color = new CssColor();
        Token n = this.jj_consume_token(97);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[154] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        CssExpression exp = this.expr();
        this.jj_consume_token(50);
        String funcname = n.image.toLowerCase();
        if (funcname.equals("rgb(")) {
            color.setRGBColor(exp, this.ac);
            return color;
        }
        if (funcname.equals("rgba(")) {
            color.setRGBAColor(exp, this.ac);
            return color;
        }
        if (funcname.equals("hsl(")) {
            color.setHSLColor(exp, this.ac);
            return color;
        }
        if (funcname.equals("hsla(")) {
            color.setHSLAColor(exp, this.ac);
            return color;
        }
        if (funcname.equals("image(")) {
            CssImage img = new CssImage();
            img.setImageList(exp, this.ac);
            return img;
        }
        if (funcname.equals("linear-gradient(")) {
            CssImage img = new CssImage();
            img.setLinearGradient(exp, this.ac);
            return img;
        }
        if (funcname.equals("repeating-linear-gradient(")) {
            CssImage img = new CssImage();
            img.setRepeatingLinearGradient(exp, this.ac);
            return img;
        }
        if (funcname.equals("radial-gradient(")) {
            CssImage img = new CssImage();
            img.setRadialGradient(exp, this.ac);
            return img;
        }
        if (funcname.equals("repeating-radial-gradient(")) {
            CssImage img = new CssImage();
            img.setRepeatingRadialGradient(exp, this.ac);
            return img;
        }
        if (funcname.equals("atsc-rgba(")) {
            if (this.getAtRule().toString().equals("@media atsc-tv")) {
                color.setATSCRGBAColor(exp, this.ac);
                return color;
            }
            this.addError((Exception)new InvalidParamException("onlyATSC", "", this.ac), this.getAtRule().toString());
            return null;
        }
        CssFunction f = new CssFunction();
        f.set(n.image.substring(0, n.image.length() - 1), exp);
        if (funcname.charAt(0) == '-') {
            exp.markVendorExtension();
        }
        return f;
    }

    public final void hashident(CssExpression exp) throws ParseException {
        Token n;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                n = this.jj_consume_token(36);
                break;
            }
            case 37: {
                n = this.jj_consume_token(37);
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        n.image = Util.strip(n.image);
        this.setValue(new CssHashIdent(), exp, ' ', n, 37);
    }

    String skipStatement() throws ParseException {
        StringBuilder s = new StringBuilder();
        Token tok = this.getToken(0);
        boolean first = true;
        if (tok.image != null) {
            s.append(tok.image);
        }
        while (true) {
            try {
                tok = this.getToken(1);
                if (tok.kind == 0) {
                    if (!first) break;
                    return null;
                }
                s.append(tok.image);
                if (tok.kind == 26) {
                    this.getNextToken();
                    s.append(this.skip_to_matching_brace());
                    this.getNextToken();
                    tok = this.getToken(1);
                    break;
                }
                if (tok.kind == 38 || tok.kind == 44) {
                    this.getNextToken();
                    tok = this.getToken(1);
                    break;
                }
                this.getNextToken();
            }
            catch (TokenMgrError tokenerror) {
                try {
                    s.append(this.jj_input_stream.readChar());
                    continue;
                }
                catch (IOException ioex) {
                    return s.toString().trim();
                }
            }
            first = false;
        }
        while (tok.kind == 21) {
            this.getNextToken();
            tok = this.getToken(1);
        }
        String statement = s.toString().trim();
        return statement;
    }

    String skip_to_matching_brace() throws ParseException {
        StringBuilder s = new StringBuilder();
        int nesting = 1;
        while (true) {
            Token tok = this.getToken(1);
            if (tok.kind == 0) break;
            s.append(tok.image);
            if (tok.kind == 26) {
                ++nesting;
            } else if (tok.kind == 38 && --nesting == 0) break;
            this.getNextToken();
        }
        return s.toString();
    }

    void rejectToken(Token t) throws ParseException {
        Token fakeToken = new Token();
        t.next = this.token;
        fakeToken.next = t;
        this.token = fakeToken;
    }

    void skipAfterExpression(Exception e) throws ParseException {
        StringBuilder s = new StringBuilder();
        s.append(this.getToken((int)0).image);
        block4: while (true) {
            try {
                while (true) {
                    Token t = this.getToken(1);
                    if (t.kind == 26) {
                        s.append(t.image);
                        this.getNextToken();
                        s.append(this.skip_to_matching_brace());
                        this.getNextToken();
                        t = this.getToken(1);
                        continue;
                    }
                    if (t.kind == 44 || t.kind == 38 || t.kind == 0) break block4;
                    s.append(t.image);
                    this.getNextToken();
                    t = this.getToken(1);
                }
            }
            catch (TokenMgrError tmerr) {
                try {
                    s.append(this.jj_input_stream.readChar());
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                    break;
                }
            }
        }
        String statement = s.toString().trim();
        this.addError(e, s.toString());
    }

    String convertStringIndex(String s, int start, int len, boolean escapeFirst) throws ParseException {
        int maxCount = 0;
        if (start == 0 && len == s.length() && s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder(len);
        for (int index = start; index < len; ++index) {
            block18: {
                char c;
                block16: {
                    block17: {
                        c = s.charAt(index);
                        if (c != '\\') break block16;
                        if (++index >= len) break block17;
                        c = s.charAt(index);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': 
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                int t;
                                int numValue = Character.digit(c, 16);
                                int count = 1;
                                if (maxCount == 0) {
                                    int n = maxCount = this.ac.getCssVersion() == CssVersion.CSS1 ? 4 : 6;
                                }
                                while (index + 1 < len) {
                                    c = s.charAt(index + 1);
                                    t = Character.digit(c, 16);
                                    if (t != -1 && count++ < maxCount) {
                                        numValue = numValue << 4 | t;
                                        ++index;
                                        continue;
                                    }
                                    if (c == ' ' || c == '\t' || c == '\n' || c == '\f') {
                                        ++index;
                                        break;
                                    }
                                    if (c != '\r' || ++index + 1 >= len || s.charAt(index + 1) != '\n') break;
                                    ++index;
                                    break;
                                }
                                if (!escapeFirst && numValue < 255 && numValue > 31) {
                                    if (!(numValue > 96 && numValue < 123 || numValue > 64 && numValue < 91 || numValue > 47 && numValue < 58 || numValue == 95 || numValue == 45)) {
                                        buf.append('\\');
                                    }
                                    buf.append((char)numValue);
                                    break;
                                }
                                char[] b = new char[maxCount];
                                t = maxCount;
                                while (t > 0) {
                                    b[--t] = hexdigits[numValue & 0xF];
                                    numValue >>>= 4;
                                }
                                buf.append('\\').append(b);
                                break;
                            }
                            case '\n': 
                            case '\f': {
                                break;
                            }
                            case '\r': {
                                if (index + 1 < len && s.charAt(index + 1) == '\n') {
                                    ++index;
                                    break;
                                }
                                break block18;
                            }
                            case '-': 
                            case 'G': 
                            case 'H': 
                            case 'I': 
                            case 'J': 
                            case 'K': 
                            case 'L': 
                            case 'M': 
                            case 'N': 
                            case 'O': 
                            case 'P': 
                            case 'Q': 
                            case 'R': 
                            case 'S': 
                            case 'T': 
                            case 'U': 
                            case 'V': 
                            case 'W': 
                            case 'X': 
                            case 'Y': 
                            case 'Z': 
                            case '_': 
                            case 'g': 
                            case 'h': 
                            case 'i': 
                            case 'j': 
                            case 'k': 
                            case 'l': 
                            case 'm': 
                            case 'n': 
                            case 'o': 
                            case 'p': 
                            case 'q': 
                            case 'r': 
                            case 's': 
                            case 't': 
                            case 'u': 
                            case 'v': 
                            case 'w': 
                            case 'x': 
                            case 'y': 
                            case 'z': {
                                buf.append(c);
                                break;
                            }
                            default: {
                                buf.append('\\').append(c);
                                break;
                            }
                        }
                        break block18;
                    }
                    throw new ParseException("invalid string");
                }
                buf.append(c);
            }
            escapeFirst = false;
        }
        return buf.toString();
    }

    String convertIdent(String s) throws ParseException {
        return this.convertStringIndex(s, 0, s.length(), false);
    }

    String convertClassIdent(String s) throws ParseException {
        return this.convertStringIndex(s, 0, s.length(), true);
    }

    String convertString(String s) throws ParseException {
        return this.convertStringIndex(s, 0, s.length(), false);
    }

    String hexEscapeFirst(String s) throws ParseException {
        StringBuilder sb = new StringBuilder();
        sb.append('\\').append(Integer.toString(s.charAt(0), 16));
        char c = s.charAt(1);
        if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') {
            sb.append(' ');
        }
        sb.append(s.substring(1));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3_2() {
        Token xsp;
        if (this.jj_scan_token(65)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(21));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_103() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(35)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(48)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_103()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(100);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0xE00000, 0xE00000, 0, 0, 0x200000, 0x200000, 0, 0xC00000, 0xC00000, 0x200000, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0x20000000, 0x200000, 0x200000, 0, 0x200000, Integer.MIN_VALUE, 0x200000, Integer.MIN_VALUE, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0x8000000, 0x8000000, 0x8000000, 0x200000, 0x200000, 0x200000, 0x200000, 0x8000000, 0x20000000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x20000000, 0x58000000, 0x200000, 0x200000, 1478492160, 0x8000000, 0x200000, 0x20000000, 0x200000, 0x200000, 0x200000, 0, 0, 0x200000, 0, 1478492160, 0x200000, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0x200000, 0x3000000, 0x200000, 0, 0x200000, 0x3000000, 0x200000, 0, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0, 0, 0, 0, 0x200000, 0, 0, 0x200000, 0, 0x200000, 0x8000000, 0x200000, 0x8000000, 0x28000000, 0x28000000, 0x8000000, 0, 0x200000, 0, 0x200000, 0x8000000, 0x8000000, 0, 0, 0x200000, 0, 0x200000, 0x8000000, 0x200000, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, -204390344, 0, 0, 0, 0, 0, 8, 0x200002, 0, 0, 0, 0x200002, 0, 524297, 0, 0, 0, -204390344, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 524297, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 8, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 2048, 2056, 0, 0, 0, 0, 2056, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 0, 0, 0, 8, 4096, 0, 8, 0, 0, 0, -204455888, -204455888, -204455888, -204455888, -204390344, -205520896, -205520896, 65544, 65544, 65544, 0, 0, 1920, 0, 10, 0, 1920, 0, -204390344, 0, 0, 10, 0, 0, 0, 8, 0x100000, 48, 0, 0, 0x100000, 0, 0, 0, -2147481590, 0, -2147481590, -2086854, -203421638, 2048, -4194304, 0, 2105402, 0, -2086854, 2048, 0, -205520896, 0, 2097210, 0, -203421638, 0, 48};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 16, 0, 0, 32, 64, 0, 0, 1074012040, 524288, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000008, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122880, 122880, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000008, 0x40000008, 0x40000008, 0x40000008, 0x40000008, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000008, 0, 0, 2, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 8, 0, 0, 4, 0, 0, 4, 0, 3, 0, 3, 0x20000003, 0x20000003, 0, 3, 0, 0x20000000, 0, 0x20000003, 0, 2, 3, 0, 0x20000000, 0, 0x20000003, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{12, 12, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 2, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 2, 0, 0};
    }

    public CssParser(InputStream stream) {
        this(stream, null);
    }

    public CssParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CssParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CssParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CssParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CssParser(CssParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CssParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 156; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[101];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 156; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 101; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        CssParser.jj_la1_init_0();
        CssParser.jj_la1_init_1();
        CssParser.jj_la1_init_2();
        CssParser.jj_la1_init_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

