/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;

public class CssPercentage
extends CssCheckableValue {
    public static final int type = 4;
    private BigDecimal defaultValue;
    private BigDecimal value;

    @Override
    public final int getType() {
        return 4;
    }

    public CssPercentage() {
        this.value = this.defaultValue = BigDecimal.ZERO;
    }

    public CssPercentage(int value) {
        this(new BigDecimal(value));
    }

    public CssPercentage(float value) {
        this(new BigDecimal(value));
    }

    public CssPercentage(BigDecimal value) {
        this.defaultValue = BigDecimal.ZERO;
        this.value = value;
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        int slength = s.length();
        if (s.charAt(slength - 1) != '%') {
            throw new InvalidParamException("percentage", s, ac);
        }
        this.value = new BigDecimal(s.substring(0, slength - 1));
    }

    @Override
    public void setValue(BigDecimal v) {
        this.value = v;
    }

    @Override
    public Object get() {
        return new Float(this.value.floatValue());
    }

    @Override
    public boolean isPositive() {
        return this.value.signum() >= 0;
    }

    @Override
    public boolean isStrictlyPositive() {
        return this.value.signum() == 1;
    }

    public boolean isZero() {
        return BigDecimal.ZERO.compareTo(this.value) == 0;
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.value.toPlainString()).append('%');
        return sb.toString();
    }

    @Override
    public boolean equals(Object val) {
        return val instanceof CssPercentage && this.value.equals(((CssPercentage)val).value);
    }

    @Override
    public CssPercentage getPercentage() throws InvalidParamException {
        return this;
    }

    @Override
    public void checkPositiveness(ApplContext ac, CssProperty property) throws InvalidParamException {
        if (!this.isPositive()) {
            throw new InvalidParamException("negative-value", this.toString(), property.getPropertyName(), ac);
        }
    }

    @Override
    public void checkStrictPositiveness(ApplContext ac, CssProperty property) throws InvalidParamException {
        if (!this.isStrictlyPositive()) {
            throw new InvalidParamException("strictly-positive", this.toString(), property.getPropertyName(), ac);
        }
    }

    @Override
    public void warnPositiveness(ApplContext ac, CssProperty property) {
        if (!this.isPositive()) {
            ac.getFrame().addWarning("negative", this.toString());
        }
    }

    public void checkLowerEqualThan(ApplContext ac, double d, CssProperty property) throws InvalidParamException {
        BigDecimal other = BigDecimal.valueOf(d);
        if (this.value.compareTo(other) > 0) {
            throw new InvalidParamException("lowerequal", this.toString(), other.toPlainString(), ac);
        }
    }

    public void warnLowerEqualThan(ApplContext ac, double d, CssProperty property) {
        BigDecimal other = BigDecimal.valueOf(d);
        if (this.value.compareTo(other) > 0) {
            String[] s = new String[]{this.toString(), other.toPlainString() + '%'};
            ac.getFrame().addWarning("lowerequal", s);
        }
    }
}

