/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ModuleContextProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringModuleContextProvider
extends ModuleContextProvider {
    @NotNull
    public Module[] getContextModules(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/dom/SpringModuleContextProvider", "getContextModules"));
        }
        if (DumbService.isDumb((Project)file.getProject())) {
            if (Module.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/SpringModuleContextProvider", "getContextModules"));
            }
            return Module.EMPTY_ARRAY;
        }
        if (file instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file))) {
            Module[] moduleArray = (Module[])CachedValuesManager.getCachedValue((PsiElement)file, () -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/dom/SpringModuleContextProvider", "lambda$getContextModules$0"));
                }
                Collection<Module> modules = this.getRelatedModules(ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
                return CachedValueProvider.Result.create((Object)modules.toArray(new Module[modules.size()]), (Object[])new Object[]{file});
            });
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/SpringModuleContextProvider", "getContextModules"));
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/SpringModuleContextProvider", "getContextModules"));
        }
        return Module.EMPTY_ARRAY;
    }

    @NotNull
    public Collection<Module> getRelatedModules(@Nullable Module module) {
        if (module == null) {
            Set<Module> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/SpringModuleContextProvider", "getRelatedModules"));
            }
            return set;
        }
        LinkedHashSet result = new LinkedHashSet();
        result.addAll(ModuleUtilCore.getAllDependentModules((Module)module));
        LinkedHashSet dependencies = new LinkedHashSet();
        ModuleUtilCore.getDependencies((Module)module, dependencies);
        result.addAll(dependencies);
        List list = ContainerUtil.filter(result, module1 -> module1 != null && SpringFacet.getInstance((Module)module1) != null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/SpringModuleContextProvider", "getRelatedModules"));
        }
        return list;
    }
}

