/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiFile;
import com.intellij.spring.facet.validation.SpringUnmappedConfigurationFilesCollector;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class UnmappedConfigurationFilesValidator
extends FacetEditorValidator {
    private static final int MAX_FILES_TO_SHOW = 5;
    private final Module myModule;

    public UnmappedConfigurationFilesValidator(Module module) {
        this.myModule = module;
    }

    @NotNull
    public ValidationResult check() {
        if (DumbService.isDumb((Project)this.myModule.getProject()) || !InspectionProjectProfileManager.getInstance((Project)this.myModule.getProject()).isProfileLoaded()) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/validation/UnmappedConfigurationFilesValidator", "check"));
            }
            return validationResult;
        }
        SpringUnmappedConfigurationFilesCollector collector = new SpringUnmappedConfigurationFilesCollector(this.myModule);
        if (!collector.isEnabledInProject()) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/validation/UnmappedConfigurationFilesValidator", "check"));
            }
            return validationResult;
        }
        collector.collect();
        if (!collector.hasResults()) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/validation/UnmappedConfigurationFilesValidator", "check"));
            }
            return validationResult;
        }
        Collection<PsiFile> unmappedFiles = collector.getUnmappedFilesFor(this.myModule);
        if (unmappedFiles.size() <= 5) {
            String filesText = StringUtil.join(unmappedFiles, psiFile -> psiFile.getVirtualFile().getPresentableName(), (String)"<br/>");
            ValidationResult validationResult = new ValidationResult("Unmapped Spring configuration files:<br/>" + filesText);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/validation/UnmappedConfigurationFilesValidator", "check"));
            }
            return validationResult;
        }
        ValidationResult validationResult = new ValidationResult(unmappedFiles.size() + " unmapped Spring configuration files");
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/validation/UnmappedConfigurationFilesValidator", "check"));
        }
        return validationResult;
    }
}

