/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.events.annotator;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.events.beans.PublishEventPointDescriptor;
import com.intellij.spring.model.events.jam.SpringEventListener;
import com.intellij.spring.model.events.jam.SpringEventModelUtils;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringEventListenerAnnotator
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<PublishEventPointDescriptor, Collection<? extends PsiElement>> PUBLISH_EVENT_CONVERTOR = descriptor -> ContainerUtil.createMaybeSingletonList((Object)descriptor.getNavigatableElement());
    private static final NotNullFunction<SpringEventListener, Collection<? extends PsiElement>> EVENT_LISTENER_CONVERTOR = descriptor -> ContainerUtil.createMaybeSingletonList((Object)descriptor.getPsiElement());

    public String getId() {
        return "SpringEventListenerAnnotator";
    }

    public String getName() {
        return "Application Events";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.Listener;
    }

    public void collectNavigationMarkers(List<PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (psiElement == null || !SpringLibraryUtil.hasSpringLibrary((Project)psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "collectNavigationMarkers"));
        }
        if (!(psiElement instanceof PsiMethod) && !(psiElement instanceof PsiMethodCallExpression)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (!SpringLibraryUtil.isAtLeastVersion((Module)module, (SpringLibraryUtil.SpringVersion)SpringLibraryUtil.SpringVersion.V_4_2)) {
            return;
        }
        if (psiElement instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)psiElement;
            if (!psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor()) {
                return;
            }
            for (SpringEventListener eventListener : SemService.getSemService((Project)psiElement.getProject()).getSemElements(SpringEventListener.EVENT_LISTENER_ROOT_JAM_KEY, (PsiElement)psiMethod)) {
                PsiType returnType;
                PsiAnnotation psiAnnotation = eventListener.getAnnotation();
                if (psiAnnotation != null) {
                    HashSet points = ContainerUtil.newHashSet();
                    for (PsiType handledType : SpringEventModelUtils.getEventListenerHandledType(eventListener)) {
                        points.addAll(SpringEventModelUtils.getPublishPoints(module, handledType));
                    }
                    if (points.size() > 0) {
                        SpringEventListenerAnnotator.annotateEventListenerMethod(points, psiAnnotation, result);
                    }
                }
                if ((returnType = psiMethod.getReturnType()) == null || PsiType.VOID.equals((Object)returnType)) continue;
                SpringEventListenerAnnotator.annotatePublishPoints(module, result, returnType, (PsiElement)ObjectUtils.notNull((Object)psiMethod.getReturnTypeElement()));
            }
        } else if (SpringEventModelUtils.isPublishEventExpression((PsiMethodCallExpression)psiElement)) {
            SpringEventListenerAnnotator.annotateMethodCallExpression((PsiMethodCallExpression)psiElement, module, result);
        }
    }

    private static void annotateEventListenerMethod(@NotNull Collection<PublishEventPointDescriptor> points, @NotNull PsiAnnotation psiAnnotation, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (points == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "points", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateEventListenerMethod"));
        }
        if (psiAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAnnotation", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateEventListenerMethod"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateEventListenerMethod"));
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.Publisher, PUBLISH_EVENT_CONVERTOR).setTargets(points).setPopupTitle(SpringBundle.message("spring.event.publisher.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.event.publisher.tooltip.text", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)psiAnnotation));
    }

    private static void annotateMethodCallExpression(@NotNull PsiMethodCallExpression expression, @NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiType publishedType;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateMethodCallExpression"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateMethodCallExpression"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotateMethodCallExpression"));
        }
        PsiExpression[] expressions = expression.getArgumentList().getExpressions();
        if (expressions.length == 1 && (publishedType = expressions[0].getType()) != null) {
            SpringEventListenerAnnotator.annotatePublishPoints(module, result, publishedType, (PsiElement)expression.getMethodExpression());
        }
    }

    private static void annotatePublishPoints(@NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull PsiType publishedType, @NotNull PsiElement element) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotatePublishPoints"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotatePublishPoints"));
        }
        if (publishedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishedType", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotatePublishPoints"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator", "annotatePublishPoints"));
        }
        List<SpringEventListener> listeners = SpringEventModelUtils.getEventListeners(module, publishedType);
        if (!listeners.isEmpty()) {
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.Listener, EVENT_LISTENER_CONVERTOR).setTargets(listeners).setPopupTitle(SpringBundle.message("spring.event.listener.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.event.listener.tooltip.text", new Object[0]));
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(element));
        }
    }
}

