/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlTagTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.structure.SpringInjectionTreeElement;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SpringBeanTreeElement
implements StructureViewTreeElement,
ItemPresentation {
    private final DomSpringBean myBean;
    private final DomElementNavigationProvider myNavigationProvider;
    private final boolean myShowBeanStructure;
    private static final Function<PsiType, String> CLASS_NAME_GETTER = type -> StringUtil.notNullize((String)type.getPresentableText());

    public SpringBeanTreeElement(DomSpringBean springBean, DomElementNavigationProvider navigationProvider, boolean showBeanStructure) {
        this.myBean = springBean;
        this.myNavigationProvider = navigationProvider;
        this.myShowBeanStructure = showBeanStructure;
    }

    public Object getValue() {
        return this.myBean.isValid() ? this.myBean.getXmlElement() : null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        SpringBeanTreeElement springBeanTreeElement = this;
        if (springBeanTreeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/structure/SpringBeanTreeElement", "getPresentation"));
        }
        return springBeanTreeElement;
    }

    public String getPresentableText() {
        if (!this.myBean.isValid()) {
            return "";
        }
        String name = SpringPresentationProvider.getSpringBeanName((CommonSpringBean)this.myBean);
        Object[] psiTypes = this.getPsiTypes();
        String psiClassName = StringUtil.join((Object[])psiTypes, CLASS_NAME_GETTER, (String)",");
        if (!psiClassName.isEmpty()) {
            return name + ": " + psiClassName;
        }
        return name;
    }

    private PsiType[] getPsiTypes() {
        PsiType[] productTypes;
        PsiType beanType = this.myBean.getBeanType();
        if (beanType == null) {
            return PsiType.EMPTY_ARRAY;
        }
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)beanType);
        if (psiClass != null && SpringFactoryBeansManager.getInstance().isFactoryBeanClass(psiClass) && (productTypes = SpringFactoryBeansManager.getInstance().getObjectTypes(psiClass, (CommonSpringBean)this.myBean)).length > 0) {
            return productTypes;
        }
        return new PsiType[]{beanType};
    }

    public String getLocationString() {
        return null;
    }

    public Icon getIcon(boolean open) {
        return SpringPresentationProvider.getSpringIcon((Object)this.myBean);
    }

    @NotNull
    public TreeElement[] getChildren() {
        if (!this.myBean.isValid()) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/structure/SpringBeanTreeElement", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        if (this.myBean instanceof CustomBeanWrapper && SpringPropertyUtils.getProperties((CommonSpringBean)this.myBean).isEmpty() && ((CustomBeanWrapper)this.myBean).getCustomBeans().isEmpty()) {
            StructureViewTreeElement[] structureViewTreeElementArray = new XmlTagTreeElement(this.myBean.getXmlTag()).getChildren();
            if (structureViewTreeElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/structure/SpringBeanTreeElement", "getChildren"));
            }
            return structureViewTreeElementArray;
        }
        if (!this.myShowBeanStructure) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/structure/SpringBeanTreeElement", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        ArrayList<SpringInjectionTreeElement> children = new ArrayList<SpringInjectionTreeElement>();
        if (this.myBean instanceof SpringBean) {
            for (ConstructorArg arg : ((SpringBean)this.myBean).getConstructorArgs()) {
                children.add(new SpringInjectionTreeElement((SpringValueHolderDefinition)arg));
            }
        }
        for (SpringPropertyDefinition property : SpringPropertyUtils.getProperties((CommonSpringBean)this.myBean)) {
            children.add(new SpringInjectionTreeElement((SpringValueHolderDefinition)property));
        }
        TreeElement[] treeElementArray = (TreeElement[])children.toArray(new SpringInjectionTreeElement[children.size()]);
        if (treeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/structure/SpringBeanTreeElement", "getChildren"));
        }
        return treeElementArray;
    }

    public void navigate(boolean requestFocus) {
        if (this.myNavigationProvider != null) {
            this.myNavigationProvider.navigate((DomElement)this.myBean, requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.myBean.isValid() && this.myNavigationProvider != null && this.myNavigationProvider.canNavigate((DomElement)this.myBean);
    }

    public boolean canNavigateToSource() {
        return this.myBean.isValid() && this.myNavigationProvider != null && this.myNavigationProvider.canNavigate((DomElement)this.myBean);
    }
}

