/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.references.PomService;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBaseBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PatchedWeakReference;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.impl.DomImplUtil;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomSpringBeanPointerImpl
extends SpringBaseBeanPointer<DomSpringBean>
implements DomSpringBeanPointer {
    @NotNull
    private final DomAnchor<DomSpringBean> myPointer;
    private CachedValue<PsiClass> myClassCachedValue;
    private WeakReference<DomSpringBean> myCachedValue;

    public DomSpringBeanPointerImpl(@NotNull DomSpringBean springBean) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/xml/DomSpringBeanPointerImpl", "<init>"));
        }
        super(springBean.getBeanName(), springBean.getManager().getProject());
        ProgressManager.checkCanceled();
        this.myCachedValue = new PatchedWeakReference((Object)springBean);
        assert (springBean.exists()) : springBean;
        this.myPointer = DomService.getInstance().createAnchor((DomElement)springBean);
    }

    @NotNull
    public DomSpringBean getSpringBean() {
        DomSpringBean bean = (DomSpringBean)this.myCachedValue.get();
        if (bean != null) {
            DomSpringBean domSpringBean = bean;
            if (domSpringBean == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/DomSpringBeanPointerImpl", "getSpringBean"));
            }
            return domSpringBean;
        }
        bean = (DomSpringBean)this.myPointer.retrieveDomElement();
        if (bean == null) {
            throw new IllegalStateException("no Dom at pointer: " + this.myPointer + " for " + this.getName());
        }
        XmlElement element = bean.getXmlElement();
        if (element != null && !element.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)element, "Invalid Dom element of " + bean.getClass());
        }
        DomImplUtil.assertValidity((DomElement)bean, (String)"Invalid retrieved bean");
        this.myCachedValue = new PatchedWeakReference((Object)bean);
        DomSpringBean domSpringBean = bean;
        if (domSpringBean == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/DomSpringBeanPointerImpl", "getSpringBean"));
        }
        return domSpringBean;
    }

    public boolean isValid() {
        DomSpringBean bean = (DomSpringBean)this.myCachedValue.get();
        if (bean != null) {
            return bean.isValid();
        }
        bean = (DomSpringBean)this.myPointer.retrieveDomElement();
        if (bean != null && bean.isValid()) {
            this.myCachedValue = new PatchedWeakReference((Object)bean);
            return true;
        }
        return false;
    }

    public PsiElement getPsiElement() {
        return PomService.convertToPsi((PsiTarget)new DomSpringBeanPsiTarget(this.getSpringBean()));
    }

    public PsiClass getBeanClass() {
        if (this.myClassCachedValue == null) {
            this.myClassCachedValue = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)this.getSpringBean().getBeanType());
                return CachedValueProvider.Result.createSingleDependency((Object)beanClass, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            });
        }
        return (PsiClass)this.myClassCachedValue.getValue();
    }

    public PsiFile getContainingFile() {
        return this.myPointer.getContainingFile();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DomSpringBeanPointerImpl)) {
            return false;
        }
        DomSpringBeanPointerImpl other = (DomSpringBeanPointerImpl)o;
        return Comparing.equal((String)this.getName(), (String)other.getName()) && this.myPointer.equals(other.myPointer) && this.isValid() && other.isValid() && Comparing.equal((Object)this.getPsiElement(), (Object)other.getPsiElement());
    }

    @Override
    public int hashCode() {
        return this.myPointer.hashCode();
    }

    @NotNull
    public static SpringBeanPsiTarget createSpringBeanPsiTarget(DomSpringBean domSpringBean) {
        DomSpringBeanPsiTarget domSpringBeanPsiTarget = new DomSpringBeanPsiTarget(domSpringBean);
        if (domSpringBeanPsiTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/DomSpringBeanPointerImpl", "createSpringBeanPsiTarget"));
        }
        return domSpringBeanPsiTarget;
    }

    private static class DomSpringBeanPsiTarget
    extends DelegatePsiTarget
    implements SpringBeanPsiTarget {
        private final DomSpringBean mySpringBean;

        private DomSpringBeanPsiTarget(DomSpringBean bean) {
            super((PsiElement)ObjectUtils.assertNotNull((Object)bean.getXmlElement()));
            this.mySpringBean = bean;
        }

        public boolean isWritable() {
            return true;
        }

        public Object setName(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/spring/model/xml/DomSpringBeanPointerImpl$DomSpringBeanPsiTarget", "setName"));
            }
            this.mySpringBean.setName(newName);
            return this;
        }

        public CommonSpringBean getSpringBean() {
            return this.mySpringBean;
        }

        @Nullable
        public String getName() {
            return this.mySpringBean.getBeanName();
        }
    }
}

