/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.passwordSafe.MasterPasswordUnavailableException;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.PasswordStorage;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe;
import com.intellij.ide.passwordSafe.impl.providers.memory.MemoryPasswordSafe;
import com.intellij.ide.passwordSafe.ui.PasswordPromptComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseCredentials {
    private static final String DB_PWD = "db:pwd@";
    private static final String DB_SSH_PWD = "db:ssh:pwd@";
    private static final String DB_SSH_PHR = "db:ssh:phr@";
    private static final DatabaseCredentials ourInstance = new DatabaseCredentials();
    private static final MemoryPasswordSafe ourMemorySafe = new MemoryPasswordSafe(){

        protected int getMinutesToLive() {
            return Registry.intValue((String)"passwordSafe.masterPassword.ttl");
        }
    };

    public static DatabaseCredentials getInstance() {
        return ourInstance;
    }

    public static DatabaseCredentials newUIInstance() {
        return new DatabaseCredentials(){
            boolean myForceMemoryProvider;

            @Override
            protected void handleMasterPasswordFailed() {
                this.myForceMemoryProvider = true;
            }

            @Override
            protected PasswordStorage getPasswordStorageInner(@NotNull LocalDataSource dataSource, @NotNull StorageType storageType) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials$2", "getPasswordStorageInner"));
                }
                if (storageType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageType", "com/intellij/database/access/DatabaseCredentials$2", "getPasswordStorageInner"));
                }
                return this.myForceMemoryProvider ? DatabaseCredentials.getMemoryProvider() : super.getPasswordStorageInner(dataSource, storageType);
            }

            @Override
            public void persistCredentials(@NotNull Project project, @NotNull DatabaseSystem info) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials$2", "persistCredentials"));
                }
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials$2", "persistCredentials"));
                }
                if (this.myForceMemoryProvider && info instanceof LocalDataSource && ((LocalDataSource)info).getSecretStorage() == StorageType.MASTER_KEY) {
                    ((LocalDataSource)info).setSecretStorage(StorageType.MEMORY);
                }
                super.persistCredentials(project, info);
            }
        };
    }

    @Nullable
    private static LocalDataSource getLocalDataSource(@Nullable DatabaseSystem info) {
        if (!(info instanceof LocalDataSource)) {
            return null;
        }
        if (!DbImplUtil.isAuthRequired((LocalDataSource)info)) {
            return null;
        }
        return (LocalDataSource)info;
    }

    @Nullable
    private PasswordStorage getPasswordStorage(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "getPasswordStorage"));
        }
        return this.getPasswordStorageInner(dataSource, dataSource.getSecretStorage());
    }

    @Nullable
    protected PasswordStorage getPasswordStorageInner(@NotNull LocalDataSource dataSource, @NotNull StorageType storageType) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "getPasswordStorageInner"));
        }
        if (storageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageType", "com/intellij/database/access/DatabaseCredentials", "getPasswordStorageInner"));
        }
        if (storageType == StorageType.EMBEDDED || dataSource.getUniqueId() == null) {
            return null;
        }
        return storageType == StorageType.MEMORY ? DatabaseCredentials.getMemoryProvider() : DatabaseCredentials.getMasterKeySafe();
    }

    @NotNull
    public Pair<String, String> getCredentials(@NotNull Project project, @NotNull DatabaseSystem info) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "getCredentials"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "getCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            Pair pair = Pair.create(null, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getCredentials"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)dataSource.getUsername(), (Object)StringUtil.notNullize((String)this.getPasswordInner(project, dataSource, this.getPasswordStorage(dataSource))));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getCredentials"));
        }
        return pair;
    }

    @NotNull
    public Pair<String, String> getCredentialsNoUI(@NotNull DatabaseSystem info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "getCredentialsNoUI"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            Pair pair = Pair.create(null, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getCredentialsNoUI"));
            }
            return pair;
        }
        StorageType storageType = dataSource.getSecretStorage();
        MemoryPasswordSafe safe = storageType == StorageType.MASTER_KEY ? DatabaseCredentials.getMemoryProvider() : this.getPasswordStorage(dataSource);
        Pair pair = Pair.create((Object)dataSource.getUsername(), (Object)this.getPasswordInnerOrMem(null, dataSource, (PasswordStorage)safe));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getCredentialsNoUI"));
        }
        return pair;
    }

    private String getPasswordInnerOrMem(@Nullable Project project, @NotNull LocalDataSource dataSource, @Nullable PasswordStorage safe) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "getPasswordInnerOrMem"));
        }
        String pwd = this.getPasswordInner(project, dataSource, safe);
        if (StringUtil.isEmpty((String)pwd) && safe != DatabaseCredentials.getMemoryProvider()) {
            pwd = this.getPasswordInner(project, dataSource, (PasswordStorage)DatabaseCredentials.getMemoryProvider());
        }
        return StringUtil.notNullize((String)pwd);
    }

    private String getPasswordInner(@Nullable Project project, @NotNull LocalDataSource dataSource, @Nullable PasswordStorage safe) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "getPasswordInner"));
        }
        if (safe == null) {
            return dataSource.getPassword();
        }
        try {
            return DatabaseCredentials.get_(project, safe, DB_PWD + dataSource.getUniqueId());
        }
        catch (MasterPasswordUnavailableException e) {
            this.handleMasterPasswordFailed();
        }
        catch (PasswordSafeException passwordSafeException) {
            // empty catch block
        }
        return null;
    }

    public boolean setCredentials(@NotNull Project project, @NotNull DatabaseSystem info, String uid, String pwd) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "setCredentials"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "setCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            return false;
        }
        this.removeCredentials(project, (DatabaseSystem)dataSource, StorageType.MEMORY);
        return this.setCredentialsInner(project, dataSource, uid, pwd, this.getPasswordStorage(dataSource));
    }

    private boolean setCredentialsInner(@Nullable Project project, @NotNull LocalDataSource dataSource, String uid, String pwd, @Nullable PasswordStorage safe) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "setCredentialsInner"));
        }
        dataSource.setUsername(uid);
        try {
            if (safe == null) {
                dataSource.setPassword(pwd);
            } else {
                DatabaseCredentials.set_(project, safe, DB_PWD + dataSource.getUniqueId(), pwd);
            }
            return true;
        }
        catch (MasterPasswordUnavailableException e) {
            this.handleMasterPasswordFailed();
        }
        catch (PasswordSafeException passwordSafeException) {
            // empty catch block
        }
        return false;
    }

    public boolean removeCredentials(@NotNull Project project, @NotNull DatabaseSystem info, @NotNull StorageType storageType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "removeCredentials"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "removeCredentials"));
        }
        if (storageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageType", "com/intellij/database/access/DatabaseCredentials", "removeCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            return false;
        }
        PasswordStorage safe = this.getPasswordStorageInner(dataSource, storageType);
        try {
            if (safe == null) {
                dataSource.setPassword(null);
            } else {
                DatabaseCredentials.trash_(project, safe, DB_PWD + dataSource.getUniqueId());
            }
            return true;
        }
        catch (MasterPasswordUnavailableException e) {
            this.handleMasterPasswordFailed();
        }
        catch (PasswordSafeException passwordSafeException) {
            // empty catch block
        }
        return false;
    }

    public void copyCredentials(@NotNull Project project, @NotNull DatabaseSystem from, @NotNull DatabaseSystem to) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "copyCredentials"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/access/DatabaseCredentials", "copyCredentials"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/access/DatabaseCredentials", "copyCredentials"));
        }
        Pair<String, String> credentials = this.getCredentials(project, from);
        if (credentials.first != null) {
            this.setCredentials(project, to, (String)credentials.first, (String)credentials.second);
        }
    }

    public void persistCredentials(@NotNull Project project, @NotNull DatabaseSystem info) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "persistCredentials"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "persistCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            return;
        }
        if (dataSource.getSecretStorage() == StorageType.EMBEDDED) {
            return;
        }
        String uid = dataSource.getUsername();
        String pwd = dataSource.getPassword();
        dataSource.setPassword(null);
        if (!this.setCredentials(project, (DatabaseSystem)dataSource, uid, pwd)) {
            dataSource.setSecretStorage(StorageType.MEMORY);
            this.setCredentials(project, (DatabaseSystem)dataSource, uid, pwd);
        }
    }

    protected void handleMasterPasswordFailed() {
    }

    @NotNull
    private static MemoryPasswordSafe getMemoryProvider() {
        MemoryPasswordSafe memoryPasswordSafe = ourMemorySafe;
        if (memoryPasswordSafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getMemoryProvider"));
        }
        return memoryPasswordSafe;
    }

    @NotNull
    private static MasterKeyPasswordSafe getMasterKeySafe() {
        MasterKeyPasswordSafe masterKeyPasswordSafe = ((PasswordSafeImpl)PasswordSafe.getInstance()).getMasterKeyProvider();
        if (masterKeyPasswordSafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getMasterKeySafe"));
        }
        return masterKeyPasswordSafe;
    }

    @Nullable
    public Pair<String, String> askCredentialsWhenFailed(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String message, String userNameDef) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
        }
        if (DatabaseCredentials.getLocalDataSource((DatabaseSystem)dataSource) == null) {
            return null;
        }
        Pair<String, String> c1 = this.getCredentialsNoUI((DatabaseSystem)dataSource);
        return (Pair)DatabaseCredentials.getMasterKeySafe().invokeAndWait(() -> {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "lambda$askCredentialsWhenFailed$0"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/access/DatabaseCredentials", "lambda$askCredentialsWhenFailed$0"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "lambda$askCredentialsWhenFailed$0"));
            }
            Pair<String, String> c2 = this.getCredentialsNoUI((DatabaseSystem)dataSource);
            if (!c1.equals(c2)) {
                return c2;
            }
            PasswordStorage curSafe = this.getPasswordStorage(dataSource);
            PasswordSafeSettings.ProviderType providerType = curSafe != null ? PasswordSafeSettings.ProviderType.MASTER_PASSWORD : PasswordSafeSettings.ProviderType.DO_NOT_STORE;
            PasswordPromptComponent component = new PasswordPromptComponent(providerType, message, true, null, DatabaseMessages.message((String)"save.on.disk", (Object[])new Object[0]));
            component.setRememberSelected(false);
            component.setUserName(StringUtil.notNullize((String)userNameDef));
            DialogBuilder builder = new DialogBuilder(project);
            builder.setTitle("Connecting to '" + dataSource.getName() + "'...");
            builder.setCenterPanel(component.getComponent());
            builder.setPreferredFocusComponent(component.getPreferredFocusedComponent());
            builder.addOkAction();
            builder.addCancelAction();
            if (builder.show() == 0) {
                String uid = component.getUserName();
                String pwd = new String(component.getPassword());
                boolean remember = component.isRememberSelected();
                this.setCredentialsInner(project, dataSource, uid, pwd, (PasswordStorage)(dataSource.getUniqueId() == null ? null : DatabaseCredentials.getMemoryProvider()));
                if (remember && this.setCredentialsInner(project, dataSource, uid, pwd, (PasswordStorage)DatabaseCredentials.getMasterKeySafe())) {
                    dataSource.setSecretStorage(StorageType.MASTER_KEY);
                }
                return Pair.create((Object)uid, (Object)pwd);
            }
            return null;
        }, project.getDisposed());
    }

    public boolean setSshCredentials(@NotNull Project project, @NotNull LocalDataSource dataSource, String pwd, String phr) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "setSshCredentials"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "setSshCredentials"));
        }
        DataSourceSshTunnelConfiguration ssh = dataSource.getSshConfiguration();
        if (ssh == null) {
            return true;
        }
        PasswordStorage safe = this.getPasswordStorageInner(dataSource, ssh.getSecretStorage());
        try {
            if (safe != null) {
                DatabaseCredentials.set_(project, safe, DB_SSH_PWD + dataSource.getUniqueId(), pwd);
                DatabaseCredentials.set_(project, safe, DB_SSH_PHR + dataSource.getUniqueId(), phr);
            }
            return true;
        }
        catch (MasterPasswordUnavailableException e) {
            this.handleMasterPasswordFailed();
        }
        catch (PasswordSafeException passwordSafeException) {
            // empty catch block
        }
        return false;
    }

    public boolean removeSshCredentials(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull StorageType storageType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "removeSshCredentials"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "removeSshCredentials"));
        }
        if (storageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageType", "com/intellij/database/access/DatabaseCredentials", "removeSshCredentials"));
        }
        PasswordStorage safe = this.getPasswordStorageInner(dataSource, storageType);
        try {
            if (safe != null) {
                DatabaseCredentials.trash_(project, safe, DB_SSH_PWD + dataSource.getUniqueId());
                DatabaseCredentials.trash_(project, safe, DB_SSH_PHR + dataSource.getUniqueId());
            }
            return true;
        }
        catch (MasterPasswordUnavailableException e) {
            this.handleMasterPasswordFailed();
        }
        catch (PasswordSafeException passwordSafeException) {
            // empty catch block
        }
        return false;
    }

    @NotNull
    public Pair<String, String> getSshCredentials(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        block12: {
            Pair pair;
            PasswordStorage safe;
            block11: {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
                }
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
                }
                DataSourceSshTunnelConfiguration ssh = dataSource.getSshConfiguration();
                if (ssh == null) {
                    Pair pair2 = Pair.create((Object)"", (Object)"");
                    if (pair2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
                    }
                    return pair2;
                }
                safe = this.getPasswordStorageInner(dataSource, ssh.getSecretStorage());
                if (safe != null) break block11;
                Pair pair3 = Pair.create((Object)PasswordUtil.decodePassword((String)ssh.getPassword()), (Object)PasswordUtil.decodePassword((String)ssh.getPassphrase()));
                if (pair3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
                }
                return pair3;
            }
            try {
                String pwd = DatabaseCredentials.get_(project, safe, DB_SSH_PWD + dataSource.getUniqueId());
                String phr = DatabaseCredentials.get_(project, safe, DB_SSH_PHR + dataSource.getUniqueId());
                pair = Pair.create((Object)StringUtil.notNullize((String)pwd), (Object)StringUtil.notNullize((String)phr));
            }
            catch (MasterPasswordUnavailableException e) {
                this.handleMasterPasswordFailed();
                break block12;
            }
            catch (PasswordSafeException passwordSafeException) {
                // empty catch block
            }
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)"", (Object)"");
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
        }
        return pair;
    }

    private static String get_(Project project, PasswordStorage safe, String key) throws PasswordSafeException {
        return safe.getPassword(project, DatabaseCredentials.class, key);
    }

    private static void set_(Project project, PasswordStorage safe, String key, String pwd) throws PasswordSafeException {
        safe.storePassword(project, DatabaseCredentials.class, key, StringUtil.notNullize((String)pwd));
    }

    private static void trash_(Project project, PasswordStorage safe, String key) throws PasswordSafeException {
        safe.removePassword(project, DatabaseCredentials.class, key);
    }

    public static enum StorageType {
        EMBEDDED,
        MEMORY,
        MASTER_KEY;

    }
}

