/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceGeneralPanel;
import com.intellij.database.dataSource.DataSourceNameComponent;
import com.intellij.database.dataSource.DataSourceOptionsPanel;
import com.intellij.database.dataSource.DataSourceSshSslPanel;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DefaultDbPsiManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.ui.DatabaseDriverPropertiesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceConfigurable
extends AbstractDataSourceConfigurable<DefaultDbPsiManager, LocalDataSource> {
    private static final Key<Pair<String, Integer>> SELECTED_TAB_KEY = Key.create((String)"DataSourceConfigurable.defaultTabIndex");
    private static final String TAB_GENERAL = "General";
    private static final String TAB_SSH_SSL = "SSH/SSL";
    private static final String TAB_OPTIONS = "Options";
    private static final String TAB_ADVANCED = "Advanced";
    private final JPanel myPanel = new JPanel(new BorderLayout(0, 5));
    private TabbedPaneWrapper myTabbedPane;
    private final LocalDataSource myTempDataSource;
    private DataSourceNameComponent myNameComponent;
    private DataSourceGeneralPanel myGeneralPanel;
    private DataSourceOptionsPanel myOptionsPanel;
    private DataSourceSshSslPanel mySshSslPanel;
    private DatabaseDriverPropertiesPanel myAdvancedPanel;
    private boolean mySyncOnClose;
    private boolean myGlobal;
    private final Action myTestAction = this.createTestAction();

    public DataSourceConfigurable(DefaultDbPsiManager manager, LocalDataSource dataSource, Project project) {
        super(manager, dataSource, project);
        this.mySyncOnClose = !DbImplUtil.canConnectTo((LocalDataSource)this.myDataSource);
        this.myTempDataSource = dataSource.copy(project);
    }

    Object createKey(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceConfigurable", "createKey"));
        }
        StringBuilder cpString = new StringBuilder();
        for (SimpleClasspathElement cpe : dataSource.getClasspathElements()) {
            cpString.append(cpe.getClassesRootUrls()).append(";");
        }
        Pair credentials = dataSource == this.myTempDataSource ? Pair.create((Object)this.myGeneralPanel.getPassword(), (Object)this.myGeneralPanel.getUserName()) : this.getSecretService().getCredentials(this.myProject, (DatabaseSystem)dataSource);
        String cre = StringUtil.notNullize((String)((String)credentials.first)) + "@" + StringHash.calc((String)StringUtil.notNullize((String)((String)credentials.second)));
        return "auth:" + cre + ";driver:" + dataSource.getDriverClass() + "; url:" + dataSource.getUrl() + "; cp:" + cpString + "; vm-options: " + dataSource.getVmOptions();
    }

    @Nullable
    String getUserName() {
        return this.myGeneralPanel.getUserName();
    }

    void updateDatabaseInfo(@NotNull LocalDataSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dataSource/DataSourceConfigurable", "updateDatabaseInfo"));
        }
        if (Comparing.equal((Object)this.createKey(source), (Object)this.createKey((LocalDataSource)this.myDataSource))) {
            ((LocalDataSource)this.myDataSource).copyDatabaseInfo(source);
        }
    }

    @Override
    @NotNull
    public LocalDataSource getTempDataSource() {
        this.saveData(this.myTempDataSource, false);
        LocalDataSource localDataSource = this.myTempDataSource;
        if (localDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceConfigurable", "getTempDataSource"));
        }
        return localDataSource;
    }

    @NotNull
    public LocalDataSource getTempDataSourceForConnection() {
        LocalDataSource ds = ((LocalDataSource)this.myDataSource).copy(this.myProject);
        this.saveData(ds, true);
        LocalDataSource localDataSource = ds;
        if (localDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceConfigurable", "getTempDataSourceForConnection"));
        }
        return localDataSource;
    }

    public boolean testConnection() {
        this.setConnectionStatus(null);
        final LocalDataSource tempDataSource = this.getTempDataSourceForConnection();
        if (StringUtil.isEmptyOrSpaces((String)tempDataSource.getUrl())) {
            Messages.showErrorDialog((String)DatabaseMessages.message((String)"message.text.specify.database.url", (Object[])new Object[0]), (String)"Connect to Database...");
            this.myGeneralPanel.requestUrlFocus();
            return false;
        }
        return new DataSourceUiUtil.RefreshTask(this.getProject(), new LoaderContext(tempDataSource), true){

            @Override
            protected void onTaskCompleted(LoaderContext context, long elapsedTime) {
                boolean failed = context.getErrorHandler().hasErrors();
                DataSourceConfigurable.this.myController.showErrorNotification((Configurable)DataSourceConfigurable.this, "TEST_CONNECTION", failed ? "Error" : null, context.getErrorHandler().getSummary(), new Object[0]);
                DataSourceConfigurable.this.updateDatabaseInfo(tempDataSource);
                DataSourceConfigurable.this.myGeneralPanel.resetCredentials(tempDataSource);
                DataSourceUiUtil.Status status = failed ? DataSourceUiUtil.Status.failed() : DataSourceUiUtil.Status.successful(DataSourceUiUtil.formatDataSourceInfoString(tempDataSource));
                DataSourceConfigurable.this.setConnectionStatus(status);
            }
        }.perform().isDone();
    }

    private void setConnectionStatus(@Nullable DataSourceUiUtil.Status status) {
        for (DataSourceUiUtil.StatusPanel panel : UIUtil.uiTraverser((Component)this.myPanel).traverse().filter(DataSourceUiUtil.StatusPanel.class)) {
            panel.setStatus(status == null ? null : status);
        }
    }

    protected JComponent createCenterPanel() {
        this.myNameComponent = new DataSourceNameComponent(this, this.myController);
        this.myPanel.add((Component)this.myNameComponent.getComponent(), "North");
        this.myTabbedPane = new TabbedPaneWrapper((Disposable)this);
        this.myPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
        this.myGeneralPanel = new DataSourceGeneralPanel(this);
        this.myOptionsPanel = new DataSourceOptionsPanel(this);
        this.myAdvancedPanel = new DatabaseDriverPropertiesPanel(this.myProject, ((LocalDataSource)this.myDataSource).getDriverProperties(), ((LocalDataSource)this.myDataSource).getVmOptions(), (Configurable)this, this.myController);
        this.myTabbedPane.addTab(TAB_GENERAL, (JComponent)this.myGeneralPanel.getComponent());
        this.mySshSslPanel = new DataSourceSshSslPanel(this.getProject(), (LocalDataSource)this.myDataSource, this);
        this.myTabbedPane.addTab(TAB_SSH_SSL, (JComponent)this.mySshSslPanel.getComponent());
        this.myTabbedPane.addTab(TAB_OPTIONS, (JComponent)this.myOptionsPanel.getComponent());
        this.myTabbedPane.addTab(TAB_ADVANCED, (JComponent)this.myAdvancedPanel.getComponent());
        this.myTabbedPane.setSelectedIndex(this.getDefaultTabIndex());
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceConfigurable$2", "stateChanged"));
                }
                DataSourceConfigurable.this.updateDefaultTabIndex();
            }
        });
        Disposer.register((Disposable)this, () -> ApplicationManager.getApplication().invokeLater(this::syncSchemaOnClose, ModalityState.NON_MODAL));
        return this.myPanel;
    }

    @Override
    public void beforeShowNotify() {
        super.beforeShowNotify();
        this.myTabbedPane.setSelectedIndex(this.getDefaultTabIndex());
    }

    @Override
    public void onUserActivity() {
        this.saveGeneralSettings(this.myTempDataSource, false);
        this.setConnectionStatus(null);
        this.mySshSslPanel.updateInfoLabel();
        this.myGeneralPanel.setCanConnect(DbImplUtil.canConnectTo(this.myTempDataSource));
    }

    private int getDefaultTabIndex() {
        Pair p = (Pair)this.myController.getUserData(SELECTED_TAB_KEY);
        if (p == null) {
            return 0;
        }
        if ((Integer)p.second < this.myTabbedPane.getTabCount() && (Integer)p.second >= 0 && Comparing.equal((String)((String)p.first), (String)this.myTabbedPane.getTitleAt(((Integer)p.second).intValue()))) {
            return (Integer)p.second;
        }
        for (int i = this.myTabbedPane.getTabCount() - 1; i > 0; --i) {
            if (!Comparing.equal((String)((String)p.first), (String)this.myTabbedPane.getTitleAt(i))) continue;
            return i;
        }
        return 0;
    }

    private void updateDefaultTabIndex() {
        Pair p = Pair.create((Object)this.myTabbedPane.getSelectedTitle(), (Object)this.myTabbedPane.getSelectedIndex());
        this.myController.putUserData(SELECTED_TAB_KEY, p);
    }

    public String getNameValue() {
        return this.myNameComponent.getNameValue();
    }

    public void setGeneratedName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DataSourceConfigurable", "setGeneratedName"));
        }
        this.myNameComponent.setGeneratedName(name);
    }

    public void saveData(@NotNull LocalDataSource dataSource, boolean copyCredentials) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceConfigurable", "saveData"));
        }
        this.saveGeneralSettings(dataSource, copyCredentials);
        if (dataSource.getFirstSync() == ThreeState.UNSURE && this.isNewDataSource()) {
            dataSource.setFirstSync(ThreeState.YES);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.saveData(dataSource);
        }
        if (this.myAdvancedPanel != null) {
            this.myAdvancedPanel.saveProperties(dataSource.getDriverProperties());
            dataSource.setVmOptions(StringUtil.nullize((String)this.myAdvancedPanel.getVmOptions()));
            dataSource.setVmEnv(this.myAdvancedPanel.getVmEnv());
        }
        if (this.mySshSslPanel != null) {
            this.mySshSslPanel.saveData(dataSource, copyCredentials);
        }
    }

    public void saveGeneralSettings(@NotNull LocalDataSource dataSource, boolean copyCredentials) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceConfigurable", "saveGeneralSettings"));
        }
        dataSource.setName(this.getNameValue());
        dataSource.setGlobal(this.myGlobal);
        this.myGeneralPanel.saveSettings(dataSource, copyCredentials);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.database.dataSource.DataSourceConfigurable";
    }

    @Nls
    public String getDisplayName() {
        return this.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.tools.datasource.properties";
    }

    @Nullable
    public JComponent createComponent() {
        return this.createCenterPanel();
    }

    public void apply() throws ConfigurationException {
        int ret;
        LocalDataSource tempDataSource = ((LocalDataSource)this.myDataSource).copy(this.myProject);
        this.saveData(tempDataSource, true);
        String error = StringUtil.isEmpty((String)tempDataSource.getDriverClass()) ? DatabaseMessages.message((String)"error.text.database.driver.not.configured", (Object[])new Object[0]) : null;
        if (error != null && (ret = Messages.showYesNoDialog((String)DatabaseMessages.message((String)"confirmation.text.error.occured.save.datasource", (Object[])new Object[]{error}), (String)DatabaseMessages.message((String)"message.title.invalid.datasource", (Object[])new Object[0]), (Icon)Messages.getErrorIcon())) != 0) {
            return;
        }
        boolean newDataSource = this.isNewDataSource();
        boolean resetConnections = !Comparing.equal((String)tempDataSource.getDriverClass(), (String)((LocalDataSource)this.myDataSource).getDriverClass()) || !tempDataSource.getClasspathElements().equals(((LocalDataSource)this.myDataSource).getClasspathElements()) || !DataSourceSshTunnelConfiguration.equal(tempDataSource.getSshConfiguration(), ((LocalDataSource)this.myDataSource).getSshConfiguration()) || !DataSourceSslConfiguration.equal(tempDataSource.getSslCfg(), ((LocalDataSource)this.myDataSource).getSslCfg());
        boolean schemaChanged = newDataSource || tempDataSource.isAutoSynchronize() && !((LocalDataSource)this.myDataSource).isAutoSynchronize() || !this.equalCredentials(tempDataSource, (LocalDataSource)this.myDataSource) || !Comparing.strEqual((String)tempDataSource.getUrl(), (String)((LocalDataSource)this.myDataSource).getUrl()) || !Comparing.equal((Object)this.myTempDataSource.getIntrospectionScope(), (Object)((LocalDataSource)this.myDataSource).getIntrospectionScope()) || !Comparing.strEqual((String)tempDataSource.getTablePattern(), (String)((LocalDataSource)this.myDataSource).getTablePattern());
        this.saveData((LocalDataSource)this.myDataSource, true);
        ((LocalDataSource)this.myDataSource).setFirstSync(tempDataSource.getFirstSync());
        this.updateDatabaseInfo(tempDataSource);
        if (resetConnections) {
            JdbcDriverManager.getDriverManager(this.myProject).releaseDriver((LocalDataSource)this.myDataSource, null);
        }
        if (newDataSource) {
            ((DefaultDbPsiManager)this.myManager).processAddOrRemove((LocalDataSource)this.myDataSource, true);
        } else {
            ((DefaultDbPsiManager)this.myManager).fireDataSourceUpdated((LocalDataSource)this.myDataSource);
        }
        this.mySyncOnClose |= schemaChanged;
    }

    private void syncSchemaOnClose() {
        if (!this.myController.isObjectApplied(this.myDataSource)) {
            return;
        }
        if (this.mySyncOnClose) {
            DataSourceUiUtil.performAutoSyncTask(this.myProject, (LocalDataSource)this.myDataSource);
        }
    }

    public void reset() {
        this.myGlobal = ((LocalDataSource)this.myDataSource).isGlobal();
        this.myGeneralPanel.reset((LocalDataSource)this.myDataSource);
        this.myAdvancedPanel.setVmOptions(((LocalDataSource)this.myDataSource).getVmOptions());
        this.myAdvancedPanel.setVmEnv(((LocalDataSource)this.myDataSource).getVmEnv());
        this.myNameComponent.setNameValue((String)ObjectUtils.chooseNotNull((Object)StringUtil.nullize((String)((LocalDataSource)this.myDataSource).getName()), (Object)this.myGeneralPanel.generateNameFromParameters()));
        this.mySshSslPanel.reset((LocalDataSource)this.myDataSource);
        this.myOptionsPanel.reset((LocalDataSource)this.myDataSource);
    }

    @Override
    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        LocalDataSource tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((LocalDataSource)this.myDataSource).getName())) {
            return true;
        }
        if (tempDataSource.getSecretStorage() != ((LocalDataSource)this.myDataSource).getSecretStorage()) {
            return true;
        }
        if (this.myGeneralPanel.isPasswordChanged() || !Comparing.equal((String)tempDataSource.getUsername(), (String)((LocalDataSource)this.myDataSource).getUsername())) {
            return true;
        }
        if (this.mySshSslPanel.isPasswordChanged() || this.mySshSslPanel.isPassphraseChanged()) {
            return true;
        }
        return !tempDataSource.equalConfiguration((LocalDataSource)this.myDataSource);
    }

    private boolean equalCredentials(LocalDataSource d1, LocalDataSource d2) {
        Pair<String, String> c2;
        Pair<String, String> c1;
        if (!d1.isAuthRequired() || !d2.isAuthRequired()) {
            return !d1.isAuthRequired() && !d2.isAuthRequired();
        }
        DatabaseCredentials cre = this.getSecretService();
        if (d1.getSecretStorage() != d2.getSecretStorage()) {
            return false;
        }
        if (!(!this.myGeneralPanel.isPasswordChanged() && Comparing.equal((String)d1.getUsername(), (String)d2.getUsername()) || (c1 = cre.getCredentials(this.myProject, (DatabaseSystem)d1)).equals(c2 = cre.getCredentials(this.myProject, (DatabaseSystem)d2)))) {
            return false;
        }
        if (this.mySshSslPanel.isPasswordChanged() || this.mySshSslPanel.isPassphraseChanged()) {
            Pair<String, String> ssh1 = cre.getSshCredentials(this.myProject, d1);
            Pair<String, String> ssh2 = cre.getSshCredentials(this.myProject, d2);
            return ssh1.equals(ssh2);
        }
        return true;
    }

    public void showErrorNotification(Exception ex, @NotNull Object id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/dataSource/DataSourceConfigurable", "showErrorNotification"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/dataSource/DataSourceConfigurable", "lambda$showErrorNotification$1"));
            }
            this.myController.showErrorNotification((Configurable)this, id, ex);
        });
    }

    public void setDriver(@Nullable DatabaseDriver driver) {
        this.myGeneralPanel.setDriver(driver);
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    @NotNull
    private Action createTestAction() {
        AbstractAction abstractAction = new AbstractAction(DatabaseMessages.message((String)"button.test.connection", (Object[])new Object[0])){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceConfigurable$3", "actionPerformed"));
                }
                DataSourceConfigurable.this.testConnection();
            }
        };
        if (abstractAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceConfigurable", "createTestAction"));
        }
        return abstractAction;
    }

    public Action getTestAction() {
        return this.myTestAction;
    }

    public void actualizeDriver() {
        this.setDriver(this.myGeneralPanel.getDriver());
    }

    @Nullable
    public StatelessJdbcUrlParser getActiveParser() {
        return this.myGeneralPanel.getUrlEditorModel().getMeaningfullParser();
    }
}

