/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceOptionsEditor;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DefaultsInstaller;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.dialects.MysqlDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.dbm.generic.meta.DatabaseMetaDataWrapper;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.HintHint;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.UI;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceOptionsPanel {
    private static final String SCHEMA_LOADING_ERROR = "SCHEMA_LOADING_ERROR";
    private static final String ASTERISK = "*";
    private final DataSourceConfigurable myDialog;
    private JPanel myRootPanel;
    private JPanel myTablePanel;
    private JBCheckBox myLegacyIntrospector;
    private JEditorPane myObjectFilterHelp;
    private RawCommandLineEditor myObjectFilterField;
    private DataSourceOptionsEditor myOptionsPanel;
    private JPanel myOptionsPanelComponent;
    private JPanel myTableWrapper;
    private final TreeTable mySchemasTable;
    private final JBLoadingPanel myLoadingPanel;
    private final DefaultsInstaller myDefaultsInstaller;
    private Object mySavedKey;
    @NotNull
    private MultiMap<String, String> myAllSchemaNames;

    public DataSourceOptionsPanel(@NotNull DataSourceConfigurable dialog) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/dataSource/DataSourceOptionsPanel", "<init>"));
        }
        this.myAllSchemaNames = new MultiMap();
        this.myDialog = dialog;
        this.myOptionsPanel = new DataSourceOptionsEditor(dialog);
        this.myLoadingPanel = new JBLoadingPanel(new BorderLayout(), this.myDialog){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(size.width, size.height / 3 * 2);
            }
        };
        EventDispatcher myEventDispatcher = EventDispatcher.create(CheckboxTreeListener.class);
        final CheckboxTreeHelper helper = new CheckboxTreeHelper(CheckboxTreeHelper.DEFAULT_POLICY, myEventDispatcher);
        this.mySchemasTable = new TreeTableView(DataSourceOptionsPanel.emptyModel()){

            public void setModel(TreeTableModel treeTableModel) {
                super.setModel(treeTableModel);
                helper.initTree((Tree)this.getTree(), (JComponent)((Object)this), new CheckboxTreeBase.CheckboxTreeCellRendererBase(){

                    public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                        if (value instanceof CheckedTreeNode) {
                            ColoredTreeCellRenderer renderer = this.getTextRenderer();
                            renderer.append(value.toString());
                            this.getCheckbox().setSelected(((CheckedTreeNode)value).isChecked());
                            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)DataSourceOptionsPanel.this.mySchemasTable, (SimpleColoredComponent)renderer, (boolean)false, (boolean)selected);
                        }
                    }
                });
                this.getTree().setRootVisible(true);
            }
        };
        this.$$$setupUI$$$();
        this.myRootPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.mySchemasTable.setTableHeader(null);
        this.myLoadingPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.mySchemasTable));
        this.myLoadingPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)1, (int)1, (int)1));
        this.myTablePanel.add((Component)this.myLoadingPanel, "Center");
        LocalDataSource dataSource = (LocalDataSource)((Object)this.myDialog.getDataSource());
        this.myDefaultsInstaller = new DefaultsInstaller(dataSource);
        this.myObjectFilterField.setText(StringUtil.notNullize((String)dataSource.getTablePattern()));
        this.myObjectFilterHelp.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                RegExHelpPopup.createRegExLinkRunnable((Component)this.myRootPanel, null).run();
            }
        });
        this.myLegacyIntrospector.setVisible(DataSourceUiUtil.hasModernIntrospector(DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource)));
        this.myLegacyIntrospector.setSelected(dataSource.useLegacyIntrospector());
        this.myDefaultsInstaller.setIntrospectionScope(dataSource.getIntrospectionScope());
        this.myDefaultsInstaller.setDefaultSchemas(dataSource.getResolveScope());
        this.setupTableView();
        this.myTableWrapper.setBorder(IdeBorderFactory.createEmptyBorder((int)6, (int)0, (int)4, (int)0));
    }

    @NotNull
    private static ListTreeTableModelOnColumns emptyModel() {
        ListTreeTableModelOnColumns listTreeTableModelOnColumns = new ListTreeTableModelOnColumns(null, DataSourceOptionsPanel.getColumns());
        if (listTreeTableModelOnColumns == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "emptyModel"));
        }
        return listTreeTableModelOnColumns;
    }

    @NotNull
    private static ColumnInfo[] getColumns() {
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new TreeColumnInfo("Resolve Unqualified References")};
        if (columnInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getColumns"));
        }
        return columnInfoArray;
    }

    private void setupTableView() {
        new TreeTableSpeedSearch(this.mySchemasTable);
        boolean visible = !this.getNamespaces().isEmpty();
        this.mySchemasTable.setVisible(visible);
        this.mySchemasTable.setSelectionMode(0);
        this.mySchemasTable.setCellSelectionEnabled(true);
        this.mySchemasTable.getEmptyText().setText("");
        if (!visible) {
            return;
        }
        new UiNotifyConnector((Component)this.myRootPanel, new Activatable(){

            public void showNotify() {
                ApplicationManager.getApplication().invokeLater(() -> DataSourceOptionsPanel.this.refreshSchemas(DataSourceOptionsPanel.this.getTitle()), ModalityState.current());
            }

            public void hideNotify() {
            }
        });
    }

    @NotNull
    private String getTitle() {
        String string = StringUtil.join(this.getNamespaces(), kind -> StringUtil.capitalize((String)StringUtil.pluralize((String)DbPresentation.getPresentableName((ObjectKind)kind, (DatabaseDialect)this.getDialect()))), (String)" and ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getTitle"));
        }
        return string;
    }

    @NotNull
    private Set<ObjectKind> getNamespaces() {
        Set set = this.getDialect().getMetaModel().getNamespaces();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getNamespaces"));
        }
        return set;
    }

    @NotNull
    private DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect((RawConnectionConfig)this.myDialog.getDataSource()), (Object)GenericDialect.INSTANCE);
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getDialect"));
        }
        return databaseDialectEx;
    }

    public void refreshSchemas(String columnTitle) {
        boolean emptyProps;
        LocalDataSource tempDataSource = this.myDialog.getTempDataSourceForConnection();
        boolean bl = emptyProps = StringUtil.isEmptyOrSpaces((String)tempDataSource.getDriverClass()) || StringUtil.isEmptyOrSpaces((String)tempDataSource.getUrl());
        if (emptyProps) {
            this.mySchemasTable.setModel((TreeTableModel)DataSourceOptionsPanel.emptyModel());
            this.mySchemasTable.getEmptyText().setText("No " + columnTitle);
            return;
        }
        Object newSavedUrl = this.myDialog.createKey(tempDataSource);
        if (Comparing.equal((Object)this.mySavedKey, (Object)newSavedUrl)) {
            return;
        }
        this.mySchemasTable.getEmptyText().setText("");
        this.mySavedKey = newSavedUrl;
        Ref currentCatalogRef = Ref.create();
        ModalityState state = ModalityState.current();
        Project project = this.myDialog.getProject();
        this.myLoadingPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Connection connection;
            Ref exRef;
            block5: {
                exRef = Ref.create(null);
                connection = null;
                connection = tempDataSource.getConnection(project);
                if (connection != null) break block5;
                Runnable runnable = new Runnable(tempDataSource, exRef, columnTitle){
                    final /* synthetic */ LocalDataSource val$tempDataSource;
                    final /* synthetic */ Ref val$exRef;
                    final /* synthetic */ String val$columnTitle;
                    {
                        this.val$tempDataSource = localDataSource;
                        this.val$exRef = ref;
                        this.val$columnTitle = string;
                    }

                    @Override
                    public void run() {
                        if (Disposer.isDisposed((Disposable)DataSourceOptionsPanel.this.myDialog)) {
                            return;
                        }
                        if (!Comparing.equal((Object)DataSourceOptionsPanel.this.mySavedKey, (Object)DataSourceOptionsPanel.this.myDialog.createKey(this.val$tempDataSource))) {
                            return;
                        }
                        DataSourceOptionsPanel.this.myLoadingPanel.stopLoading();
                        Exception ex = this.val$exRef.get() instanceof ProcessCanceledException ? null : (Exception)this.val$exRef.get();
                        String emptyText = ex == null ? "No " + this.val$columnTitle + " Found" : "Error Loading " + this.val$columnTitle;
                        DataSourceOptionsPanel.this.mySchemasTable.getEmptyText().setText(emptyText);
                        if (this.val$tempDataSource.getFirstSync() == ThreeState.YES) {
                            this.val$tempDataSource.setFirstSync(ThreeState.NO);
                        }
                        DataSourceOptionsPanel.this.mySchemasTable.setModel(this.createModel((MultiMap<String, String>)DataSourceOptionsPanel.this.myAllSchemaNames));
                        if (ex != null) {
                            DataSourceOptionsPanel.this.myDialog.showErrorNotification(ex, DataSourceOptionsPanel.SCHEMA_LOADING_ERROR);
                        } else {
                            DataSourceOptionsPanel.this.myDialog.updateDatabaseInfo(this.val$tempDataSource);
                            DataSourceOptionsPanel.this.myDialog.showErrorNotification(null, DataSourceOptionsPanel.SCHEMA_LOADING_ERROR);
                        }
                    }

                    @NotNull
                    private TreeTableModel createModel(@NotNull MultiMap<String, String> schemas) {
                        if (schemas == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/database/dataSource/DataSourceOptionsPanel$4", "createModel"));
                        }
                        if (schemas.isEmpty()) {
                            ListTreeTableModelOnColumns listTreeTableModelOnColumns = DataSourceOptionsPanel.emptyModel();
                            if (listTreeTableModelOnColumns == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel$4", "createModel"));
                            }
                            return listTreeTableModelOnColumns;
                        }
                        boolean singleRoot = DataSourceOptionsPanel.this.getNamespaces().size() == 1;
                        boolean isMysql = DataSourceOptionsPanel.this.getDialect() == MysqlDialect.INSTANCE;
                        MyCheckedTreeNode root = new MyCheckedTreeNode((Couple<String>)Couple.of((Object)DataSourceOptionsPanel.ASTERISK, (Object)DataSourceOptionsPanel.ASTERISK));
                        for (Map.Entry e : schemas.entrySet()) {
                            String database = (String)e.getKey();
                            if (DataSourceOptionsPanel.ASTERISK.equals(database) && ((Collection)e.getValue()).size() == 1 && DataSourceOptionsPanel.ASTERISK.equals(ContainerUtil.getFirstItem((Collection)((Collection)e.getValue())))) continue;
                            MyCheckedTreeNode db = new MyCheckedTreeNode((Couple<String>)Couple.of((Object)database, (Object)DataSourceOptionsPanel.ASTERISK), true);
                            if (!singleRoot || this.realName(database) && isMysql) {
                                root.add((MutableTreeNode)((Object)db));
                            }
                            for (String schema : (Collection)e.getValue()) {
                                if (!this.realName(schema)) continue;
                                (singleRoot ? root : db).add((MutableTreeNode)((Object)new MyCheckedTreeNode((Couple<String>)Couple.of((Object)database, (Object)schema))));
                            }
                        }
                        ListTreeTableModelOnColumns listTreeTableModelOnColumns = new ListTreeTableModelOnColumns((TreeNode)((Object)root), DataSourceOptionsPanel.getColumns());
                        if (listTreeTableModelOnColumns == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel$4", "createModel"));
                        }
                        return listTreeTableModelOnColumns;
                    }

                    private boolean realName(@Nullable String name) {
                        return !StringUtil.isEmpty((String)name) && !DataSourceOptionsPanel.ASTERISK.equals(name);
                    }
                };
                if (!project.isOpen()) return;
                tempDataSource.releaseConnection(project, connection);
                ApplicationManager.getApplication().invokeLater(runnable, state);
                return;
            }
            try {
                this.myAllSchemaNames = this.loadSchemaNamesAndSetIntrospectionScopeByDefault(connection, (LocalDataSource)((Object)((Object)this.myDialog.getDataSource())));
                DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(tempDataSource);
                Case casing = dialect.getCasing(ObjectKind.SCHEMA, null).choose(true);
                this.myDefaultsInstaller.setupIntrospectionScopeByDefault(connection, casing.apply(this.myDialog.getUserName()));
                currentCatalogRef.set((Object)connection.getCatalog());
            }
            catch (Exception e) {
                try {
                    exRef.set((Object)e);
                }
                catch (Throwable throwable) {
                    Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                    if (!project.isOpen()) throw throwable;
                    tempDataSource.releaseConnection(project, connection);
                    ApplicationManager.getApplication().invokeLater(runnable, state);
                    throw throwable;
                }
                Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                if (!project.isOpen()) return;
                tempDataSource.releaseConnection(project, connection);
                ApplicationManager.getApplication().invokeLater(runnable, state);
                return;
            }
            Runnable runnable = new /* invalid duplicate definition of identical inner class */;
            if (!project.isOpen()) return;
            tempDataSource.releaseConnection(project, connection);
            ApplicationManager.getApplication().invokeLater(runnable, state);
            return;
        });
    }

    @NotNull
    public MultiMap<String, String> loadSchemaNamesAndSetIntrospectionScopeByDefault(@NotNull Connection connection, @NotNull LocalDataSource dataSource) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DataSourceOptionsPanel", "loadSchemaNamesAndSetIntrospectionScopeByDefault"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceOptionsPanel", "loadSchemaNamesAndSetIntrospectionScopeByDefault"));
        }
        DatabaseMetaData metaData = connection.getMetaData();
        dataSource.refreshDatabaseInfo(metaData);
        MultiMap result = MultiMap.createLinkedSet();
        DatabaseMetaDataWrapper meta = new DatabaseMetaDataWrapper(connection, metaData, new ErrorHandler(), DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource));
        for (DatabaseMetaDataWrapper.Schema schema : JBIterable.once(meta.schemas(true))) {
            result.putValue((Object)StringUtil.notNullize((String)schema.database), (Object)StringUtil.notNullize((String)schema.schema));
        }
        for (String d : result.keySet()) {
            result.putValue((Object)d, (Object)ASTERISK);
        }
        result.putValue((Object)ASTERISK, (Object)ASTERISK);
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "loadSchemaNamesAndSetIntrospectionScopeByDefault"));
        }
        return multiMap;
    }

    public JPanel getComponent() {
        return this.myRootPanel;
    }

    public void saveData(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceOptionsPanel", "saveData"));
        }
        dataSource.setResolveScope(this.myDefaultsInstaller.getDefaultSchemas());
        dataSource.setTablePattern(StringUtil.nullize((String)this.myObjectFilterField.getText()));
        dataSource.setUseLegacyIntrospector(this.myLegacyIntrospector.isSelected());
        this.myOptionsPanel.saveData(dataSource);
    }

    public void reset(LocalDataSource source) {
        this.myOptionsPanel.reset(source);
    }

    private void createUIComponents() {
        this.myObjectFilterField = new RawCommandLineEditor(s -> JBIterable.of((Object[])s.split("\\|\\|")).transform(StringUtil.TRIMMER).toList(), strings -> StringUtil.join((Iterable)JBIterable.from((Iterable)strings).transform(StringUtil.TRIMMER), (String)"||"));
        this.myObjectFilterField.setDialogCaption("Object Filter");
        this.myObjectFilterHelp = IdeTooltipManager.initPane((String)"", (HintHint)new HintHint(), null);
        this.myObjectFilterHelp.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)this.myObjectFilterHelp);
        this.myObjectFilterHelp.setBorder(null);
        this.myObjectFilterHelp.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        StyleSheet sheet = ((HTMLDocument)this.myObjectFilterHelp.getDocument()).getStyleSheet();
        sheet.addRule("a { color: #" + ColorUtil.toHex((Color)UI.getColor((String)"link.foreground")) + " }");
        sheet.addRule("ol { margin: 0px; padding-left: 10px; padding-bottom: 4px; list-style-type:none; }");
        sheet.addRule(UIUtil.displayPropertiesToCSS((Font)JBUI.Fonts.smallFont(), (Color)UIUtil.getLabelDisabledForeground()));
        this.myObjectFilterHelp.setText("<html>A &lt;pattern&gt; or a list of &lt;type&gt;:[-]&lt;pattern&gt; separated by ||. Where:<ol>  <li>&lt;type&gt; is a <b>table</b>, <b>view</b>, <b>mview</b>, <b>sequence</b>, <b>routine</b>, <b>package</b> or <b>synonym</b>,</li>  <li>&lt;pattern&gt is a <a href=\"#help\">regular expression</a>; prepend with - (minus) for exclusion.</li></ol>Examples: <b>table:CUR_.*</b> or <b>table:-OLD_.*||routine:DO.*||view:V_.*</b></html>");
        this.myObjectFilterHelp.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)4, (int)4, (int)4));
        this.myOptionsPanelComponent = this.myOptionsPanel.getComponent();
    }

    @Nullable
    private static Couple<String> databaseAndSchema(@NotNull DefaultMutableTreeNode o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/dataSource/DataSourceOptionsPanel", "databaseAndSchema"));
        }
        return (Couple)ObjectUtils.tryCast((Object)o.getUserObject(), Couple.class);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JEditorPane jEditorPane = this.myObjectFilterHelp;
        jPanel4.add((Component)jEditorPane, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, null, new Dimension(150, 50), null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Object filter:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myObjectFilterField;
        jPanel4.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = this.myOptionsPanelComponent;
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myTableWrapper = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Resolve unqualified references:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLegacyIntrospector = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Introspect using JDBC metadata");
        jBCheckBox.setMnemonic('M');
        jBCheckBox.setDisplayedMnemonicIndex(22);
        jPanel3.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        jBLabel.setLabelFor((Component)rawCommandLineEditor);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class MyCheckedTreeNode
    extends CheckedTreeNode {
        private final boolean myDb;

        public MyCheckedTreeNode(Couple<String> s) {
            this(s, false);
        }

        public MyCheckedTreeNode(Couple<String> s, boolean db) {
            super(s);
            this.myDb = db;
        }

        public boolean isChecked() {
            return DataSourceOptionsPanel.this.myDefaultsInstaller.getDefaultSchemas().containsSchema((Couple<String>)DataSourceOptionsPanel.databaseAndSchema((DefaultMutableTreeNode)((Object)this)));
        }

        public void setChecked(boolean checked) {
            Couple couple = DataSourceOptionsPanel.databaseAndSchema((DefaultMutableTreeNode)((Object)this));
            if (couple == null) {
                return;
            }
            String first = (String)couple.first;
            String second = (String)couple.second;
            MultiMap<String, String> map = DataSourceOptionsPanel.this.myDefaultsInstaller.getDefaultSchemas().applyToContext((MultiMap<String, String>)DataSourceOptionsPanel.this.myAllSchemaNames);
            if (checked) {
                map.putValue((Object)first, (Object)second);
            } else {
                map.remove((Object)first, (Object)second);
                map.remove((Object)first, (Object)DataSourceOptionsPanel.ASTERISK);
                map.remove((Object)DataSourceOptionsPanel.ASTERISK, (Object)DataSourceOptionsPanel.ASTERISK);
            }
            DataSourceOptionsPanel.this.myDefaultsInstaller.setDefaultSchemas(IntrospectionScopes.collapse(map));
        }

        public String toString() {
            Couple t = (Couple)ObjectUtils.tryCast((Object)this.getUserObject(), Couple.class);
            return t == null ? super.toString() : (this.myDb ? (String)t.first : (String)t.second);
        }
    }
}

