/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseObject;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class DatabaseFieldBase<T extends DasObject>
extends DatabaseObject
implements DasTypedObject {
    protected T myParent;
    protected String myName;
    protected DataType myDataType;
    protected boolean myNullable;
    protected String myDefault;
    protected String myComment;
    protected short myPosition;

    public DatabaseFieldBase(String name, @NotNull DataType dataType, boolean nullable, T parent) {
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/dataSource/DatabaseFieldBase", "<init>"));
        }
        this.myName = DbUtil.intern((String)name);
        this.myDataType = dataType;
        this.myNullable = nullable;
        this.myParent = parent;
    }

    public DatabaseFieldBase(String name, String sqlType, int jdbcType, int precision, int scale, boolean nullable, T parent) {
        this(name, DataTypeFactory.of(null, DbUtil.intern((String)sqlType), precision, scale, null, null, false, false, jdbcType), nullable, parent);
    }

    public DatabaseFieldBase(String name, @Nullable DasTypedObject typeInfo, T parent) {
        this(name, typeInfo != null ? typeInfo.getDataType() : DataType.UNKNOWN, typeInfo == null || !typeInfo.isNotNull(), parent);
    }

    public short getPosition() {
        return this.myPosition;
    }

    public void setPosition(short position) {
        this.myPosition = position;
    }

    @NotNull
    public String getDisplayOrder() {
        String string = String.valueOf(this.getPosition());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseFieldBase", "getDisplayOrder"));
        }
        return string;
    }

    @NotNull
    public DataType getDataType() {
        DataType dataType = this.myDataType;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseFieldBase", "getDataType"));
        }
        return dataType;
    }

    @Nullable
    public DasUserDefinedType getCustomType() {
        return null;
    }

    public boolean isNotNull() {
        return !this.myNullable;
    }

    @NotNull
    public String getName() {
        String string = (String)ObjectUtils.notNull((Object)this.myName, (Object)DasUtil.NO_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseFieldBase", "getName"));
        }
        return string;
    }

    @NotNull
    public String getSqlType() {
        String string = this.myDataType.typeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseFieldBase", "getSqlType"));
        }
        return string;
    }

    public int getJdbcType() {
        return this.myDataType.jdbcType;
    }

    public boolean isNullable() {
        return this.myNullable;
    }

    public int getLength() {
        return this.myDataType.getPrecision();
    }

    public int getPrecision() {
        return this.myDataType.getPrecision();
    }

    public int getScale() {
        return this.myDataType.getScale();
    }

    public String getDefault() {
        return this.myDefault;
    }

    public void setDefault(@Nullable String value) {
        this.myDefault = DbUtil.intern((String)value, null);
    }

    @Override
    public String getComment() {
        return this.myComment;
    }

    @Nullable
    public DasObject getDbParent() {
        return this.myParent;
    }

    public void setComment(String comment) {
        this.myComment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseFieldBase b = (DatabaseFieldBase)o;
        if (this.myDataType.jdbcType != b.myDataType.jdbcType) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(b.myName) : b.myName != null) {
            return false;
        }
        return this.myDataType.typeName.equals(b.myDataType.typeName);
    }

    public int hashCode() {
        int result = this.myParent != null ? this.myParent.hashCode() : 0;
        result = 31 * result + (this.myName != null ? this.myName.hashCode() : 0);
        result = 31 * result + this.myDataType.typeName.hashCode();
        result = 31 * result + this.myDataType.jdbcType;
        return result;
    }

    @NonNls
    @NotNull
    public abstract String toString();
}

