/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.google.common.collect.Iterables;
import com.intellij.database.dataSource.DatabaseKIFK;
import com.intellij.database.dataSource.DatabaseTableData;
import com.intellij.database.dataSource.DatabaseTableFieldData;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class DatabaseForeignKey
extends DatabaseKIFK
implements DasForeignKey {
    private String myRefTableName;
    private String myRefTableSchema;
    private String myRefTableCatalog;
    private String[] myRefColumnNames;
    private DasTable myRefTable;
    private DasColumn[] myRefColumns;
    private DasForeignKey.RuleAction myDeleteRule;
    private DasForeignKey.RuleAction myUpdateRule;
    private DasForeignKey.Deferrability myDeferrability;

    public DatabaseForeignKey(DasTable table) {
        super(table);
        this.myRefColumnNames = ArrayUtil.EMPTY_STRING_ARRAY;
        this.myRefColumns = EMPTY_ARRAY;
        this.myDeleteRule = DasForeignKey.RuleAction.NO_ACTION;
        this.myUpdateRule = DasForeignKey.RuleAction.NO_ACTION;
        this.myDeferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseForeignKey", "getKind"));
        }
        return objectKind;
    }

    public DatabaseForeignKey(DasTable table, @Nullable DasTable refTable) {
        super(table);
        this.myRefColumnNames = ArrayUtil.EMPTY_STRING_ARRAY;
        this.myRefColumns = EMPTY_ARRAY;
        this.myDeleteRule = DasForeignKey.RuleAction.NO_ACTION;
        this.myUpdateRule = DasForeignKey.RuleAction.NO_ACTION;
        this.myDeferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
        this.myRefTable = refTable;
        if (this.myRefTable != null) {
            this.myRefTableName = this.myRefTable.getName();
            this.myRefTableSchema = DasUtil.getSchema((DasObject)this.myRefTable);
            this.myRefTableCatalog = DasUtil.getCatalog((DasObject)this.myRefTable);
        }
    }

    public DatabaseForeignKey(String name, boolean unique, DasColumn[] columns, DasColumn[] refColumns) {
        super(name, unique, columns);
        this.myRefColumnNames = ArrayUtil.EMPTY_STRING_ARRAY;
        this.myRefColumns = EMPTY_ARRAY;
        this.myDeleteRule = DasForeignKey.RuleAction.NO_ACTION;
        this.myUpdateRule = DasForeignKey.RuleAction.NO_ACTION;
        this.myDeferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
        assert (refColumns.length > 0);
        this.myRefColumns = refColumns;
        this.myRefTable = refColumns[0].getTable();
        this.myRefTableName = this.myRefTable.getName();
        this.myRefTableSchema = DasUtil.getSchema((DasObject)this.myRefTable);
        this.myRefTableCatalog = DasUtil.getCatalog((DasObject)this.myRefTable);
        this.myRefColumnNames = new String[refColumns.length];
        int length = refColumns.length;
        for (int i = 0; i < length; ++i) {
            this.myRefColumnNames[i] = refColumns[i].getName();
            assert (this.myRefTable == refColumns[i].getTable());
        }
    }

    public DatabaseForeignKey(@NotNull DasTable table, @NotNull String name, @NotNull String[] columnNames, @Nullable String refCatalog, @Nullable String refSchema, @NotNull String refTableName, @NotNull String[] refColumnNames) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dataSource/DatabaseForeignKey", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseForeignKey", "<init>"));
        }
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/dataSource/DatabaseForeignKey", "<init>"));
        }
        if (refTableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refTableName", "com/intellij/database/dataSource/DatabaseForeignKey", "<init>"));
        }
        if (refColumnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refColumnNames", "com/intellij/database/dataSource/DatabaseForeignKey", "<init>"));
        }
        super(table);
        this.myRefColumnNames = ArrayUtil.EMPTY_STRING_ARRAY;
        this.myRefColumns = EMPTY_ARRAY;
        this.myDeleteRule = DasForeignKey.RuleAction.NO_ACTION;
        this.myUpdateRule = DasForeignKey.RuleAction.NO_ACTION;
        this.myDeferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
        this.setName(name);
        this.setColumnNames(Arrays.asList(columnNames));
        this.setRefCatalog(refCatalog);
        this.setRefSchema(refSchema);
        this.setRefTableName(refTableName);
        this.setRefColumnNames(Arrays.asList(refColumnNames));
    }

    public String getRefTableName() {
        return this.myRefTableName;
    }

    public void setRefTableName(String refName) {
        this.myRefTableName = refName;
    }

    public String getRefTableSchema() {
        return this.myRefTableSchema;
    }

    public void setRefSchema(String refSchema) {
        this.myRefTableSchema = refSchema;
    }

    public String getRefTableCatalog() {
        return this.myRefTableCatalog;
    }

    public void setRefCatalog(String refCatalog) {
        this.myRefTableCatalog = refCatalog;
    }

    public Iterable<String> getRefColumnNames() {
        return Arrays.asList(this.myRefColumnNames);
    }

    public void setRefColumnNames(Iterable<String> columnNames) {
        this.myRefColumnNames = (String[])Iterables.toArray(columnNames, String.class);
    }

    @Override
    public void resolveReferences(Collection<DatabaseTableData> tables) {
        super.resolveReferences(tables);
        this.myRefTable = QNameUtil.findElement(this.myRefTableName, this.myRefTableSchema, this.myRefTableCatalog, tables);
        this.myRefColumns = new DatabaseTableFieldData[this.myRefColumnNames.length];
        for (int i = 0; i < this.myRefColumnNames.length; ++i) {
            this.myRefColumns[i] = this.myRefTable == null ? null : (DasColumn)QNameUtil.findByName(this.myRefColumnNames[i], DasUtil.getColumns((DasObject)this.myRefTable));
        }
    }

    @Nullable
    public DasTable getRefTable() {
        return this.myRefTable;
    }

    @NotNull
    public MultiRef<? extends DasTypedObject> getRefColumns() {
        MultiRef<DasTypedObject> multiRef = DatabaseForeignKey.asRef(this.myRefColumnNames, this.myRefColumns);
        if (multiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseForeignKey", "getRefColumns"));
        }
        return multiRef;
    }

    public DasForeignKey.RuleAction getDeleteRule() {
        return this.myDeleteRule;
    }

    public DasForeignKey.RuleAction getUpdateRule() {
        return this.myUpdateRule;
    }

    public DasForeignKey.Deferrability getDeferrability() {
        return this.myDeferrability;
    }

    public void setUpdateRule(DasForeignKey.RuleAction rule) {
        this.myUpdateRule = rule;
    }

    public void setDeleteRule(DasForeignKey.RuleAction rule) {
        this.myDeleteRule = rule;
    }

    public void setDeferrability(DasForeignKey.Deferrability rule) {
        this.myDeferrability = rule;
    }
}

