/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.dbimport.AbstractTableFormatMapper;
import com.intellij.database.dbimport.ImportDatabaseTableEditorWrapper;
import com.intellij.database.dbimport.ImportDeTable;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportPanel;
import com.intellij.database.dbimport.ImportTablePreview;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportDialog
extends DialogWrapper
implements EditorModelBase.Listener,
DataGridListener {
    private static final String EMPTY_DATA = "No data for import";
    private static final String DIFFERENT_COLUMN_COUNT = "Number of columns in existing table is different from number of columns in data";
    private static final String EMPTY_NAME = "Name of the table is empty";
    private static final String TITLE = "Import: \"%s\" Format";
    private static final String TABLE_EXISTS = "Table with this name already exists";
    private final ImportPanel myPanel;
    private final DataGrid myGrid;
    private final ImportDatabaseTableEditorWrapper myEditor;
    private final Disposable myParent;
    private final List<DbTable> myContextTables;
    private Disposable myEditorListenerDisposable;
    private ValidationInfo myInfo;

    public ImportDialog(@Nullable Project project, @NotNull CsvFormatsSelectionUI formats, @NotNull ImportTablePreview preview, @NotNull ImportDatabaseTableEditorWrapper editor, @NotNull DatabaseDialect dialect, @NotNull DatabaseSystem system, @NotNull DeModel model, @NotNull String fileName, @NotNull DbElement element, @NotNull Disposable parent, @Nullable DeNamespace namespace) {
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        super(project);
        boolean isDasTable = element instanceof DasTable;
        this.myGrid = preview.getGrid();
        this.myParent = parent;
        this.myEditor = editor;
        this.myContextTables = ImportDialog.getContextTables(element, DatabaseView.getLowestSchema(element));
        this.myPanel = new ImportPanel(formats, preview, editor, dialect, system, fileName, isDasTable);
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        this.myEditorListenerDisposable = Disposer.newDisposable();
        this.setTitle(String.format(TITLE, fileName));
        ImportManager manager = ImportManager.of(dialect, system.getDatabaseProductVersion());
        AbstractTableFormatMapper.connect(preview, editor, formats, manager, model, this.getFirstFreeName(FileUtil.getNameWithoutExtension((String)fileName)), parent, namespace, isDasTable ? (DasTable)element : null);
        this.init();
        this.doInitValidation();
    }

    @NotNull
    private static List<DbTable> getContextTables(@NotNull DbElement element, @Nullable DbNamespaceImpl namespace) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dbimport/ImportDialog", "getContextTables"));
        }
        if (namespace == null || element instanceof DbTable) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getContextTables"));
            }
            return list;
        }
        List list = ((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)namespace)).filter(DbTable.class).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getContextTables"));
        }
        return list;
    }

    @Nullable
    public ImportInfo getImportInfo() throws IOException {
        return this.myPanel.getInfo();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myInfo;
    }

    protected int getErrorTextAlignment() {
        return 4;
    }

    protected boolean shouldAddErrorNearButtons() {
        return !ImportDialog.isMoveHelpButtonLeft();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void doInitValidation() {
        this.myGrid.addDataGridListener(this, this.myParent);
        this.myEditor.addEditorListener(this::tableEditorChanged);
        this.updateValidationInfo();
        this.initValidation();
    }

    private void tableEditorChanged(@Nullable DatabaseTableEditor old, @NotNull DatabaseTableEditor newEditor) {
        if (newEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEditor", "com/intellij/database/dbimport/ImportDialog", "tableEditorChanged"));
        }
        Disposer.dispose((Disposable)this.myEditorListenerDisposable);
        this.myEditorListenerDisposable = Disposer.newDisposable();
        newEditor.addListener(this, this.myEditorListenerDisposable);
        this.updateValidationInfo();
    }

    @Override
    public void changed() {
        this.updateValidationInfo();
    }

    @Override
    public void onSelectionChanged(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/dbimport/ImportDialog", "onSelectionChanged"));
        }
    }

    @Override
    public void onContentChanged(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/dbimport/ImportDialog", "onContentChanged"));
        }
        this.updateValidationInfo();
    }

    protected void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myEditorListenerDisposable);
    }

    @Nullable
    private ValidationInfo createValidationInfo() {
        boolean empty;
        DatabaseTableEditor editor = this.myEditor.getEditor();
        if (editor == null) {
            return null;
        }
        boolean bl = empty = this.myGrid.getVisibleColumns().size() == 0 || this.myGrid.getVisibleRows().size() == 0;
        if (empty) {
            return new ValidationInfo(EMPTY_DATA, this.myGrid.getComponent());
        }
        if (editor.getTableModel().getName().isEmpty()) {
            return new ValidationInfo(EMPTY_NAME, editor.getPreferredFocusedComponent());
        }
        if (this.tableExists(editor.getTable().name)) {
            return new ValidationInfo(TABLE_EXISTS, editor.getPreferredFocusedComponent());
        }
        if (!this.isColumnsCountTheSame()) {
            return new ValidationInfo(DIFFERENT_COLUMN_COUNT, this.myGrid.getComponent());
        }
        return null;
    }

    private String getFirstFreeName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/database/dbimport/ImportDialog", "getFirstFreeName"));
        }
        String result = fileName;
        int index = 1;
        while (this.tableExists(result)) {
            result = fileName + "_" + index++;
        }
        return result;
    }

    private boolean isColumnsCountTheSame() {
        DatabaseTableEditor editor = this.myEditor.getEditor();
        if (editor == null) {
            return true;
        }
        List deColumns = ContainerUtil.filter(editor.getTable().columns, ImportDeTable::isEnabled);
        return deColumns.size() == this.myGrid.getVisibleColumns().size();
    }

    private boolean tableExists(String name) {
        return ContainerUtil.exists(this.myContextTables, (Condition)DasUtil.byName((String)name));
    }

    private void updateValidationInfo() {
        this.myInfo = this.createValidationInfo();
    }
}

