/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.PersistentCsvFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.editor.TableFileEditor;
import com.intellij.database.vfs.fragment.CsvTableDataFragmentFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvTableFileEditor
extends TableFileEditor {
    private final DataGrid myDataGrid;

    public CsvTableFileEditor(@NotNull Project project, @NotNull CsvTableDataFragmentFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/CsvTableFileEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/CsvTableFileEditor", "<init>"));
        }
        super(project, file.getOriginalFile());
        this.myDataGrid = this.createDataGrid(GridDataHookUpManager.getInstance(project).getHookUp(file, (Disposable)this));
    }

    public CsvTableFileEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull CsvFormat format) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/CsvTableFileEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/CsvTableFileEditor", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/editor/CsvTableFileEditor", "<init>"));
        }
        super(project, file);
        this.myDataGrid = this.createDataGrid(GridDataHookUpManager.getInstance(project).getHookUp(file, format, (Disposable)this));
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/database/editor/CsvTableFileEditor", "getState"));
        }
        CsvDocumentDataHookUp hookup = this.getHookup();
        FileEditorState fileEditorState = level == FileEditorStateLevel.FULL && hookup.getRange() == null ? new State(hookup.getFormat()) : FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/CsvTableFileEditor", "getState"));
        }
        return fileEditorState;
    }

    @Override
    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/editor/CsvTableFileEditor", "setState"));
        }
        CsvFormat format = CsvTableFileEditor.readCsvFormat(state);
        if (format != null && !format.equals(this.getHookup().getFormat())) {
            this.setFormat(format);
        }
    }

    @Override
    @NotNull
    public DataGrid getDataGrid() {
        DataGrid dataGrid = this.myDataGrid;
        if (dataGrid == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/CsvTableFileEditor", "getDataGrid"));
        }
        return dataGrid;
    }

    public void setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/editor/CsvTableFileEditor", "setFormat"));
        }
        this.getHookup().setFormat(format);
    }

    @NotNull
    private CsvDocumentDataHookUp getHookup() {
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.myDataGrid.getDataHookup();
        if (csvDocumentDataHookUp == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/CsvTableFileEditor", "getHookup"));
        }
        return csvDocumentDataHookUp;
    }

    @Nullable
    static CsvFormat readCsvFormat(@Nullable FileEditorState state) {
        State csvState = (State)ObjectUtils.tryCast((Object)state, State.class);
        return csvState != null ? csvState.format.immutable() : null;
    }

    static class State
    implements FileEditorState {
        @Tag(value="format")
        public PersistentCsvFormat format;

        public State() {
        }

        public State(@NotNull CsvFormat format) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/editor/CsvTableFileEditor$State", "<init>"));
            }
            this.format = new PersistentCsvFormat(format);
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return false;
        }
    }
}

