/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.SchemaEditorHelper;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.UsageView;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.ConsumerRunnable;

public class DbRenamePsiElementProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance(DbRenamePsiElementProcessor.class);

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/DbRenamePsiElementProcessor", "canProcessElement"));
        }
        if (element instanceof DbElement) {
            DbElement dbElement = (DbElement)element;
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
            if (dbElement.getKind() == ObjectKind.VIEW) {
                return dialect.supportsRenameView();
            }
            if (dbElement.getKind() == ObjectKind.ROUTINE && ((DasRoutine)dbElement).getPackage() == null) {
                return dialect.supportsRenameRoutine();
            }
            DatabaseEditorCapabilities.DbEditorCaps caps = dialect.getSchemaEditor().getDbEditorCaps();
            DatabaseEditorCapabilities.ObjectEditorCaps modifyCaps = caps.getModifyCaps(dbElement.getKind());
            return modifyCaps != null && modifyCaps.getRename().isAvailable();
        }
        return false;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/psi/DbRenamePsiElementProcessor", "createRenameDialog"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/DbRenamePsiElementProcessor", "createRenameDialog"));
        }
        DbRenameDialog dbRenameDialog = new DbRenameDialog(project, element, nameSuggestionContext, editor);
        if (dbRenameDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbRenamePsiElementProcessor", "createRenameDialog"));
        }
        return dbRenameDialog;
    }

    public static String generateStatement(DdlBuilder baseBuilder, Object delegate, String newName) {
        Object object;
        if (!(delegate instanceof DasObject)) {
            return "";
        }
        DasObject dasObject = (DasObject)delegate;
        DasObject parent = dasObject.getDbParent();
        DatabaseEditorContext context = new DatabaseEditorContext(null, baseBuilder.getDialect(), DasUtil.emptyModel(), null, null);
        SchemaEditorHelper helper = new SchemaEditorHelper(context);
        SchemaExportHelper eh = helper.createExportHelper(DasUtil.emptyModel()).chained();
        if (parent instanceof DasTable) {
            eh.exportDeep(DasUtil.emptyModel(), parent, true);
        }
        if ((object = eh.exportDeep(DasUtil.emptyModel(), dasObject, true)) == null) {
            return "";
        }
        ((DeObject)object).name = newName;
        helper.alter(((DeObject)object).model);
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(false).configureFrom(baseBuilder);
        helper.generate(builder, (DeModel)((DeObject)object).model.getModel());
        return DatabaseDialogsHelper.concatQueries(builder.getStatements());
    }

    @NotNull
    public static JBIterable<Pair<PsiElement, String>> collectRenameElements(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/psi/DbRenamePsiElementProcessor", "collectRenameElements"));
        }
        JBIterable jBIterable = DbRenamePsiElementProcessor.collectRenames(model).transform(object -> {
            PsiElement element = DbRenamePsiElementProcessor.getElementOfType(object, PsiElement.class);
            return element == null ? null : Pair.create((Object)element, (Object)object.name);
        }).filter(Condition.NOT_NULL);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbRenamePsiElementProcessor", "collectRenameElements"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DeObject> collectRenames(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/psi/DbRenamePsiElementProcessor", "collectRenames"));
        }
        JBIterable jBIterable = model.traverser().filter(DeObject.class).filter(object -> {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/psi/DbRenamePsiElementProcessor", "lambda$collectRenames$1"));
            }
            return object.editedObject != null && !DasUtil.nameEqual((DasObject)object, (String)object.editedObject.getName(), (CasingProvider)model);
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbRenamePsiElementProcessor", "collectRenames"));
        }
        return jBIterable;
    }

    @Nullable
    public static <T> T getElementOfType(@Nullable DasObject object, @NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/psi/DbRenamePsiElementProcessor", "getElementOfType"));
        }
        DasObject tmp = object;
        while (tmp != null && !clazz.isAssignableFrom(tmp.getClass())) {
            if (tmp instanceof DeObject) {
                tmp = ((DeObject)tmp).editedObject;
                continue;
            }
            if (!(tmp instanceof DbElement)) break;
            tmp = (DasObject)ObjectUtils.tryCast((Object)((DbElement)tmp).getDelegate(), DasObject.class);
        }
        return (T)ObjectUtils.tryCast((Object)tmp, clazz);
    }

    public static class MyRenameProcessor
    extends RenameProcessor {
        private final DatabaseRefactoringHandler myHandler;
        private boolean myExecuteSql;
        private VirtualFile myExcludedFile;

        public MyRenameProcessor(Project project, DatabaseRefactoringHandler handler, JBIterable<Pair<PsiElement, String>> renames, boolean isSearchInComments, boolean isSearchTextOccurrences) {
            this(project, MyRenameProcessor.getOptElement((Pair<PsiElement, String>)((Pair)renames.first())), handler, MyRenameProcessor.getOptName((Pair<PsiElement, String>)((Pair)renames.first())), (Iterable<Pair<PsiElement, String>>)renames.skip(1), isSearchInComments, isSearchTextOccurrences);
        }

        public MyRenameProcessor(Project project, PsiElement element, DatabaseRefactoringHandler handler, @NotNull @NonNls String newName, @Nullable Iterable<Pair<PsiElement, String>> secondaryRenames, boolean isSearchInComments, boolean isSearchTextOccurrences) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor", "<init>"));
            }
            super(project, element, newName, isSearchInComments, isSearchTextOccurrences);
            this.myExecuteSql = true;
            if (secondaryRenames != null) {
                for (Pair<PsiElement, String> rename : secondaryRenames) {
                    this.addElement((PsiElement)rename.first, (String)rename.second);
                }
            }
            this.myHandler = handler;
            DasObject object = (DasObject)ObjectUtils.tryCast((Object)element, DasObject.class);
            if (object != null) {
                this.myHandler.getContext().include(object.getDbParent());
            }
        }

        protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
            if (viewDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewDescriptor", "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor", "customizeUsagesView"));
            }
            if (usageView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor", "customizeUsagesView"));
            }
            super.customizeUsagesView(viewDescriptor, usageView);
            JPanel scriptPanel = new JPanel(new BorderLayout());
            scriptPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
            final JBCheckBox box = new JBCheckBox(UIUtil.replaceMnemonicAmpersand((String)"&Execute SQL Script"), this.myExecuteSql);
            box.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    myExecuteSql = box.isSelected();
                }
            });
            JButton manually = new JButton(new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)"&Open in Console")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (myExcludedFile == null) {
                        myExcludedFile = AbstractDbRefactoringDialog.appendToConsole(myHandler.getDataSource(), myHandler.getStatement(), false);
                    } else {
                        AbstractDbRefactoringDialog.appendToConsole(myHandler.getDataSource(), myHandler.getStatement(), myExcludedFile);
                    }
                    box.setSelected(false);
                }
            });
            scriptPanel.add((Component)box, "West");
            scriptPanel.add((Component)manually, "East");
            usageView.setAdditionalComponent((JComponent)scriptPanel);
        }

        protected void execute(final @NotNull UsageInfo[] usages) {
            if (usages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor", "execute"));
            }
            if (this.myExecuteSql) {
                this.myHandler.runStatements().done((Consumer)new ConsumerRunnable(){

                    public void run() {
                        MyRenameProcessor.super.execute(usages);
                    }
                });
            } else {
                super.execute(usages);
            }
        }

        @NotNull
        public UsageInfo[] findUsages() {
            JBIterable usages = JBIterable.of((Object[])super.findUsages());
            if (this.myExcludedFile != null) {
                usages = usages.filter(info -> !Comparing.equal((Object)info.getVirtualFile(), (Object)this.myExcludedFile));
            }
            List res = usages.toList();
            UsageInfo[] usageInfoArray = res.toArray(new UsageInfo[res.size()]);
            if (usageInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor", "findUsages"));
            }
            return usageInfoArray;
        }

        @Nullable
        private static PsiElement getOptElement(@Nullable Pair<PsiElement, String> p) {
            return p == null ? null : (PsiElement)p.first;
        }

        @NotNull
        private static String getOptName(@Nullable Pair<PsiElement, String> p) {
            String string = p == null ? "" : (String)p.second;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor", "getOptName"));
            }
            return string;
        }
    }

    public static class DbRenameDialog
    extends RenameDialog {
        private DdlPreview myDdlPreview;
        private DeObject myEdited;
        private DdlPreview.ModelTraverser myTraverser;

        public DbRenameDialog(@NotNull Project project, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog", "<init>"));
            }
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog", "<init>"));
            }
            super(project, psiElement, nameSuggestionContext, editor);
        }

        protected boolean areButtonsValid() {
            return true;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            PsiElement myElement = this.getPsiElement();
            if (myElement instanceof DbElement) {
                DbElement dbElement = (DbElement)myElement;
                PsiFile file = myElement.getContainingFile();
                DatabaseEditorContext context = new DatabaseEditorContext(dbElement.getDataSource(), file == null ? null : file.getVirtualFile());
                SchemaEditor editor = context.getDialect().getSchemaEditor();
                SchemaExportHelper eh = editor.createExportHelper(context, context.getModel()).chained();
                if (!eh.canExport((DasObject)dbElement)) {
                    LOG.warn("Can't export " + dbElement.getClass().getName());
                    return null;
                }
                this.myEdited = eh.exportDeep(context.getModel(), (DasObject)dbElement, true);
                this.myTraverser = new DdlPreview.ModelTraverser(this.myEdited.model);
                JPanel panel = new JPanel(new BorderLayout());
                this.myDdlPreview = new DdlPreview(context, DatabaseDialogsHelper.createAsyncProcessor(this.getProject(), "Fetching DDL", () -> this.myDdlPreview.updatePreview(this.myTraverser)));
                this.myDdlPreview.updatePreview(this.myTraverser);
                panel.add((Component)SeparatorFactory.createSeparator((String)UIUtil.replaceMnemonicAmpersand((String)"SQL &Script"), (JComponent)this.myDdlPreview.getComponent()), "North");
                panel.add((Component)this.myDdlPreview.getComponent(), "Center");
                return panel;
            }
            return null;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getCanonicalName();
        }

        protected void processNewNameChanged() {
            if (this.myEdited != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myEdited.name = this.getNewName();
                    this.myDdlPreview.updatePreview(this.myTraverser);
                });
            }
            super.processNewNameChanged();
        }

        protected RenameProcessor createRenameProcessor(String newName) {
            DatabaseRefactoringHandler handler = this.createHandler();
            return new MyRenameProcessor(this.getProject(), handler, DbRenamePsiElementProcessor.collectRenameElements(this.myEdited.model), this.isSearchInComments(), this.isSearchInNonJavaFiles());
        }

        private DatabaseRefactoringHandler createHandler() {
            DbElement element = (DbElement)this.getPsiElement();
            DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(element.getDataSource(), DasUtil.getNamespace((DasObject)element)).setStatement(this.myDdlPreview.getPreviewText());
            handler.getContext().include(element);
            return handler;
        }
    }
}

