/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractorScripts;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseExtractorAction
extends AlignedIconWithTextAction
implements DumbAware,
GridAction {
    public void update(AnActionEvent e) {
        Project project = ChooseExtractorAction.getEventProject((AnActionEvent)e);
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        boolean enabled = project != null && dataGrid != null;
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(enabled);
        if (enabled) {
            ChooseExtractorAction.updateText(ChooseExtractorAction.getCurrentExtractorName(project), presentation, "");
            presentation.setDisabledIcon(EmptyIcon.ICON_0);
            presentation.setIcon(EmptyIcon.ICON_0);
        }
    }

    @NotNull
    private static String getCurrentExtractorName(@Nullable Project project) {
        String string = DataExtractorProperties.getCurrentExtractorFactory(project).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseExtractorAction", "getCurrentExtractorName"));
        }
        return string;
    }

    private static void updateText(@NotNull String name, @NotNull Presentation presentation, @NotNull String prefix) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/run/actions/ChooseExtractorAction", "updateText"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/database/run/actions/ChooseExtractorAction", "updateText"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/database/run/actions/ChooseExtractorAction", "updateText"));
        }
        String adjusted = prefix.isEmpty() ? StringUtil.trimExtensions((String)name) : name;
        String newText = prefix + StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)adjusted, (int)12));
        presentation.setText(newText);
        Object c = presentation.getClientProperty("customComponent");
        if (c instanceof JComponent) {
            ((JComponent)c).setToolTipText(name);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = ChooseExtractorAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        final Presentation presentation = e.getPresentation();
        JComponent button = (JComponent)presentation.getClientProperty("customComponent");
        if (dataGrid == null) {
            return;
        }
        ChooserGroup actionGroup = new ChooserGroup(){

            @Override
            protected void extractorSelected(@NotNull Project project, @NotNull DataExtractorFactory factory) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/ChooseExtractorAction$1", "extractorSelected"));
                }
                if (factory == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/run/actions/ChooseExtractorAction$1", "extractorSelected"));
                }
                super.extractorSelected(project, factory);
                ChooseExtractorAction.updateText(factory.getName(), presentation, "");
            }
        };
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        if (button != null) {
            popup.showUnderneathOf((Component)button);
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    public static class ChooserGroup
    extends ActionGroup
    implements DumbAware {
        public void update(AnActionEvent e) {
            Project project = ChooserGroup.getEventProject((AnActionEvent)e);
            if (project == null) {
                return;
            }
            ChooseExtractorAction.updateText(ChooseExtractorAction.getCurrentExtractorName(project), e.getPresentation(), this.getTemplatePresentation().getText() + ": ");
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            final Project project = ChooserGroup.getEventProject((AnActionEvent)e);
            if (project == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup", "getChildren"));
                }
                return EMPTY_ARRAY;
            }
            AnAction[] anActionArray = ChooserGroup.getActions((Function<DataExtractorFactory, ? extends AnAction>)new Function<DataExtractorFactory, AnAction>(){
                private final String mySelectedName;
                private boolean mySelectionIsSet;
                {
                    this.mySelectedName = ChooseExtractorAction.getCurrentExtractorName(project);
                }

                public AnAction fun(DataExtractorFactory factory) {
                    String name = factory.getName();
                    boolean selected = !this.mySelectionIsSet && name.equals(this.mySelectedName);
                    this.mySelectionIsSet |= selected;
                    return new SelectExtractorFactoryAction(factory, selected);
                }
            });
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup", "getChildren"));
            }
            return anActionArray;
        }

        protected void extractorSelected(@NotNull Project project, @NotNull DataExtractorFactory factory) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup", "extractorSelected"));
            }
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup", "extractorSelected"));
            }
            DataExtractorProperties.setCurrentExtractorFactory(project, factory);
        }

        @NotNull
        public static AnAction[] getActions(@NotNull Function<DataExtractorFactory, ? extends AnAction> wrapExtractorToAction) {
            if (wrapExtractorToAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapExtractorToAction", "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup", "getActions"));
            }
            ArrayList actions = ContainerUtil.newArrayList();
            actions.addAll(ContainerUtil.mapNotNull(DataExtractorFactories.getLegacy(), wrapExtractorToAction));
            actions.add(Separator.getInstance());
            actions.addAll(ContainerUtil.mapNotNull(DataExtractorFactories.getCsvFormats(), wrapExtractorToAction));
            actions.add(Separator.getInstance());
            actions.addAll(ContainerUtil.mapNotNull(DataExtractorFactories.getScripts(), wrapExtractorToAction));
            actions.add(Separator.getInstance());
            actions.add(DataExtractorProperties.getTranspositionAllowedAction());
            actions.add(DataExtractorProperties.getSkipGeneratedColumnsAction());
            actions.add(DataExtractorProperties.getAddCreateTableAction());
            actions.add(DataExtractorProperties.getOverwriteExistingFilesAction());
            actions.add(Separator.getInstance());
            actions.add(ActionManager.getInstance().getAction("Console.TableResult.Copy.Csv.Settings"));
            actions.add(new GoToScriptsDirectoryAction());
            AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup", "getActions"));
            }
            return anActionArray;
        }

        private static class GoToScriptsDirectoryAction
        extends DumbAwareAction {
            public GoToScriptsDirectoryAction() {
                super("Go to Scripts Directory");
            }

            public void update(AnActionEvent e) {
                Project project = e.getProject();
                e.getPresentation().setEnabledAndVisible(project != null);
            }

            public void actionPerformed(AnActionEvent e) {
                Project project = e.getProject();
                VirtualFile scriptsDir = ExtractorScripts.getScriptsDirectory();
                assert (project != null && scriptsDir != null);
                new OpenFileDescriptor(project, scriptsDir).navigate(true);
            }
        }

        private class SelectExtractorFactoryAction
        extends ToggleAction
        implements DumbAware {
            private final DataExtractorFactory myExtractorFactory;
            private final boolean mySelected;

            private SelectExtractorFactoryAction(DataExtractorFactory factory, boolean selected) {
                if (factory == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup$SelectExtractorFactoryAction", "<init>"));
                }
                super(factory.getName());
                this.myExtractorFactory = factory;
                this.mySelected = selected;
            }

            public boolean isSelected(AnActionEvent e) {
                return this.mySelected;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Project project = e.getProject();
                if (project != null) {
                    ChooserGroup.this.extractorSelected(project, this.myExtractorFactory);
                }
            }
        }
    }
}

