/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.editor.DatabaseOpenFileDescriptor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataGridDocumentationProvider;
import com.intellij.database.util.DasUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigateAction
extends DumbAwareAction
implements GridAction {
    public NavigateAction() {
        super("Navigate to Data");
    }

    protected boolean hasKeysToNavigate(DbDataSource databaseSystem, DasTable table) {
        return DataGridDocumentationProvider.hasNavigatableKeys((DatabaseSystem)databaseSystem, table);
    }

    @NotNull
    protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
        EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.FOREIGN, DataGridDocumentationProvider.KeyType.EXPORTED, DataGridDocumentationProvider.KeyType.SELECTED);
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction", "getKeyTypes"));
        }
        return enumSet;
    }

    private List<DataGridDocumentationProvider.QueryInfo> getQueries(@NotNull DatabaseSystem dataSource, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/run/actions/NavigateAction", "getQueries"));
        }
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/run/actions/NavigateAction", "getQueries"));
        }
        if (selectedRow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRow", "com/intellij/database/run/actions/NavigateAction", "getQueries"));
        }
        EnumSet<DataGridDocumentationProvider.KeyType> types = this.getKeyTypes();
        List<DataGridDocumentationProvider.QueryInfo> queries = DataGridDocumentationProvider.buildQueries(dataSource, dataGrid, selectedRow, types);
        return queries.isEmpty() && types.remove((Object)DataGridDocumentationProvider.KeyType.SELECTED) ? DataGridDocumentationProvider.buildQueries(dataSource, dataGrid, selectedRow, types) : queries;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/NavigateAction", "update"));
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        DbDataSource dataSource = DataGridUtil.getDatabaseSystem(dataGrid);
        DasTable table = DataGridUtil.getDatabaseTable(dataGrid);
        boolean visible = e.getProject() != null && table != null && dataSource != null;
        boolean enabled = visible && dataGrid.getSelectionModel().getSelectedRowCount() == 1 && this.hasKeysToNavigate(dataSource, table);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/NavigateAction", "actionPerformed"));
        }
        Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        DbDataSource dataSource = DataGridUtil.getDatabaseSystem(dataGrid);
        if (dataGrid == null || dataSource == null || project == null) {
            return;
        }
        ModelIndex<DataConsumer.Row> selectedRow = dataGrid.getSelectionModel().getSelectedRow();
        if (!selectedRow.isValid(dataGrid) || dataGrid.getSelectionModel().getSelectedRowCount() != 1) {
            return;
        }
        List<DataGridDocumentationProvider.QueryInfo> queries = this.getQueries((DatabaseSystem)dataSource, dataGrid, selectedRow);
        final ArrayList descriptors = ContainerUtil.newArrayList();
        final int[] separatorIdx = new int[]{-1, 0};
        int preselectedIndex = 0;
        for (DataGridDocumentationProvider.QueryInfo info : queries) {
            VirtualFile file = DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(DatabaseElementVirtualFileImpl.getPath(project, (DatabaseSystem)dataSource, (DasObject)info.table, ObjectKind.TABLE));
            if (file == null) continue;
            int n = separatorIdx[1];
            separatorIdx[1] = n + 1;
            descriptors.add(n, new DatabaseOpenFileDescriptor(project, file, info.columnNames, info.values, false, info.keysAndColumns));
            if (!info.exported) continue;
            if (separatorIdx[0] < 0) {
                separatorIdx[0] = separatorIdx[1] - 1;
            }
            descriptors.add(new DatabaseOpenFileDescriptor(project, file, info.columnNames, info.values, true, info.keysAndColumns));
        }
        if (descriptors.size() == 1) {
            ((DatabaseOpenFileDescriptor)((Object)descriptors.get(0))).navigate(true);
        } else {
            BaseListPopupStep<DatabaseOpenFileDescriptor> step = new BaseListPopupStep<DatabaseOpenFileDescriptor>("Choose target", (List)descriptors){

                public PopupStep onChosen(DatabaseOpenFileDescriptor selectedValue, boolean finalChoice) {
                    selectedValue.navigate(true);
                    return FINAL_CHOICE;
                }

                @Nullable
                public ListSeparator getSeparatorAbove(DatabaseOpenFileDescriptor value) {
                    int idx = descriptors.indexOf((Object)value);
                    if (idx == separatorIdx[0]) {
                        return new ListSeparator("First Referencing Row");
                    }
                    if (idx == separatorIdx[1]) {
                        return new ListSeparator("Referencing Rows Only");
                    }
                    return super.getSeparatorAbove((Object)value);
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(DatabaseOpenFileDescriptor value) {
                    String string = value.getFile().getName() + ": " + value.getDescription();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$1", "getTextFor"));
                    }
                    return string;
                }
            };
            step.setDefaultOptionIndex(preselectedIndex);
            ColoredListCellRendererWrapper<DatabaseOpenFileDescriptor> wrapper = new ColoredListCellRendererWrapper<DatabaseOpenFileDescriptor>(){

                protected void doCustomize(JList list, DatabaseOpenFileDescriptor value, int index, boolean selected, boolean hasFocus) {
                    this.clear();
                    this.setIcon(DatabaseIcons.Table);
                    this.append(value.getFile().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.append(": ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.append(value.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            };
            ListPopupImpl popup = new ListPopupImpl((ListPopupStep)step, (ColoredListCellRendererWrapper)wrapper, descriptors){
                final /* synthetic */ ColoredListCellRendererWrapper val$wrapper;
                final /* synthetic */ List val$descriptors;
                {
                    this.val$wrapper = coloredListCellRendererWrapper;
                    this.val$descriptors = list;
                    super(arg0);
                }

                protected ListCellRenderer getListElementRenderer() {
                    return new PopupListElementRenderer(this){

                        protected JComponent createItemComponent() {
                            this.myTextLabel = new ErrorLabel();
                            return val$wrapper;
                        }

                        protected void customizeComponent(JList list, Object value, boolean isSelected) {
                            val$wrapper.getListCellRendererComponent(list, value, val$descriptors.indexOf(value), isSelected, true);
                        }
                    };
                }
            };
            ActionManager actionManager = ActionManager.getInstance();
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)actionManager.getAction("QuickJavaDoc"));
            if (StringUtil.isEmpty((String)shortcutText)) {
                popup.setAdText("Use " + shortcutText + " in table to quickly view related data for selected row");
            }
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    public static class ExportedAction
    extends NavigateAction {
        @Override
        protected boolean hasKeysToNavigate(DbDataSource dataSource, DasTable table) {
            return !dataSource.getModel().getExportedKeys(table).isEmpty();
        }

        @Override
        @NotNull
        protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
            EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.EXPORTED, DataGridDocumentationProvider.KeyType.SELECTED);
            if (enumSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$ExportedAction", "getKeyTypes"));
            }
            return enumSet;
        }
    }

    public static class ForeignAction
    extends NavigateAction {
        @Override
        protected boolean hasKeysToNavigate(DbDataSource dataSource, DasTable table) {
            return !DasUtil.getForeignKeys((DasTable)table).isEmpty();
        }

        @Override
        @NotNull
        protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
            EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.FOREIGN, DataGridDocumentationProvider.KeyType.SELECTED);
            if (enumSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$ForeignAction", "getKeyTypes"));
            }
            return enumSet;
        }
    }
}

