/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.actions.GridAction;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Blob;
import java.sql.Clob;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SaveLobAsAction
extends DeleteAction
implements DumbAware,
GridAction {
    public SaveLobAsAction() {
        super(null, null, null);
    }

    public void update(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid == null) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setVisible(ActionPlaces.isToolbarPlace((String)e.getPlace()));
            return;
        }
        Object cellObject = dataGrid.getDataModel().getValueAt(dataGrid.getSelectionModel().getSelectedRow(), dataGrid.getSelectionModel().getSelectedColumn());
        boolean enabled = dataGrid.isReady() && (cellObject instanceof LobInfo && ((LobInfo)cellObject).length >= 0L || cellObject instanceof byte[] && ((byte[])cellObject).length > 0 || cellObject instanceof ObjectFormatter.ImageInfo && ((ObjectFormatter.ImageInfo)cellObject).bytes != null || cellObject instanceof ObjectFormatter.TextInfo || cellObject instanceof String && ((String)cellObject).length() > 64);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || ActionPlaces.isToolbarPlace((String)e.getPlace()));
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (project == null || dataGrid == null) {
            return;
        }
        ModelIndex rowIndex = dataGrid.getSelectionModel().getSelectedRow();
        ModelIndex colIndex = dataGrid.getSelectionModel().getSelectedColumn();
        if (!rowIndex.isValid(dataGrid) || !colIndex.isValid(dataGrid)) {
            return;
        }
        Object cellObject = dataGrid.getDataModel().getValueAt(rowIndex, colIndex);
        if (cellObject == null) {
            return;
        }
        final DataConsumer.Row originalRow = (DataConsumer.Row)dataGrid.getDataModel().getRow(rowIndex);
        final DataConsumer.Column column = (DataConsumer.Column)dataGrid.getDataModel().getColumn(colIndex);
        if (originalRow == null || column == null) {
            return;
        }
        final VirtualFileWrapper wrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save Data As...", "Save data in a local file.", new String[0]), project).save(null, null);
        if (wrapper == null) {
            return;
        }
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(dataGrid);
        if (hookup == null) {
            return;
        }
        DataRequest.Constraints constraints = new DataRequest.Constraints(originalRow.rowNum, 1, true, null, hookup.getResultSetIndex(), ContainerUtil.emptyList());
        hookup.getMessageBus().getDataProducer().processRequest(new DataRequest.RawQueryRequest(hookup, hookup.getCurrentTx(), hookup.getQueryText(), constraints){

            @Override
            public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/actions/SaveLobAsAction$1", "addRows"));
                }
                if (!rows.isEmpty()) {
                    SaveLobAsAction.saveObject(rows.get(0), column, wrapper, originalRow, project);
                }
            }
        });
    }

    private static void saveObject(final DataConsumer.Row row, final DataConsumer.Column column, final VirtualFileWrapper wrapper, DataConsumer.Row originalRow, Project project) {
        if (row.values.length < column.columnNum) {
            Notifications.Bus.notify((Notification)new Notification("Save LOB", "Cannot save LOB data", "Table structure has been changed.", NotificationType.ERROR));
            return;
        }
        final AsyncFutureResult result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        ApplicationManager.getApplication().invokeLater(() -> ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Saving LOB Data", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/run/actions/SaveLobAsAction$2", "run"));
                }
                boolean exists = wrapper.exists();
                try {
                    indicator.setText("Saving " + wrapper.getFile().getPath() + "...");
                    SaveLobAsAction.saveObjectInner(column.getValue(row), wrapper, indicator);
                }
                catch (ProcessCanceledException ex) {
                    if (!exists) {
                        wrapper.getFile().delete();
                    }
                    throw ex;
                }
                finally {
                    result.set((Object)true);
                }
            }

            public boolean shouldStartInBackground() {
                return false;
            }
        }));
        try {
            result.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveObjectInner(Object value, VirtualFileWrapper wrapper, ProgressIndicator indicator) {
        block31: {
            indicator.setIndeterminate(true);
            File file = wrapper.getFile();
            FileUtil.createParentDirs((File)file);
            OutputStream stream = null;
            try {
                stream = new BufferedOutputStream(new FileOutputStream(file));
                if (value instanceof byte[]) {
                    byte[] bytes = (byte[])value;
                    stream.write(bytes);
                    indicator.setText2(ExtractorsUtil.getPresentableSize(bytes.length) + " bytes (100%) written");
                    break block31;
                }
                if (value instanceof String) {
                    String string = (String)value;
                    OutputStreamWriter writer = new OutputStreamWriter(stream);
                    writer.write(string);
                    writer.close();
                    indicator.setText2(ExtractorsUtil.getPresentableSize(string.length()) + " chars (100%) written");
                    break block31;
                }
                if (value instanceof Clob) {
                    Clob lob = (Clob)value;
                    try {
                        OutputStreamWriter out = new OutputStreamWriter(stream);
                        long length = lob.length();
                        if (length > 0L) {
                            indicator.setIndeterminate(false);
                        }
                        int total = 0;
                        while (true) {
                            indicator.checkCanceled();
                            if (length > 0L) {
                                double fraction = (double)total / (double)length;
                                indicator.setFraction(fraction);
                                indicator.setText2(ExtractorsUtil.getPresentableSize(total) + " of " + ExtractorsUtil.getPresentableSize(length) + " chars (" + (int)(100.0 * fraction) + "%) written");
                            } else {
                                indicator.setText2(ExtractorsUtil.getPresentableSize(total) + " chars written");
                            }
                            String string = lob.getSubString(total + 1, length < 0L ? 20480 : Math.min((int)(length - (long)total), 20480));
                            if (string.length() == 0) break;
                            out.write(string);
                            total += string.length();
                        }
                        out.close();
                        break block31;
                    }
                    finally {
                        LobInfo.freeLob((Clob)lob);
                    }
                }
                if (!(value instanceof Blob)) break block31;
                Blob lob = (Blob)value;
                try {
                    long length = lob.length();
                    if (length > 0L) {
                        indicator.setIndeterminate(false);
                        indicator.setText("Saving " + file.getPath() + "...");
                    }
                    int total = 0;
                    while (true) {
                        int nextLength;
                        indicator.checkCanceled();
                        if (length > 0L) {
                            double fraction = (double)total / (double)length;
                            indicator.setFraction(fraction);
                            indicator.setText2(ExtractorsUtil.getPresentableSize(total) + " of " + ExtractorsUtil.getPresentableSize(length) + " bytes (" + (int)(100.0 * fraction) + "%) written");
                        } else {
                            indicator.setText2(ExtractorsUtil.getPresentableSize(total) + " bytes written");
                        }
                        int n = nextLength = length < 0L ? 20480 : Math.min((int)(length - (long)total), 20480);
                        if (nextLength == 0) {
                            break;
                        }
                        byte[] bytes = lob.getBytes(total + 1, nextLength);
                        if (bytes.length == 0) {
                            break;
                        }
                        stream.write(bytes);
                        total += bytes.length;
                    }
                }
                finally {
                    LobInfo.freeLob((Blob)lob);
                }
            }
            catch (Exception ex) {
                Notifications.Bus.notify((Notification)new Notification("Save LOB", "Cannot save LOB data", ExceptionUtil.getUserStackTrace((Throwable)ex, (Logger)DataSourceUiUtil.LOG).replace("\n", "<br>\n"), NotificationType.ERROR));
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

