/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.concurrency.SameThreadExecutor;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.CountRowsAction;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntHashSet;
import java.awt.Component;
import java.awt.Image;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridDocumentationProvider
extends AbstractDocumentationProvider
implements ExternalDocumentationHandler {
    private static final String URL_PREFIX = "db-doc://";
    private static final String VIEW_MODE_PROPERTY = "DataGrid.QuickDoc.View";
    private static final Key<State> GRID_HINT_STATE_KEY = Key.create((String)"GRID_HINT_STATE_KEY");
    private static final Key<Map<String, Image>> IMAGE_MAP_KEY = Key.create((String)"IMAGE_MAP_KEY");
    private static final AtomicLong ourImageCounter = new AtomicLong();

    public static String buildAndRunQueries(@NotNull DataGrid dataGrid, CharSequence initialValue) {
        boolean noRelationships;
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/run/ui/DataGridDocumentationProvider", "buildAndRunQueries"));
        }
        DasTable databaseTable = DataGridUtil.getDatabaseTable(dataGrid);
        DbDataSource databaseSystem = DataGridUtil.getDatabaseSystem(dataGrid);
        if (databaseSystem == null || databaseTable == null) {
            return null;
        }
        ModelIndex<DataConsumer.Row> selectedRow = dataGrid.getSelectionModel().getSelectedRow();
        boolean badSelection = !selectedRow.isValid(dataGrid) || dataGrid.getSelectionModel().getSelectedRowCount() != 1;
        boolean bl = noRelationships = !DataGridDocumentationProvider.hasNavigatableKeys((DatabaseSystem)databaseSystem, databaseTable);
        if (badSelection || noRelationships) {
            dataGrid.putUserData(GRID_HINT_STATE_KEY, null);
            return null;
        }
        State state = (State)dataGrid.getUserData(GRID_HINT_STATE_KEY);
        List<QueryInfo> newQueries = DataGridDocumentationProvider.buildQueries((DatabaseSystem)databaseSystem, dataGrid, selectedRow, EnumSet.of(KeyType.FOREIGN, KeyType.EXPORTED));
        if (state != null && state.queries.equals(newQueries) && selectedRow.equals(state.row)) {
            return state.current;
        }
        state = new State(newQueries, selectedRow, null);
        dataGrid.putUserData(GRID_HINT_STATE_KEY, state);
        DataGridDocumentationProvider.runQueries(dataGrid, state, initialValue.toString());
        return null;
    }

    public static boolean hasNavigatableKeys(@NotNull DatabaseSystem databaseSystem, @NotNull DasTable databaseTable) {
        if (databaseSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseSystem", "com/intellij/database/run/ui/DataGridDocumentationProvider", "hasNavigatableKeys"));
        }
        if (databaseTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/run/ui/DataGridDocumentationProvider", "hasNavigatableKeys"));
        }
        return !Iterables.isEmpty((Iterable)databaseSystem.getModel().getExportedKeys(databaseTable)) || !Iterables.isEmpty((Iterable)DasUtil.getForeignKeys((DasTable)databaseTable));
    }

    public static List<QueryInfo> buildQueries(@NotNull DatabaseSystem databaseSystem, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull EnumSet<KeyType> keyTypes) {
        if (databaseSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseSystem", "com/intellij/database/run/ui/DataGridDocumentationProvider", "buildQueries"));
        }
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/run/ui/DataGridDocumentationProvider", "buildQueries"));
        }
        if (selectedRow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRow", "com/intellij/database/run/ui/DataGridDocumentationProvider", "buildQueries"));
        }
        if (keyTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyTypes", "com/intellij/database/run/ui/DataGridDocumentationProvider", "buildQueries"));
        }
        TIntHashSet selectedColumnIndices = new TIntHashSet((keyTypes.contains((Object)KeyType.SELECTED) ? dataGrid.getSelectionModel().getSelectedColumns() : dataGrid.getDataModel().getColumnIndices()).asArray());
        DasTable databaseTable = DataGridUtil.getDatabaseTable(dataGrid);
        LinkedHashMap queries = ContainerUtil.newLinkedHashMap();
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(dataGrid);
        if (keyTypes.contains((Object)KeyType.FOREIGN)) {
            DataGridDocumentationProvider.collectForeignKeyQueries(queries, databaseTable, dialect, dataGrid, selectedRow, selectedColumnIndices);
        }
        if (keyTypes.contains((Object)KeyType.EXPORTED)) {
            DataGridDocumentationProvider.collectExportedKeyQueries(queries, databaseSystem, databaseTable, dialect, dataGrid, selectedRow, selectedColumnIndices);
        }
        return ContainerUtil.newArrayList(queries.values());
    }

    private static void collectForeignKeyQueries(@NotNull Map<String, QueryInfo> queries, @NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns) {
        if (queries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectForeignKeyQueries"));
        }
        if (databaseTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectForeignKeyQueries"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectForeignKeyQueries"));
        }
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectForeignKeyQueries"));
        }
        if (selectedRow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRow", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectForeignKeyQueries"));
        }
        if (selectedColumns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedColumns", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectForeignKeyQueries"));
        }
        ArrayList values = ContainerUtil.newArrayList();
        for (DasForeignKey key : DasUtil.getForeignKeys((DasTable)databaseTable)) {
            DasTable table = key.getRefTable();
            if (table == null || !DataGridDocumentationProvider.tryCollectValues(dataGrid, selectedRow, selectedColumns, values, key.getColumnsRef().names())) continue;
            Iterable refColumns = key.getRefColumns().names();
            String query = DbImplUtil.createSelectAllQuery(table, dialect, 2, refColumns, values).getStatement();
            DataGridDocumentationProvider.collectQuery(queries, new QueryInfo(query, table, false, (String[])Iterables.toArray((Iterable)refColumns, String.class), values.toArray()), (DasConstraint)key);
        }
    }

    private static void collectExportedKeyQueries(@NotNull Map<String, QueryInfo> queries, final @NotNull DatabaseSystem databaseSystem, final @NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns) {
        if (queries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectExportedKeyQueries"));
        }
        if (databaseSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseSystem", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectExportedKeyQueries"));
        }
        if (databaseTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectExportedKeyQueries"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectExportedKeyQueries"));
        }
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectExportedKeyQueries"));
        }
        if (selectedRow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRow", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectExportedKeyQueries"));
        }
        if (selectedColumns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedColumns", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectExportedKeyQueries"));
        }
        JBIterable referencingKeys = databaseSystem.getModel().getExportedKeys(databaseTable).transform((Function)new Function<DasConstraint, DasTable>(){

            public DasTable fun(DasConstraint constraint) {
                DasTable table = QNameUtil.findTable(databaseSystem, constraint.getTableName(), DasUtil.getSchema((DasObject)databaseTable), DasUtil.getCatalog((DasObject)databaseTable));
                return table != null && table.getName() != DasUtil.NO_NAME ? table : null;
            }
        }).filter(Condition.NOT_NULL).flatten(table -> DasUtil.getForeignKeys((DasTable)table)).filter(key -> {
            if (databaseTable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/run/ui/DataGridDocumentationProvider", "lambda$collectExportedKeyQueries$1"));
            }
            return key.getRefTable() == databaseTable;
        });
        ArrayList values = ContainerUtil.newArrayList();
        for (DasForeignKey key2 : referencingKeys) {
            if (!DataGridDocumentationProvider.tryCollectValues(dataGrid, selectedRow, selectedColumns, values, key2.getRefColumns().names())) continue;
            DasTable table2 = key2.getTable();
            Iterable columnsRef = key2.getColumnsRef().names();
            String query = DbImplUtil.createSelectAllQuery(table2, dialect, 1, columnsRef, values).getStatement();
            DataGridDocumentationProvider.collectQuery(queries, new QueryInfo(query, table2, true, (String[])Iterables.toArray((Iterable)columnsRef, String.class), values.toArray()), (DasConstraint)key2);
        }
    }

    private static void collectQuery(@NotNull Map<String, QueryInfo> queries, @NotNull QueryInfo newQueryInfo, @NotNull DasConstraint key) {
        if (queries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectQuery"));
        }
        if (newQueryInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newQueryInfo", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectQuery"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/run/ui/DataGridDocumentationProvider", "collectQuery"));
        }
        String query = newQueryInfo.query;
        QueryInfo info = queries.get(query);
        if (info == null) {
            info = newQueryInfo;
            queries.put(query, info);
        } else {
            info.keysAndColumns = info.keysAndColumns + "<br>";
        }
        info.keysAndColumns = info.keysAndColumns + key.getName() + "(" + StringUtil.join((Iterable)key.getColumnsRef().names(), (String)", ") + ")";
    }

    protected static boolean tryCollectValues(@NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns, @NotNull List<Object> values, @NotNull Iterable<String> columnNames) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/run/ui/DataGridDocumentationProvider", "tryCollectValues"));
        }
        if (selectedRow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRow", "com/intellij/database/run/ui/DataGridDocumentationProvider", "tryCollectValues"));
        }
        if (selectedColumns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedColumns", "com/intellij/database/run/ui/DataGridDocumentationProvider", "tryCollectValues"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/run/ui/DataGridDocumentationProvider", "tryCollectValues"));
        }
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/run/ui/DataGridDocumentationProvider", "tryCollectValues"));
        }
        values.clear();
        boolean noIndexColumnSelected = JBIterable.from(columnNames).filter(columnName -> {
            if (dataGrid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/run/ui/DataGridDocumentationProvider", "lambda$tryCollectValues$2"));
            }
            if (selectedColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedColumns", "com/intellij/database/run/ui/DataGridDocumentationProvider", "lambda$tryCollectValues$2"));
            }
            ModelIndex<DataConsumer.Column> c = DataGridUtil.findColumn(dataGrid, columnName);
            return c.isValid(dataGrid) && selectedColumns.contains(c.asInteger());
        }).isEmpty();
        if (noIndexColumnSelected) {
            return false;
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> dataModel = dataGrid.getDataModel();
        for (String name : columnNames) {
            ModelIndex<DataConsumer.Column> c = DataGridUtil.findColumn(dataGrid, name);
            if (!c.isValid(dataGrid)) {
                return false;
            }
            values.add(dataModel.getValueAt(selectedRow, c));
        }
        return true;
    }

    private static void runQueries(final DataGrid dataGrid, final State state, final String initialValue) {
        if (state.queries.isEmpty()) {
            return;
        }
        final PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(DataManager.getInstance().getDataContext((Component)dataGrid.getComponent()));
        if (element == null || DataGridPomTarget.unwrapCell(element) == null) {
            return;
        }
        final Project project = element.getProject();
        DatabaseGridDataHookUp ownerEx = DataGridUtil.getDatabaseHookUp(dataGrid);
        if (ownerEx == null) {
            return;
        }
        ownerEx.getMessageBus().getDataProducer().processRequest(new DataRequest.RawRequest(ownerEx){

            @Override
            public void processRaw(DataRequest.Context context, Connection connection) throws Exception {
                StringBuilder sb = new StringBuilder();
                for (QueryInfo info : state.queries) {
                    this.checkCancelled();
                    int length = sb.length();
                    DataGridDocumentationProvider.runWithNotifications(project, info.query, () -> {
                        DbImplUtil.tryLoadFirstNRows(connection, info.query, sb, 1);
                        return null;
                    });
                    this.checkCancelled();
                    if (sb.length() == length) continue;
                    String title = !info.exported ? "Referenced " + info.table.getName() : "First referencing " + info.table.getName();
                    sb.insert(length, "<br><b>" + title + ":</b><br>" + info.keysAndColumns);
                }
                if (sb.length() == 0) {
                    return;
                }
                sb.insert(0, "<br>");
                dataGrid.putUserData(GRID_HINT_STATE_KEY, new State(state.queries, state.row, sb.toString()));
                String doc = sb.insert(0, initialValue).toString();
                QuickDocUtil.updateQuickDoc((Project)project, (PsiElement)element, (String)doc);
            }

            void checkCancelled() {
                if (dataGrid.getUserData(GRID_HINT_STATE_KEY) != state) {
                    throw new ProcessCanceledException();
                }
            }
        });
    }

    @NotNull
    public static String getCellDocumentation(@NotNull DataGrid dataGrid, final Command mode) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/run/ui/DataGridDocumentationProvider", "getCellDocumentation"));
        }
        final Map<String, Image> imageMap = DataGridDocumentationProvider.getImageMap(dataGrid);
        StringBuilder sb = new StringBuilder(HtmlValuesExtractor.getStyleHeader());
        SelectionModel selectionModel = dataGrid.getSelectionModel();
        boolean singleValue = selectionModel.getSelectedColumnCount() + selectionModel.getSelectedRowCount() == 2;
        final boolean plainMode = singleValue && mode != Command.transposed;
        CharOut.Wrapper out = new CharOut.Wrapper(CharOut.Util.newSink(sb)){
            int max;
            {
                super(delegate);
                this.max = 10240;
            }

            @Override
            @NotNull
            public CharOut append(@NotNull CharSequence seq) {
                CharSequence trimmedSeq;
                if (seq == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/database/run/ui/DataGridDocumentationProvider$3", "append"));
                }
                if (seq.length() == 0) {
                    3 v0 = this;
                    if (v0 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridDocumentationProvider$3", "append"));
                    }
                    return v0;
                }
                boolean truncate = mode != Command.full && (double)seq.length() > 1.1 * (double)this.max;
                CharSequence charSequence = trimmedSeq = truncate ? seq.subSequence(0, this.max) : seq;
                if (plainMode) {
                    DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate(), Command.transposed, null);
                    if (truncate) {
                        DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate().append("&nbsp;&nbsp;&nbsp;"), Command.full, "All " + ExtractorsUtil.getPresentableSize(seq.length()));
                    }
                    super.append("<br><br><pre><code>");
                    this.appendInner(trimmedSeq);
                    super.append("</code>");
                    if (truncate) {
                        DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate().append("&nbsp;"), Command.full, ExtractorsUtil.getPresentableSize(seq.length() - this.max) + " more...");
                    }
                    super.append("</pre>");
                } else if (truncate) {
                    this.appendInner(trimmedSeq);
                    super.append(" " + ExtractorsUtil.getPresentableSize(seq.length() - this.max) + " more...");
                } else {
                    this.appendInner(seq);
                }
                3 v2 = this;
                if (v2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridDocumentationProvider$3", "append"));
                }
                return v2;
            }

            void appendInner(CharSequence trimmedSeq) {
                int cur = 0;
                int len = trimmedSeq.length();
                while (cur < len) {
                    int next = StringUtil.indexOf((CharSequence)trimmedSeq, (char)'\n', (int)cur);
                    next = next < 0 ? len : next;
                    super.append(trimmedSeq.subSequence(cur, next));
                    super.append(" \n");
                    cur = next + 1;
                }
            }
        };
        final ObjectFormatter delegateFormatter = dataGrid.getObjectFormatter();
        ObjectFormatter converter = new ObjectFormatter(){

            @Override
            @Nullable
            public String objectToString(@Nullable Object o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                String s = delegateFormatter.objectToString(o, column, dialect, true);
                if (o instanceof ObjectFormatter.ImageInfo) {
                    ObjectFormatter.ImageInfo info = (ObjectFormatter.ImageInfo)o;
                    long id = ourImageCounter.incrementAndGet();
                    String imageSpec = "http://img" + id;
                    imageMap.put(imageSpec, info.createImage());
                    delegateFormatter.objectToString(o, column, dialect, forDisplay);
                    return "<img src=\"" + imageSpec + "\" alt=\"" + s + "\" height=\"" + info.height + "\" width=\"" + info.width + "\" />";
                }
                if (s == null) {
                    return null;
                }
                return plainMode ? JDOMUtil.legalizeChars((CharSequence)s).toString() : s;
            }
        };
        if (singleValue && mode != Command.transposed) {
            DataGridUtil.extractSelectedValues(dataGrid, ExtractorsUtil.getSingleValueExtractor(converter), out);
        } else {
            int[] columns = (mode == Command.transposed ? dataGrid.getVisibleColumns() : selectionModel.getSelectedColumns()).asArray();
            HtmlValuesExtractor extractor = new HtmlValuesExtractor(converter);
            extractor.setTransposedMode(mode == Command.transposed);
            extractor.setDisplayMode(true);
            extractor.setIncludeColumnNames(true);
            extractor.setIncludeRowNumbers(mode == Command.transposed);
            DataGridDocumentationProvider.appendHyperLinkCommand(out.getDelegate(), mode == Command.transposed ? Command.regular : Command.transposed, null).append("<br><br>");
            DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(dataGrid);
            List<DataConsumer.Column> allColumns = dataGrid.getDataModel().getColumns();
            List<DataConsumer.Row> selectedRows = DataGridUtil.getSelectedRows(dataGrid);
            ExtractorsUtil.extract(out, dialect, false, allColumns, extractor, selectedRows, columns);
        }
        String result = DataGridDocumentationProvider.buildAndRunQueries(dataGrid, sb);
        String string = (result == null ? sb : sb.append(result)).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridDocumentationProvider", "getCellDocumentation"));
        }
        return string;
    }

    @Nullable
    public Image getLocalImageForElement(@NotNull PsiElement element, @NotNull String imageSpec) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/run/ui/DataGridDocumentationProvider", "getLocalImageForElement"));
        }
        if (imageSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageSpec", "com/intellij/database/run/ui/DataGridDocumentationProvider", "getLocalImageForElement"));
        }
        DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid(element);
        if (dataGrid == null) {
            return null;
        }
        Map<String, Image> map = DataGridDocumentationProvider.getImageMap(dataGrid);
        return map.get(imageSpec);
    }

    @NotNull
    private static Map<String, Image> getImageMap(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/run/ui/DataGridDocumentationProvider", "getImageMap"));
        }
        Map map = (Map)dataGrid.getUserData(IMAGE_MAP_KEY);
        if (map == null) {
            map = ContainerUtil.createConcurrentWeakValueMap();
            dataGrid.putUserData(IMAGE_MAP_KEY, map);
        }
        Map map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridDocumentationProvider", "getImageMap"));
        }
        return map2;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        DataGridPomTarget.Cell cell = DataGridPomTarget.unwrapCell(element);
        if (cell != null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)element.getProject());
            Command command = Command.getCommand(propertiesComponent.getValue(VIEW_MODE_PROPERTY), Command.regular);
            return DataGridDocumentationProvider.getCellDocumentation(cell.dataGrid, command);
        }
        DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid(element);
        if (DataGridUtil.getQueryText(dataGrid) != null) {
            return DataGridDocumentationProvider.getGridDocumentation(element.getProject(), dataGrid);
        }
        return null;
    }

    @Nullable
    private static String getGridDocumentation(Project project, @NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/run/ui/DataGridDocumentationProvider", "getGridDocumentation"));
        }
        String queryText = DataGridUtil.getQueryText(dataGrid);
        if (queryText == null) {
            return null;
        }
        GridPagingModel pageModel = dataGrid.getDataHookup().getPageModel();
        String curCount = pageModel.getTotalRowCount() + (!pageModel.isTotalRowCountPrecise() ? "+" : "");
        return "<b>rows:</b> " + curCount + (pageModel.isTotalRowCountUpdateable() ? DataGridDocumentationProvider.getCountCommand(pageModel.isTotalRowCountPrecise()) : "") + "<br><br><pre><code>" + DbSqlUtil.sql2Html(project, (Language)DbSqlUtil.getSqlDialect(DataGridUtil.getDatabaseDialect(dataGrid)), queryText) + "</code></pre>";
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    public boolean handleExternal(PsiElement element, PsiElement originalElement) {
        return false;
    }

    public boolean handleExternalLink(PsiManager psiManager, String link, PsiElement context) {
        return false;
    }

    public boolean canFetchDocumentationLink(String link) {
        return link.startsWith(URL_PREFIX);
    }

    @NotNull
    public String fetchExternalDocumentation(@NotNull String link, @Nullable PsiElement element) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/database/run/ui/DataGridDocumentationProvider", "fetchExternalDocumentation"));
        }
        if (element == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridDocumentationProvider", "fetchExternalDocumentation"));
            }
            return "";
        }
        int paramStart = link.indexOf(63);
        String substring = link.substring(URL_PREFIX.length() + 1, paramStart == -1 ? link.length() : paramStart);
        Command command = Command.getCommand(substring, null);
        Project project = element.getProject();
        if (command == Command.count) {
            int queryIdx;
            Integer rowCount = DataGridDocumentationProvider.getUpdatedRowCount(project, element);
            if (rowCount == null || !project.isOpen()) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridDocumentationProvider", "fetchExternalDocumentation"));
                }
                return "";
            }
            DocumentationComponent component = QuickDocUtil.getActiveDocComponent((Project)project);
            String text = component == null ? null : component.getText();
            int n = queryIdx = text == null ? -1 : text.indexOf(link);
            if (queryIdx < 0) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridDocumentationProvider", "fetchExternalDocumentation"));
                }
                return "";
            }
            int idx0 = text.lastIndexOf("</b>", queryIdx) + "</b>".length() + 1;
            int idx1 = text.indexOf("</a>", queryIdx + link.length()) + "</a>".length();
            if (idx0 < 0 || idx1 < 0) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridDocumentationProvider", "fetchExternalDocumentation"));
                }
                return "";
            }
            String string = text.substring(0, idx0) + rowCount.toString() + DataGridDocumentationProvider.getCountCommand(true) + text.substring(idx1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridDocumentationProvider", "fetchExternalDocumentation"));
            }
            return string;
        }
        if (command == Command.transposed || command == Command.regular) {
            PropertiesComponent.getInstance((Project)project).setValue(VIEW_MODE_PROPERTY, command.name());
        }
        String string = DataGridDocumentationProvider.getCellDocumentation((DataGrid)ObjectUtils.assertNotNull((Object)DataGridPomTarget.unwrapDataGrid(element)), command);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridDocumentationProvider", "fetchExternalDocumentation"));
        }
        return string;
    }

    @Nullable
    private static Integer getUpdatedRowCount(@NotNull Project project, @Nullable PsiElement element) {
        AsyncFutureResult<Integer> rowCountResult;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/DataGridDocumentationProvider", "getUpdatedRowCount"));
        }
        if (element instanceof DbTable) {
            DatabaseElementVirtualFileImpl file = DatabaseElementVirtualFileImpl.findFile((DbElement)element);
            if (file == null) {
                return null;
            }
            final Disposable disposable = Disposer.newDisposable();
            Disposer.register((Disposable)project, (Disposable)disposable);
            DatabaseTableGridDataHookUp hookUp = GridDataHookUpManager.getInstance(project).getHookUp(file, disposable);
            rowCountResult = CountRowsAction.countRows(hookUp);
            rowCountResult.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new ResultConsumer<Integer>(){

                public void onSuccess(Integer value) {
                    Disposer.dispose((Disposable)disposable);
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/run/ui/DataGridDocumentationProvider$5", "onFailure"));
                    }
                    Disposer.dispose((Disposable)disposable);
                }
            });
        } else {
            DataGrid grid = DataGridPomTarget.unwrapDataGrid(element);
            if (grid == null) {
                return null;
            }
            rowCountResult = CountRowsAction.countRows(grid);
        }
        try {
            return (Integer)rowCountResult.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static <T> T runWithNotifications(Project project, String query, ThrowableComputable<T, Exception> computable) throws Exception {
        try {
            Object result = computable.compute();
            DatabaseNotifications.DATABASE_VIEW_LOG_GROUP.createNotification(query, MessageType.INFO).notify(project);
            return (T)result;
        }
        catch (Exception e) {
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(query, MessageType.ERROR).notify(project);
            throw e;
        }
    }

    public static String getCountCommand(boolean refresh) {
        return "&nbsp&nbsp<a href=\"db-doc:///" + Command.count.name() + "\">click to " + (refresh ? "refresh" : "to count(*)") + "</a>";
    }

    @NotNull
    private static CharOut appendHyperLinkCommand(@NotNull CharOut sb, @NotNull Command command, @Nullable String text) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/run/ui/DataGridDocumentationProvider", "appendHyperLinkCommand"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/run/ui/DataGridDocumentationProvider", "appendHyperLinkCommand"));
        }
        CharOut charOut = sb.append("<a href=\"db-doc:///" + command.name() + "\">" + StringUtil.capitalize((String)StringUtil.notNullize((String)text, (String)(command.name() + " View"))) + "</a>");
        if (charOut == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridDocumentationProvider", "appendHyperLinkCommand"));
        }
        return charOut;
    }

    public static class QueryInfo {
        public final String query;
        public final DasTable table;
        public final boolean exported;
        public final String[] columnNames;
        public final Object[] values;
        public String keysAndColumns = "";

        QueryInfo(String query, DasTable table, boolean exported, String[] columnNames, Object[] values) {
            this.query = query;
            this.table = table;
            this.exported = exported;
            this.columnNames = columnNames;
            this.values = values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryInfo info = (QueryInfo)o;
            return this.query.equals(info.query);
        }

        public int hashCode() {
            return this.query.hashCode();
        }
    }

    private static class State {
        final List<QueryInfo> queries;
        final ModelIndex<DataConsumer.Row> row;
        final String current;

        State(List<QueryInfo> queries, ModelIndex<DataConsumer.Row> row, String current) {
            this.queries = queries;
            this.row = row;
            this.current = current;
        }
    }

    public static enum KeyType {
        EXPORTED,
        FOREIGN,
        SELECTED;

    }

    private static enum Command {
        transposed,
        regular,
        full,
        count;


        static Command getCommand(String name, Command def) {
            try {
                return Enum.valueOf(Command.class, name);
            }
            catch (Exception e) {
                return def;
            }
        }
    }
}

