/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class DataGridFormattersUtil {
    private static final int DEFAULT_ERA = 1;

    private DataGridFormattersUtil() {
    }

    public static int getEra(@NotNull Date date, @NotNull ZoneId zoneId) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil", "getEra"));
        }
        if (zoneId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zoneId", "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil", "getEra"));
        }
        ZonedDateTime time = Instant.ofEpochMilli(date.getTime()).atZone(zoneId);
        return time.isSupported(ChronoField.ERA) ? time.get(ChronoField.ERA) : 1;
    }

    public static Date getBoundedValue(@NotNull Object value, @NotNull ModelIndex<DataConsumer.Column> column, @NotNull DataGrid grid) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil", "getBoundedValue"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil", "getBoundedValue"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil", "getBoundedValue"));
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        DataConsumer.Column gridColumn = grid.getDataModel().getColumn(column);
        BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(dialect, gridColumn);
        return new Date(resolver.getLowerBound(value));
    }
}

