/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtil;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class DateDelegate
extends DateAndTimeFormatterDelegate<Date, LocalDate> {
    public DateDelegate() {
        super(LocalDate::from);
    }

    @Override
    Date create(@NotNull LocalDate value, @NotNull String stringRepresentation) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/DateDelegate", "create"));
        }
        if (stringRepresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRepresentation", "com/intellij/database/run/ui/grid/editors/DateDelegate", "create"));
        }
        return java.sql.Date.valueOf(value);
    }

    @Override
    LocalDate toTemporalAccessor(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/DateDelegate", "toTemporalAccessor"));
        }
        if (!(value instanceof Date)) {
            throw new IllegalArgumentException("Value must be of type Date");
        }
        Date date = (Date)value;
        java.sql.Date sqlDate = new java.sql.Date(date.getTime());
        return sqlDate.toLocalDate().with(ChronoField.ERA, DataGridFormattersUtil.getEra(date, ZoneId.systemDefault()));
    }
}

