/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorTextField;
import com.intellij.database.util.DbUIUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatBasedGridCellEditor
extends GridCellEditor.Adapter {
    private final Formatter myFormat;
    private final ReservedCellValue myNullValue;
    private final GridCellEditorTextField myTextField;
    private final DataGrid myGrid;

    public FormatBasedGridCellEditor(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, @Nullable EventObject initiator, @Nullable TextCompletionProvider provider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "<init>"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "<init>"));
        }
        this.myFormat = format;
        this.myNullValue = nullValue;
        this.myGrid = grid;
        String text = this.doFormat(value);
        text = text != null ? text : this.format(null);
        this.myTextField = new GridCellEditorTextField(project, grid, Language.ANY, text, null, false, initiator, provider);
        if (nullValue != null) {
            this.myTextField.addSettingsProvider(new EditorSettingsProvider(){

                public void customizeSettings(EditorEx editor) {
                    editor.setPlaceholder((CharSequence)FormatBasedGridCellEditor.this.myNullValue.getDisplayName());
                    editor.setShowPlaceholderWhenFocused(true);
                }
            });
        }
        Disposer.register((Disposable)this, (Disposable)this.myTextField);
    }

    public FormatBasedGridCellEditor(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, @Nullable EventObject initiator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "<init>"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "<init>"));
        }
        this(project, grid, format, value, nullValue, initiator, null);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        GridCellEditorTextField gridCellEditorTextField = this.myTextField;
        if (gridCellEditorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "getComponent"));
        }
        return gridCellEditorTextField;
    }

    @Override
    @Nullable
    public Object getValue() {
        String text = this.myTextField.getText();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return this.myNullValue;
        }
        try {
            return this.myFormat.parse(text);
        }
        catch (ParseException ignore) {
            return text;
        }
    }

    @Override
    public boolean stop() {
        MarkupModel markupModel;
        String text = this.myTextField.getText();
        ParsePosition pos = new ParsePosition(0);
        this.myFormat.parse(text, pos);
        if (pos.getErrorIndex() == -1 || text.isEmpty()) {
            return true;
        }
        Editor editor = this.myTextField.getEditor();
        MarkupModel markupModel2 = markupModel = editor != null ? editor.getMarkupModel() : null;
        if (markupModel != null) {
            markupModel.removeAllHighlighters();
            markupModel.addRangeHighlighter(0, editor.getDocument().getTextLength(), 3000, editor.getColorsScheme().getAttributes(DatabaseColors.GRID_ERROR_VALUE), HighlighterTargetArea.EXACT_RANGE);
        }
        return false;
    }

    @NotNull
    protected GridCellEditorTextField getTextField() {
        GridCellEditorTextField gridCellEditorTextField = this.myTextField;
        if (gridCellEditorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "getTextField"));
        }
        return gridCellEditorTextField;
    }

    @Nullable
    protected ReservedCellValue getNullValue() {
        return this.myNullValue;
    }

    @NotNull
    protected String format(@Nullable Object value) {
        String string = (String)ObjectUtils.assertNotNull((Object)this.doFormat(value));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor", "format"));
        }
        return string;
    }

    @Nullable
    private String doFormat(@Nullable Object value) {
        try {
            return value instanceof ReservedCellValue || value == null ? "" : this.myFormat.format(value);
        }
        catch (IllegalArgumentException iae) {
            if (DataGridUtil.LOG.isDebugEnabled()) {
                DatabaseFamilyId dialectFamily = DataGridUtil.getDatabaseDialect(this.myGrid).getFamilyId();
                String message = "Failed to format object " + value + " of class " + value.getClass().getName() + " using format " + this.myFormat + ". Dialect: " + dialectFamily + "\n";
                DataGridUtil.LOG.debug(message, (Throwable)iae);
            }
            return null;
        }
    }

    protected final DataGrid getGrid() {
        return this.myGrid;
    }

    protected final Formatter getFormat() {
        return this.myFormat;
    }

    protected static abstract class WithBrowseButton<T extends JComponent>
    extends BoundedFormatBasedGridCellEditor<Long>
    implements ActionListener {
        private final ComponentWithBrowseButton<GridCellEditorTextField> myComponent;

        public WithBrowseButton(Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator, @NotNull ModelIndex<DataConsumer.Column> columnModelIndex) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "<init>"));
            }
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "<init>"));
            }
            if (columnModelIndex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnModelIndex", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "<init>"));
            }
            super(project, grid, format, value, nullValue, initiator, columnModelIndex);
            this.myComponent = new ComponentWithBrowseButton<GridCellEditorTextField>(this.getTextField(), (ActionListener)this){

                public void addNotify() {
                    super.addNotify();
                    DbUIUtil.invokeLater(() -> this.actionPerformed(null));
                }
            };
            this.myComponent.getButton().setBorder(UIManager.getBorder("Button.border"));
            this.myComponent.setRequestFocusEnabled(true);
            this.getTextField().addSettingsProvider(editor -> editor.getSelectionModel().removeSelection());
        }

        @NotNull
        public ComponentWithBrowseButton<GridCellEditorTextField> getComponent() {
            ComponentWithBrowseButton<GridCellEditorTextField> componentWithBrowseButton = this.myComponent;
            if (componentWithBrowseButton == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "getComponent"));
            }
            return componentWithBrowseButton;
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            JBPopup popup = this.createPopup();
            this.showPopup(popup);
        }

        @NotNull
        private JBPopup createPopup() {
            Pair<T, JComponent> components = this.getPopupComponents();
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)components.getFirst(), (JComponent)components.getSecond()).setModalContext(false).setFocusable(true).setCancelOnClickOutside(true).setRequestFocus(true).setResizable(false).createPopup();
            this.configurePopup(popup, (JComponent)components.getFirst());
            Disposer.register((Disposable)this, (Disposable)popup);
            JBPopup jBPopup = popup;
            if (jBPopup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "createPopup"));
            }
            return jBPopup;
        }

        @Override
        protected void showPopup(@NotNull JBPopup popup) {
            if (popup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "showPopup"));
            }
            Dimension size = popup.getContent().getPreferredSize();
            FixedSizeButton button = this.getComponent().getButton();
            popup.show(new RelativePoint((Component)button, new Point(button.getWidth() - size.width, button.getHeight())));
        }

        @Override
        protected Long getInternalValue() {
            BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(DataGridUtil.getDatabaseDialect(this.getGrid()), (DataConsumer.Column)this.getGrid().getDataModel().getColumn(this.myColumnModelIndex));
            String text = this.getTextField().getText();
            Object object = this.getFormat().parse(text, new ParsePosition(0));
            return resolver.getValue(object);
        }

        @Override
        protected String getBoundaryString(@NotNull Long internalValue) {
            if (internalValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "getBoundaryString"));
            }
            BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(DataGridUtil.getDatabaseDialect(this.getGrid()), (DataConsumer.Column)this.getGrid().getDataModel().getColumn(this.myColumnModelIndex));
            return resolver.getBoundaryString(internalValue);
        }

        @Override
        protected void beforeStopEditing(@NotNull Long internalValue) {
            if (internalValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "beforeStopEditing"));
            }
            Object object = this.createObject(internalValue);
            this.getTextField().setText(this.format(object));
        }

        @Override
        protected boolean isSameValueInEditor(@NotNull Long internalValue, @NotNull String boundaryString) {
            if (internalValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "isSameValueInEditor"));
            }
            if (boundaryString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundaryString", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton", "isSameValueInEditor"));
            }
            return StringUtil.equalsIgnoreWhitespaces((CharSequence)boundaryString, (CharSequence)this.getTextField().getText());
        }

        @NotNull
        protected abstract Pair<T, JComponent> getPopupComponents();

        protected abstract void configurePopup(@NotNull JBPopup var1, @NotNull T var2);
    }

    protected static abstract class BoundedFormatBasedGridCellEditor<T>
    extends FormatBasedGridCellEditor {
        private static final String CONFIRMATION_TITLE = "Value is out of range. Set \"%s\"?";
        private boolean adjusting;
        protected final ModelIndex<DataConsumer.Column> myColumnModelIndex;

        public BoundedFormatBasedGridCellEditor(Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator, @NotNull ModelIndex<DataConsumer.Column> columnModelIndex) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor", "<init>"));
            }
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor", "<init>"));
            }
            if (columnModelIndex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnModelIndex", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor", "<init>"));
            }
            super(project, grid, format, value, nullValue, initiator);
            this.myColumnModelIndex = columnModelIndex;
        }

        @Override
        public boolean stop() {
            return super.stop() && this.checkInRange();
        }

        private boolean checkInRange() {
            return this.adjusting || this.getTextField().getText().isEmpty() || !this.outOfRange(this.getInternalValue(), null, null);
        }

        protected final void processDate(@NotNull T internalValue, @Nullable Runnable onAccept, @Nullable Runnable onDecline) {
            if (internalValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor", "processDate"));
            }
            if (this.outOfRange(internalValue, onAccept, onDecline)) {
                return;
            }
            this.acceptValue(internalValue, onAccept);
        }

        protected void showPopup(@NotNull JBPopup popup) {
            if (popup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor", "showPopup"));
            }
            Dimension size = popup.getContent().getPreferredSize();
            JComponent button = this.getComponent();
            popup.show(new RelativePoint((Component)button, new Point(button.getWidth() - size.width, button.getHeight())));
        }

        private boolean outOfRange(@NotNull T internalValue, @Nullable Runnable onAccept, @Nullable Runnable onDecline) {
            if (internalValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor", "outOfRange"));
            }
            String boundary = this.getBoundaryString(internalValue);
            if (boundary != null && !this.isSameValueInEditor(internalValue, boundary)) {
                this.onOutOfRange(boundary, internalValue, onAccept, onDecline);
                return true;
            }
            return false;
        }

        private void onOutOfRange(@NotNull String boundary, @NotNull T internalValue, @Nullable Runnable onAccept, @Nullable Runnable onDecline) {
            if (boundary == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundary", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor", "onOutOfRange"));
            }
            if (internalValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor", "onOutOfRange"));
            }
            this.showPopup((JBPopup)JBPopupFactory.getInstance().createConfirmation(String.format(CONFIRMATION_TITLE, boundary), "Yes", "No", () -> {
                if (internalValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor", "lambda$onOutOfRange$0"));
                }
                this.acceptValue(internalValue, onAccept);
            }, (Runnable)ObjectUtils.notNull((Object)onDecline, () -> {}), 1));
        }

        private void acceptValue(@NotNull T internalValue, @Nullable Runnable onAccept) {
            if (internalValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor", "acceptValue"));
            }
            try {
                this.adjusting = true;
                this.beforeStopEditing(internalValue);
                this.getGrid().stopEditing();
                if (onAccept != null) {
                    onAccept.run();
                }
            }
            finally {
                this.adjusting = false;
            }
        }

        protected void beforeStopEditing(@NotNull T internalValue) {
            if (internalValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor", "beforeStopEditing"));
            }
        }

        protected abstract T getInternalValue();

        protected abstract boolean isSameValueInEditor(@NotNull T var1, @NotNull String var2);

        protected abstract Object createObject(@NotNull T var1);

        protected abstract String getBoundaryString(@NotNull T var1);
    }
}

