/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.UniversalFormatter;
import com.intellij.openapi.util.text.StringUtil;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PostgresHstoreEditorFactory
extends FormatBasedGridCellEditorFactory {
    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/PostgresHstoreEditorFactory", "getSuitability"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/PostgresHstoreEditorFactory", "getSuitability"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/PostgresHstoreEditorFactory", "getSuitability"));
        }
        DataConsumer.Column c = grid.getDataModel().getColumn(column);
        Object value = grid.getDataModel().getValueAt(row, column);
        return c != null && ObjectFormatter.isHstore(c) && (value == null || value instanceof Map || value instanceof ReservedCellValue || value instanceof String) ? 1 : 0;
    }

    @Override
    @NotNull
    protected Formatter getFormat(final @NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, final @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/PostgresHstoreEditorFactory", "getFormat"));
        }
        if (rowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/run/ui/grid/editors/PostgresHstoreEditorFactory", "getFormat"));
        }
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/grid/editors/PostgresHstoreEditorFactory", "getFormat"));
        }
        final Object oldValue = grid.getDataModel().getValueAt(rowIdx, columnIdx);
        UniversalFormatter universalFormatter = new UniversalFormatter(new Format(){
            private String myOldValueText;

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                String text;
                if (obj instanceof Map) {
                    DataConsumer.Column column = (DataConsumer.Column)grid.getDataModel().getColumn(columnIdx);
                    text = column != null ? grid.getObjectFormatter().objectToString(obj, column, DataGridUtil.getDatabaseDialect(grid), false) : "";
                } else {
                    String string = text = obj == null || obj instanceof ReservedCellValue ? "" : String.valueOf(obj);
                }
                if (this.myOldValueText == null) {
                    this.myOldValueText = text;
                }
                return toAppendTo.append(text);
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                pos.setIndex(source.length());
                if (StringUtil.equals((CharSequence)this.myOldValueText, (CharSequence)source)) {
                    return oldValue;
                }
                return source;
            }
        });
        if (universalFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/PostgresHstoreEditorFactory", "getFormat"));
        }
        return universalFormatter;
    }
}

