/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeColumn
extends DeTableChild
implements DasColumn {
    @NotNull
    public String dataType;
    @Nullable
    public String defaultValue;
    @NotNull
    public final Set<Flag> flags;

    protected DeColumn(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeColumn", "<init>"));
        }
        super(model);
        this.dataType = "int";
        this.defaultValue = null;
        this.flags = ContainerUtil.newHashSet();
    }

    public DeColumn(@NotNull String name, @NotNull DeTable parent, @NotNull DeModel model) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/schemaEditor/model/DeColumn", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/schemaEditor/model/DeColumn", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeColumn", "<init>"));
        }
        super(name, parent, model);
        this.dataType = "int";
        this.defaultValue = null;
        this.flags = ContainerUtil.newHashSet();
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children, @NotNull Collection<? extends DasObject> otherChildren) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/schemaEditor/model/DeColumn", "isAlteredIgnoringChild"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/schemaEditor/model/DeColumn", "isAlteredIgnoringChild"));
        }
        if (otherChildren == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherChildren", "com/intellij/database/schemaEditor/model/DeColumn", "isAlteredIgnoringChild"));
        }
        DeColumn otherColumn = (DeColumn)other;
        return !this.dataType.equals(otherColumn.dataType) || !Comparing.equal((String)this.defaultValue, (String)otherColumn.defaultValue) || !Comparing.haveEqualElements(this.flags, otherColumn.flags) || super.isAlteredIgnoringChild(other, children, otherChildren);
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeColumn", "emptyClone"));
        }
        DeColumn deColumn = new DeColumn(model);
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeColumn", "emptyClone"));
        }
        return deColumn;
    }

    public boolean isInTable() {
        return this.table.columns.contains(this);
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeColumn", "copyFrom"));
        }
        if (copier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copier", "com/intellij/database/schemaEditor/model/DeColumn", "copyFrom"));
        }
        super.copyFrom(obj, withChildren, copier);
        DeColumn col = (DeColumn)obj;
        this.dataType = col.dataType;
        this.defaultValue = col.defaultValue;
        this.flags.clear();
        this.flags.addAll(col.flags);
        DeColumn deColumn = this;
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeColumn", "copyFrom"));
        }
        return deColumn;
    }

    @NotNull
    public DataType getDataType() {
        DataType dataType;
        try {
            dataType = DataTypeFactory.of(this.dataType);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeColumn", "getDataType"));
        }
        return dataType;
    }

    @Nullable
    public DasUserDefinedType getCustomType() {
        return null;
    }

    public boolean isNotNull() {
        return this.flags.contains((Object)Flag.NOT_NULL);
    }

    @Nullable
    public String getDefault() {
        return this.defaultValue;
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.COLUMN;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeColumn", "getKind"));
        }
        return objectKind;
    }

    public boolean isEnabled() {
        return true;
    }

    public static enum Flag {
        NOT_NULL,
        AUTO_INC;

    }
}

