/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.sqlite;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.schemaEditor.operations.sqlite.SqliteReplaceTableOperation;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqliteAlterTableOperation
extends DasDdlOperations.AlterTableOperation {
    @Override
    @NotNull
    public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable from, @Nullable UserDataHolder data) {
        boolean unsupOpsUsed;
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "addToBuilder"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "addToBuilder"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "addToBuilder"));
        }
        assert (data != null);
        DeTable to = (DeTable)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
        boolean bl = unsupOpsUsed = SqliteAlterTableOperation.willRecreate(from, to) || SqliteAlterTableOperation.willRecreateReferenced(to);
        if (!unsupOpsUsed) {
            DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, from, data);
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "addToBuilder"));
            }
            return ddlGenerator;
        }
        generator.addOperation(builder, SqliteReplaceTableOperation.SQLITE_REPLACE_TABLE, to, DasDdlOperations.set(builder.newData(data), DdlGraph.ALTER_FROM, from));
        DdlGenerator ddlGenerator = generator;
        if (ddlGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "addToBuilder"));
        }
        return ddlGenerator;
    }

    public static boolean willRecreate(@NotNull DeTable from, @NotNull DeTable to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "willRecreate"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "willRecreate"));
        }
        LinkedHashSet alter = ContainerUtil.newLinkedHashSet();
        LinkedHashSet drop = ContainerUtil.newLinkedHashSet();
        LinkedHashSet create = ContainerUtil.newLinkedHashSet();
        ArrayList order = ContainerUtil.newArrayList();
        SqliteAlterTableOperation.classifyChildren(from, to, create, alter, drop, order);
        return SqliteAlterTableOperation.isUnsupOpsUsed(create, alter, drop);
    }

    public static boolean willRecreateReferenced(@NotNull DeTable to) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "willRecreateReferenced"));
        }
        HashSet targets = ContainerUtil.newHashSet();
        for (DeForeignKey key : to.foreignKeys) {
            ContainerUtil.addIfNotNull((Collection)targets, (Object)key.target);
        }
        for (DeTable target : targets) {
            if (target.editedObject == null || !SqliteAlterTableOperation.willRecreate((DeTable)target.editedObject, target)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnsupOpsUsed(@NotNull Set<DeObject> create, @NotNull Set<DeObject> alter, @NotNull Set<DeObject> drop) {
        if (create == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "create", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "isUnsupOpsUsed"));
        }
        if (alter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alter", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "isUnsupOpsUsed"));
        }
        if (drop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drop", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "isUnsupOpsUsed"));
        }
        for (DeObject object : create) {
            if (object.getKind() == ObjectKind.COLUMN || object.getKind() == ObjectKind.INDEX) continue;
            return true;
        }
        for (DeObject object : alter) {
            if (!object.isAltered((DeObject)ObjectUtils.assertNotNull((Object)object.editedObject)) || object.getKind() == ObjectKind.INDEX) continue;
            return true;
        }
        for (DeObject object : drop) {
            if (object.getKind() == ObjectKind.INDEX) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public DdlGenerator removeFromBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable from, @Nullable UserDataHolder data) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "removeFromBuilder"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "removeFromBuilder"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "removeFromBuilder"));
        }
        assert (data != null);
        DeTable to = (DeTable)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
        generator.removeOperation(builder, SqliteReplaceTableOperation.SQLITE_REPLACE_TABLE, to, DasDdlOperations.set(builder.newData(data), DdlGraph.ALTER_FROM, from));
        DdlGenerator ddlGenerator = super.removeFromBuilder(generator, builder, from, data);
        if (ddlGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation", "removeFromBuilder"));
        }
        return ddlGenerator;
    }
}

