/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseIndexEditor;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.IndexEditorModel;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableIndicesEditor
extends DatabaseTableEditor.TabProvider {
    private final DatabaseEditorUtil.DbListTableWithEditor myTable;
    private final JPanel myTablePanel;
    private ListTableModel<DatabaseIndexEditor> myIndexModel;
    private final DatabaseTableEditor myTableEditor;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;

    public DatabaseTableIndicesEditor(@NotNull DatabaseTableEditor tableEditor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorToolbarsDecorator toolbarsDecorator) {
        if (tableEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableEditor", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "<init>"));
        }
        if (toolbarsDecorator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbarsDecorator", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "<init>"));
        }
        this.myTableEditor = tableEditor;
        this.myCaps = caps;
        this.myIndexModel = DatabaseEditorUtil.createTableModel(this.getTableModel(), new DatabaseEditorUtil.EditorModelHelper<DatabaseIndexEditor>(){

            @Override
            @Nullable
            public DatabaseIndexEditor createRow() {
                if (!DatabaseTableIndicesEditor.this.myCaps.getIndices().canAdd()) {
                    return null;
                }
                DeIndex index = DatabaseTableIndicesEditor.this.getTableModel().createIndex("", new DeIndex.Item[0]);
                DatabaseTableIndicesEditor.this.getTableModel().addIndex(index);
                return DatabaseTableIndicesEditor.this.createIndexEditor(index);
            }

            @Override
            public boolean removeRow(DatabaseIndexEditor item, int idx) {
                if (!DatabaseTableIndicesEditor.this.myCaps.getIndices().canRemove()) {
                    return false;
                }
                DeIndex index = (DeIndex)((ObjectEditorModel)item.getModel()).getObject();
                DatabaseTableIndicesEditor.this.getTableModel().removeIndex(index);
                Disposer.dispose((Disposable)item);
                return true;
            }
        }, false);
        this.myTable = DatabaseEditorUtil.createTableWithEditor(this.myIndexModel, this.myTableEditor, 8, JBUI.scale((int)500), null);
        this.myTable.getTable().getEmptyText().setText("No indices");
        ToolbarDecorator decorator = toolbarsDecorator.decorateIndices(caps, tableEditor, (JTable)this.myTable.getTable());
        this.myTablePanel = decorator.createPanel();
        DatabaseEditorUtil.setTableDecoratorMinSize(this.myTablePanel, (JTable)this.myTable.getTable());
        this.myTablePanel.setBorder(BORDER);
    }

    @Nullable
    public DatabaseIndexEditor startItemEditing(@NotNull DeIndex index) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "startItemEditing"));
        }
        return DatabaseEditorUtil.startItemEditing(index, this.myTable, this.myIndexModel);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myTablePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableEditor.getTableModel();
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "getTableModel"));
        }
        return tableEditorModel;
    }

    @NotNull
    private DatabaseIndexEditor createIndexEditor(@NotNull DeIndex index) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "createIndexEditor"));
        }
        DatabaseIndexEditor editor = new DatabaseIndexEditor(this.myTableEditor.getState(), this.getTableModel().modelsCache.get(index, IndexEditorModel.class), this.myCaps.getIndexCaps(index.editedObject != null));
        Disposer.register((Disposable)this.myTableEditor, (Disposable)editor);
        editor.getIndexModel().addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableIndicesEditor.this.myTableEditor.updateUi();
            }
        }, this.myTableEditor);
        DatabaseIndexEditor databaseIndexEditor = editor;
        if (databaseIndexEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "createIndexEditor"));
        }
        return databaseIndexEditor;
    }

    public void updateFromModel() {
        DatabaseEditorUtil.cleanupEditors(this.myIndexModel, this.getTableModel().getIndices(), this::createIndexEditor);
        this.myTable.getTable().repaint();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "getTable"));
        }
        return deTable;
    }

    @Override
    @NotNull
    public String getTabTitle() {
        int count = this.getTableModel().getIndicesCount();
        String string = "Indices" + (count == 0 ? "" : " (" + count + ")");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "getTabTitle"));
        }
        return string;
    }

    @NotNull
    public ListTableModel<DatabaseIndexEditor> getIndicesListModel() {
        ListTableModel<DatabaseIndexEditor> listTableModel = this.myIndexModel;
        if (listTableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "getIndicesListModel"));
        }
        return listTableModel;
    }

    @Nullable
    public DatabaseEditorBaseEx getActiveEditor() {
        return DatabaseEditorUtil.getEditedItem(this.myTable, this.myIndexModel);
    }

    @NotNull
    public DatabaseEditorCapabilities.ListCapability getCaps() {
        DatabaseEditorCapabilities.ListCapability listCapability = this.myCaps.getIndices();
        if (listCapability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableIndicesEditor", "getCaps"));
        }
        return listCapability;
    }
}

