/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmMinor;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmDetail
extends DbmObject {
    @NotNull
    private final DbmMajor myMajor;
    @NotNull
    private final DbmObject myParent;

    protected DbmDetail(@NotNull DbmMajor parent, @Nullable String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/common/DbmDetail", "<init>"));
        }
        super(parent.model, name);
        this.myMajor = parent;
        this.myParent = parent;
    }

    protected DbmDetail(@NotNull DbmMinor parent, @Nullable String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/common/DbmDetail", "<init>"));
        }
        super(parent.model, name);
        this.myMajor = parent.major();
        this.myParent = parent;
    }

    protected DbmDetail(@NotNull DbmObject parent, @Nullable String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/common/DbmDetail", "<init>"));
        }
        super(parent.model, name);
        this.myParent = parent;
        if (parent instanceof DbmMajor) {
            this.myMajor = (DbmMajor)parent;
        } else if (parent instanceof DbmMinor) {
            this.myMajor = ((DbmMinor)parent).major();
        } else if (parent instanceof DbmDetail) {
            this.myMajor = ((DbmDetail)parent).major();
        } else {
            throw new IllegalArgumentException("The parent of a detail should be a major or a minor object, or another detail, but got " + parent.getClass().getSimpleName());
        }
    }

    @Override
    @NotNull
    public DbmSchema schema() {
        DbmSchema dbmSchema = this.myMajor.schema();
        if (dbmSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDetail", "schema"));
        }
        return dbmSchema;
    }

    @Override
    @NotNull
    public DbmNamespace namespace() {
        DbmNamespace dbmNamespace = this.myMajor.namespace();
        if (dbmNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDetail", "namespace"));
        }
        return dbmNamespace;
    }

    @NotNull
    public DbmMajor major() {
        DbmMajor dbmMajor = this.myMajor;
        if (dbmMajor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDetail", "major"));
        }
        return dbmMajor;
    }

    @Override
    @Nullable
    public DbmObject parent() {
        return this.myParent;
    }
}

